/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.UserFriendlyIOException;
import com.arm.streamline.analysis.gator.GatorProtocolVersion;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.GatorConnectionConstants;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.GatorTarget;
import com.arm.streamline.databrowser.ITargetXml;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.utility.AdbRunnerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class IdleTargetXml
implements ITargetXml,
Closeable {
    private Socket mSocket;
    private GatorTarget target;
    private final @NonNull TargetAddressString targetAddress;

    public IdleTargetXml(@NonNull TargetAddressString targetAddress) throws IOException {
        this.targetAddress = targetAddress;
        this.reestablishLink();
    }

    @Override
    public void close() {
        if (this.target != null) {
            try {
                this.target.disconnect();
                this.target = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.mSocket != null) {
            try {
                this.mSocket.close();
                this.mSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte @NonNull [] getConfigurationXml() throws IOException {
        return this.target.requestXML("configuration");
    }

    @Override
    public byte[] getCountersXml() throws IOException {
        return this.target.getCountersXML();
    }

    @Override
    public byte @NonNull [] getDefaultsXml() throws IOException {
        return this.target.requestXML("defaults");
    }

    @Override
    public byte[] getEventsXml() throws IOException {
        return this.target.getEventsXML();
    }

    @Override
    public @Nullable IOException sendConfigurationXml(byte[] byteArray, boolean discardPrevious) throws IOException {
        try {
            this.target.sendXML(byteArray);
            return null;
        }
        catch (IOException exception) {
            this.reestablishLink();
            return exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    private void reestablishLink() throws IOException {
        try {
            int MAX_RETRY_TIME_MS = 2500;
            int MAX_RETRY_GAP_MS = 250;
            int RETRY_COUNT = 10;
            int retryCounter = 0;
            while (retryCounter < 10) {
                this.close();
                try {
                    Object object = GatorConnectionConstants.SETUP_LOCK;
                    synchronized (object) {
                        @NonNull IPreferences appSettings = StreamlinePreferences.getApplicationPreferences();
                        this.mSocket = new Socket();
                        this.mSocket.connect(GatorSendCommandUtility.extractInetSocketAddress(this.targetAddress, AdbRunnerFactory.SINGLETON.tryCreate(appSettings.getAdbPathOrDefault(), this.targetAddress.isAndroid())), 5000);
                        this.target = new GatorTarget(this.mSocket, true);
                        this.target.pingCheck();
                        return;
                    }
                }
                catch (GatorTarget.SessionInProgressException e) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    ++retryCounter;
                }
            }
        }
        catch (UserFriendlyIOException ufioex) {
            this.close();
            throw ufioex;
        }
        catch (UnknownHostException uhe) {
            throw new IOException(String.format(DocumentsMessages.UNKNOWN_HOST, this.targetAddress), uhe);
        }
        catch (IOException exception) {
            this.close();
            throw new IOException(MessageFormat.format(DocumentsMessages.GATOR_CONNECT_FAILED, this.targetAddress, GatorProtocolVersion.getMinSupportedLiveProductVersion().getVersionString()), exception);
        }
    }
}

