/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.common.utility.io.LittleEndianDataInputStream;
import com.arm.streamline.common.xml.gatorConfig.GatorCurrentConfig;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.GatorConnectionConstants;
import com.arm.streamline.databrowser.GatorTarget;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.browser.AdbPortForwarder;
import com.arm.streamline.databrowser.browser.BrowseResult;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.model.session.Session;
import com.arm.util.ParseXMLException;
import com.arm.utils.function.IThrowingFunction;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GatorSendCommandUtility {
    private static final long WAIT_TO_TRY_AGAIN_MILLLIS = 250L;
    private static final int TIMEOUT_MILLIS = 2000;

    public static <T, E extends Throwable> T useGatorTarget(@NonNull TargetAddressString targetAddress, @Nullable IAdbProcessRunner adbProcessRunner, boolean isStreaming, @NonNull IThrowingFunction<GatorTarget, T, E> function) throws E, IOException {
        return GatorSendCommandUtility.useGatorTarget(targetAddress, adbProcessRunner, isStreaming, function, 2000, 250L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    public static <T, E extends Throwable> T useGatorTarget(@NonNull TargetAddressString targetAddress, @Nullable IAdbProcessRunner adbProcessRunner, boolean isStreaming, @NonNull IThrowingFunction<GatorTarget, T, E> function, int timeOut, long waitToTryAgain) throws E, IOException {
        int totalTriedTime = 0;
        while (true) {
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (Socket socket = new Socket();){
                    GatorTarget gatorTarget;
                    Object object = GatorConnectionConstants.SETUP_LOCK;
                    synchronized (object) {
                        InetSocketAddress address = GatorSendCommandUtility.extractInetSocketAddress(targetAddress, adbProcessRunner);
                        if (address == null) {
                            throw new IOException(String.format("Invalid target address %s", targetAddress));
                        }
                        socket.connect(address, 5000);
                        gatorTarget = new GatorTarget(socket, isStreaming);
                        gatorTarget.pingCheck();
                    }
                    return (T)function.apply((Object)gatorTarget);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GatorTarget.SessionInProgressException e) {
                try {
                    Thread.sleep(waitToTryAgain);
                    totalTriedTime = (int)((long)totalTriedTime + waitToTryAgain);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (totalTriedTime <= timeOut) continue;
                throw e;
            }
            break;
        }
    }

    public static @Nullable InetSocketAddress extractInetSocketAddress(@NonNull TargetAddressString targetAddress, @Nullable IAdbProcessRunner adbProcessRunner) throws IOException {
        if (targetAddress.isAndroid()) {
            if (adbProcessRunner == null) {
                return null;
            }
            String device = targetAddress.getAndroidSerialNumber();
            AdbPortForwarder portForwarder = new AdbPortForwarder(adbProcessRunner);
            AdbPortForwarder.AdbPortPair ports = portForwarder.getAdbDevicePorts(device);
            if (targetAddress.isAndroidOverTcp()) {
                return new InetSocketAddress("localhost", ports.tcp);
            }
            return new InetSocketAddress("localhost", ports.uds);
        }
        @Nullable TargetAuthentication.Address address = targetAddress.getTcpAddressOrDefault("", Session.DEFAULT_GATOR_PORT);
        if (address != null) {
            return new InetSocketAddress(address.hostname(), address.port());
        }
        return null;
    }

    public static @Nullable GatorCurrentConfig getGatordRunningConfig(@NonNull BrowseResult device, @Nullable IAdbProcessRunner adbProcessRunner) throws IOException {
        byte[] byteArray = (byte[])GatorSendCommandUtility.useGatorTarget(device.getTargetAddressString(), adbProcessRunner, true, gatordTarget -> {
            byte[] currentConfiguration = gatordTarget.getCurrentConfiguration();
            gatordTarget.disconnect();
            return currentConfiguration;
        });
        Throwable throwable = null;
        Object var4_5 = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(byteArray);){
            return GatorCurrentConfig.create((InputStream)stream);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public static @NonNull GatorCurrentConfig getCurrentConfig(LittleEndianDataInputStream in) throws IOException, ParseXMLException {
        ResponseStruct readResponse = GatorSendCommandUtility.readResponse(in);
        if (readResponse.control != 6) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_CONTROL_CODE, readResponse.control, "gator"));
        }
        return GatorCurrentConfig.create((InputStream)new ByteArrayInputStream(readResponse.data));
    }

    public static ResponseStruct readResponse(LittleEndianDataInputStream input) throws IOException {
        byte control = input.readByte();
        int length = input.readLEInt();
        if (length > 0x10000000 || length < 0) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_INVALID_LENGTH, length));
        }
        byte[] data = new byte[length];
        try {
            input.readFully(data);
        }
        catch (EOFException e) {
            throw new IOException(MessageFormat.format(DocumentsMessages.ERROR_READING_DATA, data.length), e);
        }
        if (control == -1 && data.length > 0) {
            String deviceMessage = new String(data);
            String errorMessage = DocumentsMessages.ERROR_FROM_TARGET + deviceMessage;
            String GATOR_ERROR_UNSUPPORTED_VERSION2 = "Invalid session.xml version: 2";
            if (deviceMessage.contains("Invalid session.xml version: 2")) {
                errorMessage = errorMessage + "\n\n" + DocumentsMessages.GATOR_UNSUPPORTED_SESSION_XML_EXTRA_ERROR_MESSAGE;
            } else {
                if (deviceMessage.contains("Session already in progress")) {
                    throw new GatorTarget.SessionInProgressException(errorMessage);
                }
                if (deviceMessage.contains("Error starting the specified application")) {
                    throw new GatorStartingActivityManagerException(errorMessage);
                }
            }
            throw new IOException(errorMessage);
        }
        return new ResponseStruct(data, control);
    }

    public static @Nullable String readLine(LittleEndianDataInputStream input) {
        int ch;
        StringBuilder buffer = new StringBuilder();
        do {
            try {
                ch = input.readUnsignedByte();
            }
            catch (IOException exception) {
                break;
            }
            if (ch <= 0 || ch == 13 || ch == 10) continue;
            buffer.append((char)ch);
        } while (ch > 0 && ch != 10);
        if (buffer.length() > 0) {
            return buffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"})
    public static @NonNull RunningGatordInfo getRunningGatordInformation(int localPort) {
        version = null;
        response = null;
        gatorCurrentConfig = null;
        couldConnect = false;
        var5_5 = GatorConnectionConstants.SETUP_LOCK;
        synchronized (var5_5) {
            try {
                var6_6 = null;
                var7_9 = null;
                try {
                    socket = new Socket(InetAddress.getLoopbackAddress(), localPort);
                    try {
                        out = socket.getOutputStream();
                        try {
                            in = new LittleEndianDataInputStream(socket.getInputStream());
                            try {
                                out.write("STREAMLINE\n".getBytes());
                                response = GatorSendCommandUtility.readLine(in);
                                message = new byte[5];
                                if (response != null) {
                                    couldConnect = true;
                                    string = response.trim().toLowerCase();
                                    if (string.startsWith("gator") && string.length() > "gator".length()) {
                                        version = string.substring("gator".length()).trim();
                                    }
                                    message[0] = 7;
                                    out.write(message);
                                    gatorCurrentConfig = GatorSendCommandUtility.getCurrentConfig(in);
                                }
                                message[0] = 4;
                                out.write(message);
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                            ** if (out == null) goto lbl-1000
                        }
                        catch (Throwable var7_10) {
                            if (var6_6 == null) {
                                var6_6 = var7_10;
                            } else if (var6_6 != var7_10) {
                                var6_6.addSuppressed(var7_10);
                            }
                            if (out != null) {
                                out.close();
                            }
                            throw var6_6;
                        }
lbl-1000:
                        // 1 sources

                        {
                            out.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (socket == null) goto lbl-1000
                    }
                    catch (Throwable var7_11) {
                        if (var6_6 == null) {
                            var6_6 = var7_11;
                        } else if (var6_6 != var7_11) {
                            var6_6.addSuppressed(var7_11);
                        }
                        if (socket != null) {
                            socket.close();
                        }
                        throw var6_6;
                    }
lbl-1000:
                    // 1 sources

                    {
                        socket.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
                catch (Throwable var7_12) {
                    if (var6_6 == null) {
                        var6_6 = var7_12;
                    } else if (var6_6 != var7_12) {
                        var6_6.addSuppressed(var7_12);
                    }
                    throw var6_6;
                }
            }
            catch (ParseXMLException | IOException var6_8) {
                // empty catch block
            }
            return new RunningGatordInfo(couldConnect, version, gatorCurrentConfig);
        }
    }

    public static class GatorStartingActivityManagerException
    extends IOException {
        public GatorStartingActivityManagerException(String message) {
            super(message);
        }
    }

    public static class ResponseStruct {
        public final byte @NonNull [] data;
        public final int control;

        public ResponseStruct(byte @NonNull [] data, int control) {
            this.data = data;
            this.control = control;
        }
    }

    public record RunningGatordInfo(boolean couldConnect, @Nullable String version, @Nullable GatorCurrentConfig currentConfig) {
    }
}

