/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.application.StreamlineImages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.IProgressMonitor;
import com.arm.streamline.gcwrapper.GC;
import com.arm.streamline.hacks.ControlHacks;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.utility.text.TextDrawing;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.FontInfo;
import com.arm.streamline.widget.Fonts;
import com.arm.streamline.widget.SafeUpdate;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DocumentPanel
extends Composite
implements Runnable,
IProgressMonitor,
MouseListener,
MouseMoveListener,
MouseTrackListener,
KeyListener,
PaintListener {
    private static final int STATUS_WIDTH = 5;
    private static final int STATUS_DIVIDER_WIDTH = 1;
    private static final int PROGRESS_HEIGHT = 5;
    private static final int VMARGIN = 6;
    private static final int HMARGIN = 8;
    private static final int HGAP = 4;
    private static final int BUTTON_HIT_SLOP = 2;
    private static final Color STATUS_READY_COLOR = Colors.create(69, 201, 238);
    private static final Color STATUS_NEEDS_ANALYSIS_COLOR = Colors.create(255, 198, 12);
    private static final Color STATUS_ERROR_COLOR = Colors.create(255, 100, 58);
    private static final Color PROGRESS_FILL_TOP_COLOR = Colors.create(128, 150, 178);
    private static final Color PROGRESS_FILL_BOTTOM_COLOR = Colors.create(77, 99, 127);
    private static final Color PROGRESS_TOP_COLOR = Colors.create(224, 224, 224);
    private static final Color PROGRESS_BOTTOM_COLOR = Colors.create(240, 240, 240);
    private static final Color DIVIDER_COLOR = Colors.isDarkModeUI() ? Colors.darken(Colors.getWidgetBackground(), 40) : PROGRESS_BOTTOM_COLOR;
    private DocumentsView mOwner;
    final @NonNull ICapture mDocument;
    private Rectangle mDisclosureHitArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mStopHitArea = new Rectangle(0, 0, 0, 0);
    private Rectangle mOptionsHitArea = new Rectangle(0, 0, 0, 0);
    private boolean mExpanded;
    private boolean mInDisclosureClick;
    private boolean mInOptionsClick;
    private boolean mInOptionsDownClick;
    private boolean mInStopClick;
    private boolean mInStopDownClick;
    private String mToolTip;

    public static final int getTypicalHeight() {
        int margin = 6;
        return margin + FontInfo.get(Fonts.getNormal()).getHeight() + margin;
    }

    public DocumentPanel(DocumentsView owner, Composite parent, @NonNull ICapture document, boolean startExpanded) {
        super(parent, 0x20000000);
        this.mOwner = owner;
        this.mDocument = document;
        this.mExpanded = startExpanded;
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this);
        ControlHacks.setBackground((Control)this, Colors.getWidgetBackground());
        this.mToolTip = this.mDocument.toString();
        this.mDocument.setProgressMonitor(this);
        if (!this.mDocument.isValid()) {
            this.mToolTip = this.mDocument.getInvalidReason();
            if (this.mToolTip == null || this.mToolTip.isEmpty()) {
                this.mToolTip = DocumentsMessages.BAD_DATA;
            }
        }
        this.setToolTipText(this.mToolTip);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addKeyListener(this);
        this.addPaintListener(this);
        this.mOwner.createContextMenu((Control)this);
        ControlHacks.setBackground((Control)this.mOwner.mScroller, Colors.getWidgetBackground());
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        FontInfo fontInfo = FontInfo.get(Fonts.getNormal());
        int width = fontInfo.getWidth(this.mDocument.toString());
        int height = 6 + fontInfo.getHeight() + 6;
        if (this.mExpanded) {
            fontInfo = FontInfo.get(Fonts.getSmall());
            int smallFontHeight = fontInfo.getHeight();
            Lines[] linesArray = Lines.values();
            int n = linesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Lines line = linesArray[n2];
                String text = this.getExpandedLine(line);
                if (!text.isEmpty()) {
                    height += smallFontHeight;
                    width = Math.max(width, fontInfo.getWidth(text));
                }
                ++n2;
            }
            height += fontInfo.getLeading();
        }
        if (this.mDocument.isInProgress()) {
            height += 5;
        }
        width += 14 + StreamlinePlugin.getImage((String)StreamlineImages.DISCLOSURE_UP).getBounds().x + 8;
        return new Point(width += 4 + StreamlinePlugin.getImage((String)"Refresh.png").getBounds().width + 8, height + 1);
    }

    public ICapture getDocument() {
        return this.mDocument;
    }

    public DocumentsView getOwner() {
        return this.mOwner;
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public void keyPressed(KeyEvent event) {
        this.mOwner.handleKeyDown(event);
    }

    public void keyReleased(KeyEvent event) {
    }

    public void mouseDoubleClick(MouseEvent event) {
        boolean isPlaceholder;
        boolean bl = isPlaceholder = this.mDocument instanceof ILiveCapture && ((ILiveCapture)this.mDocument).isPlaceholder();
        if (event.button == 1 && !isPlaceholder && !this.inAnyHitArea(event.x, event.y)) {
            DocumentsView.open(this.mDocument);
        }
    }

    public void mouseDown(MouseEvent event) {
        if (event.button == 1 && this.mOptionsHitArea.contains(event.x, event.y) && !this.mDocument.isInProgress()) {
            this.mInOptionsClick = true;
            this.mInOptionsDownClick = true;
            this.redraw();
        } else if (event.button == 1 && this.mStopHitArea.contains(event.x, event.y)) {
            this.mInStopClick = true;
            this.mInStopDownClick = true;
            this.redraw();
        } else if (event.button == 1 && this.mDisclosureHitArea.contains(event.x, event.y)) {
            this.mInDisclosureClick = true;
        } else {
            this.mOwner.handleMouseDown(event, this.mDocument);
        }
    }

    public void mouseEnter(MouseEvent event) {
        this.updateCursorAndTooltipForLocation(event.x, event.y);
    }

    public void mouseExit(MouseEvent event) {
    }

    public void mouseHover(MouseEvent event) {
        this.updateCursorAndTooltipForLocation(event.x, event.y);
    }

    public void mouseMove(MouseEvent event) {
        this.updateCursorAndTooltipForLocation(event.x, event.y);
        if (this.mInOptionsClick || this.mInStopClick) {
            this.redraw();
        }
    }

    public void mouseUp(MouseEvent event) {
        boolean wasInOptionsClick = this.mInOptionsClick;
        boolean wasInStopClick = this.mInStopClick;
        this.mInOptionsClick = false;
        this.mInOptionsDownClick = false;
        this.mInStopClick = false;
        this.mInStopDownClick = false;
        this.redraw();
        if (event.button == 1 && wasInOptionsClick && !this.mDocument.isInProgress()) {
            if (this.mOptionsHitArea.contains(event.x, event.y)) {
                DocumentsView.analyze(this.mDocument);
            }
        } else if (event.button == 1 && wasInStopClick) {
            if (this.mStopHitArea.contains(event.x, event.y)) {
                this.mDocument.stop(false);
                this.stopped();
            }
        } else if (event.button == 1 && this.mInDisclosureClick) {
            if (this.mDisclosureHitArea.contains(event.x, event.y)) {
                this.mExpanded = !this.mExpanded;
                SafeUpdate.pack(this.getParent());
                this.updateCursorAndTooltipForLocation(event.x, event.y);
                this.mOwner.adjustActions();
            }
        } else {
            this.mOwner.handleMouseUp();
        }
        this.mInDisclosureClick = false;
    }

    public void paintControl(PaintEvent event) {
        int y;
        boolean isPlaceholder;
        GC gc = new GC(event.gc);
        Rectangle bounds = this.getClientArea();
        boolean selected = this.mOwner.isSelected(this.mDocument);
        gc.setBackground(selected ? Colors.getSelection(true) : this.getBackground());
        gc.fillRectangle(bounds);
        boolean bl = isPlaceholder = this.mDocument instanceof ILiveCapture && ((ILiveCapture)this.mDocument).isPlaceholder();
        Color statusColor = isPlaceholder ? STATUS_NEEDS_ANALYSIS_COLOR : (this.mDocument.isValid() ? (this.mDocument.hasReport(true) ? STATUS_READY_COLOR : STATUS_NEEDS_ANALYSIS_COLOR) : STATUS_ERROR_COLOR);
        gc.setBackground(statusColor);
        gc.fillRectangle(bounds.x, bounds.y, 5, bounds.height);
        gc.setForeground(DIVIDER_COLOR);
        gc.drawLine(bounds.x + 5, bounds.y, bounds.x + 5, bounds.y + bounds.height);
        Font font = Fonts.getNormal();
        gc.setFont(font);
        FontInfo fontInfo = FontInfo.get(font);
        this.mStopHitArea.width = 0;
        this.mStopHitArea.height = 0;
        if (this.mDocument.isInProgress()) {
            int x = bounds.x + 5 + 1;
            int y2 = bounds.y + bounds.height - 5;
            int fullWidth = bounds.width - 6;
            double progress = this.mDocument.getProgress() / 100.0;
            if (progress > 0.0) {
                int filledWidth = (int)(progress * (double)fullWidth);
                int unfilledWidth = fullWidth - filledWidth;
                if (unfilledWidth > 0) {
                    gc.setForeground(PROGRESS_TOP_COLOR);
                    gc.setBackground(PROGRESS_BOTTOM_COLOR);
                    gc.fillGradientRectangle(x + filledWidth, y2, unfilledWidth, 5, true);
                }
                if (filledWidth > 0) {
                    gc.setForeground(PROGRESS_FILL_TOP_COLOR);
                    gc.setBackground(PROGRESS_FILL_BOTTOM_COLOR);
                    gc.fillGradientRectangle(x, y2, filledWidth, 5, true);
                }
            } else {
                Image img = StreamlinePlugin.getImage("BusyBar.png");
                int step = img.getBounds().width;
                x = (int)((long)x - System.currentTimeMillis() / 20L % (long)step);
                while (x < y2 + fullWidth) {
                    gc.drawImage(img, x, y2);
                    x += step;
                }
                Task.scheduleOnUIThread((Runnable)this, (String)("dp" + this.hashCode()), (long)100L, (java.util.concurrent.TimeUnit)java.util.concurrent.TimeUnit.MILLISECONDS);
            }
            if (this.mDocument.isStoppable()) {
                if (isPlaceholder) {
                    this.drawStopHitAreaImage(gc, bounds, fontInfo, this.mInStopDownClick ? "StopSelected.png" : "Stop.png");
                } else {
                    this.drawStopHitAreaImage(gc, bounds, fontInfo, this.mInStopDownClick ? "DiscardSelected.png" : "Discard.png");
                }
            }
        }
        Image image = StreamlinePlugin.getImage(this.mExpanded ? StreamlineImages.DISCLOSURE_DOWN : StreamlineImages.DISCLOSURE_UP);
        Rectangle imageBounds = image.getBounds();
        this.mDisclosureHitArea.x = bounds.x + 5 + 8;
        this.mDisclosureHitArea.y = bounds.y + 6 + (fontInfo.getHeight() - imageBounds.height) / 2;
        gc.drawImage(image, this.mDisclosureHitArea.x, this.mDisclosureHitArea.y);
        this.mDisclosureHitArea.x -= 2;
        this.mDisclosureHitArea.y -= 2;
        this.mDisclosureHitArea.width = 2 + imageBounds.width + 2;
        this.mDisclosureHitArea.height = 2 + imageBounds.height + 2;
        int x = bounds.x + 5 + 1 + 8 + imageBounds.width + 5;
        Image gearIcon = StreamlinePlugin.getImage(this.mInOptionsDownClick ? "RefreshSelected.png" : "Refresh.png");
        Rectangle gearBounds = gearIcon.getBounds();
        int maxTextWidth = bounds.width - (14 + imageBounds.width + 8 + 4 + gearBounds.width + 8);
        gc.setForeground(Colors.getText(selected));
        TextDrawing.drawString(gc, TextDrawing.truncateString(font, this.mDocument.toString(), maxTextWidth, 131072), x, bounds.y + 6, 16384);
        this.mToolTip = this.mDocument.toString();
        this.mOptionsHitArea.width = 0;
        this.mOptionsHitArea.height = 0;
        if (this.mExpanded) {
            y = bounds.y + 6 + fontInfo.getHeight();
            font = Fonts.getSmall();
            gc.setFont(font);
            fontInfo = FontInfo.get(font);
            Lines[] linesArray = Lines.values();
            int n = linesArray.length;
            int n2 = 0;
            while (n2 < n) {
                Lines line = linesArray[n2];
                String text = this.getExpandedLine(line);
                if (!text.isEmpty()) {
                    TextDrawing.drawString(gc, TextDrawing.truncateString(font, text, maxTextWidth, 131072), x, y, 16384);
                    y += fontInfo.getHeight();
                    this.mToolTip = String.valueOf(this.mToolTip) + "\n" + text;
                }
                ++n2;
            }
            if (!isPlaceholder && this.mDocument.isValid()) {
                this.mOptionsHitArea.x = bounds.x + bounds.width - (gearBounds.width + 8);
                this.mOptionsHitArea.y = bounds.y + bounds.height - (gearBounds.height + 12);
                if (!this.mDocument.isInProgress()) {
                    gc.drawImage(gearIcon, this.mOptionsHitArea.x, this.mOptionsHitArea.y);
                }
                this.mOptionsHitArea.x -= 2;
                this.mOptionsHitArea.y -= 2;
                this.mOptionsHitArea.width = 2 + gearBounds.width + 2;
                this.mOptionsHitArea.height = 2 + gearBounds.height + 2;
            }
        }
        y = bounds.y + bounds.height - 1;
        gc.setForeground(DIVIDER_COLOR);
        gc.drawLine(bounds.x - 1, y, bounds.x + bounds.width, y);
    }

    private void drawStopHitAreaImage(GC gc, Rectangle bounds, FontInfo fontInfo, String imageName) {
        Image image = StreamlinePlugin.getImage(imageName);
        Rectangle imageBounds = image.getBounds();
        this.mStopHitArea.x = bounds.x + bounds.width - (imageBounds.width + 8);
        this.mStopHitArea.y = bounds.y + 6 + (fontInfo.getHeight() - imageBounds.height) / 2;
        gc.drawImage(image, this.mStopHitArea.x, this.mStopHitArea.y);
        this.mStopHitArea.x -= 2;
        this.mStopHitArea.y -= 2;
        this.mStopHitArea.width = 2 + imageBounds.width + 2;
        this.mStopHitArea.height = 2 + imageBounds.height + 2;
    }

    @Override
    public void progressUpdated() {
        this.mOwner.reLayout();
        SafeUpdate.redraw((Control)this);
    }

    @Override
    public void run() {
        if (!this.isDisposed()) {
            this.redraw();
        }
    }

    public void setExpanded(boolean expanded) {
        this.mExpanded = expanded;
    }

    public void stopped() {
        if (!this.isDisposed()) {
            SafeUpdate.pack(this.getParent());
        }
    }

    private String getExpandedLine(Lines which) {
        StringBuilder buffer = new StringBuilder();
        boolean isPlaceholder = this.mDocument instanceof ILiveCapture && ((ILiveCapture)this.mDocument).isPlaceholder();
        switch (which) {
            case DURATION_CREATION_DATE: {
                if (isPlaceholder) break;
                long createdOn = this.mDocument.getCreatedOnSeconds();
                if (createdOn == -1L) {
                    buffer.append(this.mDocument.isDataMissing() ? DocumentsMessages.DATA_MISSING : DocumentsMessages.UNKNOWN);
                    break;
                }
                long duration = this.mDocument.getDurationInTimeUnits();
                @Nullable TimeUnit timeUnit = this.mDocument.getTimeUnit();
                if (duration > 0L && timeUnit != null) {
                    buffer.append(timeUnit.formatInBase((double)duration, 1000.0, TimeUnit.Style.SYMBOL_UNIT, false));
                    buffer.append(DocumentsMessages.AT);
                }
                buffer.append(DateFormat.getDateTimeInstance(2, 2).format(new Date(createdOn * 1000L)));
                break;
            }
            case VERSION: {
                buffer.append(this.mDocument.getHumanReadableVersion());
                break;
            }
            case TARGET_DESCRIPTION: {
                buffer.append(this.mDocument.getTargetDescription());
                break;
            }
            case RESOLUTION_EBS_SAMPLE_RATE: {
                if (isPlaceholder || !this.mDocument.isValid()) break;
                ResolutionMode resolutionMode = this.mDocument.getResolutionMode();
                if (resolutionMode != null) {
                    switch (resolutionMode) {
                        case SUMMARY: 
                        case NORMAL: {
                            buffer.append(DocumentsMessages.MILLISECOND);
                            break;
                        }
                        case HIGH: 
                        case ULTRAHIGH: {
                            buffer.append(DocumentsMessages.MICROSECOND);
                            break;
                        }
                        default: {
                            throw new AssertionError(resolutionMode);
                        }
                    }
                }
                if (this.mDocument.usesEBS()) {
                    if (buffer.length() > 0) {
                        buffer.append(DocumentsMessages.SEPARATOR);
                    }
                    buffer.append(DocumentsMessages.USES_EBS);
                }
                if (this.mDocument.getSampleRate() == SampleRate.NORMAL) break;
                if (buffer.length() > 0) {
                    buffer.append(DocumentsMessages.SEPARATOR);
                }
                buffer.append(DocumentsMessages.SAMPLE_RATE);
                buffer.append(" ");
                buffer.append((Object)this.mDocument.getSampleRate());
                break;
            }
            case PATH: {
                buffer.append(this.mDocument.getApcDirectory().getParent());
                break;
            }
        }
        return buffer.toString();
    }

    private boolean inAnyHitArea(int x, int y) {
        return this.mOptionsHitArea.contains(x, y) && !this.mDocument.isInProgress() || this.mStopHitArea.contains(x, y) || this.mDisclosureHitArea.contains(x, y);
    }

    private void updateCursorAndTooltipForLocation(int x, int y) {
        String tooltip;
        this.setCursor(this.getDisplay().getSystemCursor(this.inAnyHitArea(x, y) ? 21 : 0));
        this.mInOptionsDownClick = false;
        this.mInStopDownClick = false;
        if (this.mOptionsHitArea.contains(x, y) && !this.mDocument.isInProgress()) {
            tooltip = DocumentsMessages.OPTIONS_TOOLTIP;
            this.mInOptionsDownClick = this.mInOptionsClick;
        } else if (this.mStopHitArea.contains(x, y)) {
            if (this.mDocument.isInProgress()) {
                boolean isPlaceholder = this.mDocument instanceof ILiveCapture && ((ILiveCapture)this.mDocument).isPlaceholder();
                tooltip = isPlaceholder ? DocumentsMessages.STOP_CAPTURE_TOOLTIP : DocumentsMessages.CANCEL_ANALYSIS_TOOLTIP;
            } else {
                tooltip = "";
            }
            this.mInStopDownClick = this.mInStopClick;
        } else {
            tooltip = this.mToolTip;
        }
        if (!tooltip.equals(this.getToolTipText())) {
            this.setToolTipText(tooltip);
        }
    }

    private static enum Lines {
        DURATION_CREATION_DATE,
        VERSION,
        TARGET_DESCRIPTION,
        RESOLUTION_EBS_SAMPLE_RATE,
        PATH;

    }
}

