/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.databrowser.AndroidDeviceException;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.IBasicInteractiveShell;
import com.arm.streamline.deviceconn.adb.AdbDeviceRootMode;
import com.arm.streamline.deviceconn.adb.IAdbCommandRunner;
import com.arm.streamline.deviceconn.adb.IAdbProcessRunner;
import com.arm.streamline.deviceconn.ssh.ISshCommandRunner;
import com.arm.streamline.utility.AdbRunnerFactory;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public final class DeviceABIDetector {
    private static final String NO_TERMINAL_WRAPPER_ERROR = "Could not find terminal wrapper on device.\n\nPlease unplug and reconnect the device.";
    private static final String TERMINAL_WRAPPER_PATH = "/data/local/tmp/terminal_wrapper";

    public static @NonNull DeviceABI getLinuxDeviceABI(@NonNull ISshCommandRunner commandRunner) throws IOException {
        IBasicInteractiveShell.InteractiveCommandResult uname = commandRunner.runCommandAndGetOutput("uname", new String[]{"-m"});
        if (uname.status.isSuccessful()) {
            for (String line : uname.output) {
                if (line.contains(DeviceABI.ARM64.uname)) {
                    return DeviceABI.ARM64;
                }
                if (line.contains(DeviceABI.ARM32.uname)) {
                    return DeviceABI.ARM32;
                }
                if (!line.contains(DeviceABI.X86_64.uname)) continue;
                return DeviceABI.X86_64;
            }
        }
        IBasicInteractiveShell.InteractiveCommandResult lscpu = commandRunner.runCommandAndGetOutput("lscpu", new String[0]);
        if (lscpu.status.isSuccessful()) {
            for (String line : lscpu.output) {
                if (!line.startsWith("Architecture:")) continue;
                if (line.contains(DeviceABI.ARM64.uname)) {
                    return DeviceABI.ARM64;
                }
                if (line.contains(DeviceABI.ARM32.uname)) {
                    return DeviceABI.ARM32;
                }
                if (!line.contains(DeviceABI.X86_64.uname)) continue;
                return DeviceABI.X86_64;
            }
        }
        return DeviceABI.UNKNOWN;
    }

    public static @NonNull DeviceABI getAndroidDeviceABI(@NonNull IAdbCommandRunner commandRunner) throws IOException, AndroidDeviceException {
        AdbDeviceRootMode deviceRootMode = commandRunner.detectRootMode();
        IAdbCommandRunner.WrapMode wrapMode = IAdbCommandRunner.rootWrapModeOrDefault((AdbDeviceRootMode)deviceRootMode);
        IBasicInteractiveShell.InteractiveCommandResult result = commandRunner.runCommandAndGetOutput(wrapMode, "getprop", new String[]{"ro.product.cpu.abilist"});
        if (!result.status.isSuccessful()) {
            if (!commandRunner.runCommandAndGetOutput((String)"test", (String[])new String[]{"-f /data/local/tmp/terminal_wrapper"}).status.isSuccessful()) {
                throw new AndroidDeviceException(NO_TERMINAL_WRAPPER_ERROR);
            }
            throw new AndroidDeviceException("Could not determine device abi support: " + result.errorsAndOutputJoined());
        }
        List<String> supportedAbis = Arrays.asList(result.errorsOrOutputJoined().split(","));
        for (String supportedAbi : supportedAbis) {
            if (supportedAbi.contentEquals("arm64-v8a")) {
                return DeviceABI.ARM64;
            }
            if (supportedAbi.contentEquals("armeabi-v7a")) {
                return DeviceABI.ARM32;
            }
            if (!supportedAbi.contentEquals("x86_64")) continue;
            return DeviceABI.X86_64;
        }
        return DeviceABI.UNKNOWN;
    }

    public static @NonNull DeviceABI getAndroidDeviceABI(@NonNull IAdbProcessRunner adbProcessRunner, @NonNull TargetAddressString targetAddressString) throws IOException, AndroidDeviceException {
        if (targetAddressString.isAndroid()) {
            IAdbCommandRunner adbCommandRunner = AdbRunnerFactory.SINGLETON.create(adbProcessRunner, targetAddressString.getAndroidSerialNumber());
            return DeviceABIDetector.getAndroidDeviceABI(adbCommandRunner);
        }
        return DeviceABI.UNKNOWN;
    }

    public static enum DeviceABI {
        ARM64("aarch64"),
        ARM32("arm"),
        X86_64("x86_64"),
        UNKNOWN;

        public final @NonNull String uname;

        private DeviceABI() {
            this("");
        }

        private DeviceABI(String uname) {
            this.uname = uname;
        }

        public @NonNull String toString() {
            return this.name();
        }
    }
}

