/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

class DeleteJob
extends Job {
    private final List<ICapture> mDocuments;

    DeleteJob(List<ICapture> documents) {
        super(DocumentsMessages.DELETING_TITLE);
        this.setUser(true);
        this.setSystem(false);
        this.mDocuments = new ArrayList<ICapture>(documents);
    }

    protected IStatus run(IProgressMonitor monitor) {
        int count = this.mDocuments.size();
        monitor.beginTask(count == 1 ? MessageFormat.format(DocumentsMessages.DELETING_ONE, this.mDocuments.get(0)) : MessageFormat.format(DocumentsMessages.DELETING_MULTIPLE, NumberUtils.format((long)count)), count);
        try {
            ArrayList<@Nullable File> files = new ArrayList<File>(count);
            int i = 0;
            while (i < count) {
                ICapture doc = this.mDocuments.get(i);
                try {
                    @Nullable File apcDirectory = StreamlineFileUtils.prepareForDelete(doc.getApcDirectory());
                    if (apcDirectory != null) {
                        files.add(i, apcDirectory);
                    }
                }
                catch (IOException e) {
                    files.add(i, doc.getApcDirectory());
                }
                ++i;
            }
            DocumentScanner.INSTANCE.update(true);
            ArrayList<@NonNull E> failedToDelete = new ArrayList();
            int i2 = 0;
            while (i2 < Math.min(files.size(), count)) {
                @Nullable File file = (File)files.get(i2);
                if (file != null) {
                    monitor.subTask(this.mDocuments.get(i2).toString());
                    failedToDelete.addAll(FileUtils.delete((File)file));
                }
                monitor.worked(1);
                ++i2;
            }
            if (!failedToDelete.isEmpty()) {
                Status status = new Status(4, "com.arm.streamline", MessageFormat.format(DocumentsMessages.UNABLE_TO_DELETE, failedToDelete.stream().map(f -> f.getAbsolutePath()).collect(Collectors.joining(", "))), null);
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

