/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.preferences.AndroidDevicePreference;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.counterconfig.ImportTemplateAction;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.IConfigurer;
import com.arm.streamline.databrowser.ITargetXml;
import com.arm.streamline.databrowser.IdleTargetXml;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.databrowser.TargetUtils;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.streamline.model.templates.TemplatePath;
import com.arm.streamline.model.templates.TemplateUtils;
import com.arm.streamline.utility.GpuTimelineEventsUtil;
import com.arm.utils.collections.Pair;
import gnu.trove.set.TIntSet;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ConfigureTargetHandler
implements IConfigurer {
    private final @NonNull TargetAddressString targetAddress;

    public ConfigureTargetHandler(@NonNull TargetAddressString targetAddress) {
        this.targetAddress = targetAddress;
    }

    @Override
    public void configureTarget(@NonNull SubMonitor monitor) throws IOException {
        monitor.setTaskName(DocumentsMessages.MESSAGE_CONFIGURING_TARGET);
        Throwable throwable = null;
        Object var3_4 = null;
        try (IdleTargetXml targetXml = new IdleTargetXml(this.targetAddress);){
            if (AndroidDevicePreference.getProfileWithMaliCounters((String)this.targetAddress.getAndroidSerialNumber())) {
                monitor.subTask(DocumentsMessages.MESSAGE_FINDING_GPU_ON_DEVICE);
                CounterNames counterNames = new CounterNames();
                counterNames.load(new ByteArrayInputStream(targetXml.getCountersXml()));
                CounterConfiguration counterConfigs = new CounterConfiguration(targetXml);
                @Nullable String gpuPublicName = counterConfigs.getConfigurations().getGpuPublicName();
                String matchedGpu = TargetUtils.findSupportedGpuFromCounterNamesAndPublicName(counterNames, gpuPublicName);
                if (matchedGpu != null && !matchedGpu.isBlank()) {
                    ConfigureTargetHandler.configureGpuTarget(targetXml, matchedGpu, monitor, counterNames);
                } else {
                    ConfigureTargetHandler.applyDefaultTemplate(monitor, targetXml);
                }
            } else {
                ConfigureTargetHandler.applyDefaultTemplate(monitor, targetXml);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void applyDefaultTemplate(@NonNull SubMonitor monitor, @NonNull IdleTargetXml targetXml) throws IOException {
        if (!monitor.isCanceled()) {
            CounterConfiguration config = new CounterConfiguration(targetXml, false);
            if (!monitor.isCanceled()) {
                config.loadDefaults();
                config.save(true);
            }
        }
    }

    private static void configureGpuTarget(@NonNull ITargetXml targetXml, @NonNull String gpuName, @NonNull SubMonitor monitor, @NonNull CounterNames counterNames) throws IOException {
        if (!monitor.isCanceled()) {
            monitor.subTask(MessageFormat.format(DocumentsMessages.MESSAGE_FOUND_GPU_ON_DEVICE, gpuName));
            TemplatePath availableFromBultInTemplates = TemplateUtils.getTemplateFromBuiltIn(gpuName);
            if (availableFromBultInTemplates != null) {
                byte @NonNull [] eventsXml = targetXml.getEventsXml();
                @NonNull List<@NonNull String> speIds = counterNames.getSpeIds();
                if (!monitor.isCanceled()) {
                    monitor.subTask(MessageFormat.format(DocumentsMessages.MESSAGE_APPLYING_COUNTERS, gpuName));
                    if (!monitor.isCanceled()) {
                        Events events = Events.create((InputStream)new ByteArrayInputStream(eventsXml), counterNames::contains, speIds::contains, counterNames.getClusterNames(), (boolean)false);
                        TemplateFile templateFile = new TemplateFile(availableFromBultInTemplates, (Map<String, TIntSet>)events.getSourceToClusterIdMap());
                        CounterConfiguration config = new CounterConfiguration(targetXml, false);
                        GpuTimelineEventsUtil.pruneFromTemplateIfUnsupported(events, templateFile);
                        config.getConfigurations().setGpuPublicName(gpuName);
                        Pair<String, String> warning = ImportTemplateAction.addTemplate(config, templateFile);
                        if (warning != null) {
                            CommonPlugin.warning((String)String.format((String)warning.first, warning.second));
                        }
                        config.save(true);
                    }
                }
            }
        }
    }
}

