/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.CountersOutline;
import com.arm.streamline.databrowser.CaptureControlToolbar;
import com.arm.streamline.databrowser.CountersPanel;
import com.arm.streamline.databrowser.DeviceConnectionModel;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.IDeviceConnectionModel;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.live.LiveCaptureUiUtils;
import com.arm.streamline.live.LiveContent;
import com.arm.streamline.live.LiveEditor;
import com.arm.streamline.model.live.CaptureInput;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.utils.NullChecking;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class CaptureControlView
extends ViewPart
implements ICaptureProxy {
    public static final @NonNull String ID = "streamline.view.TargetView";
    private @Nullable LiveEditor currentLiveEditor = null;
    private @Nullable CountersPanel mCountersPanel = null;
    private @NonNull Composite mParent;
    private CaptureControlToolbar mToolbar;
    private @Nullable CaptureInput lastCaptureInput;
    private @Nullable LiveContent previousLiveContent;
    private final @NonNull IDeviceConnectionModel deviceConnectionModel = DeviceConnectionModel.get();

    public static @NonNull Optional<CountersOutline> getCounterDropTarget() {
        return Optional.ofNullable(CaptureControlView.getView()).map(v -> v.mCountersPanel).map(CountersPanel::getCounterDropTarget);
    }

    public static @Nullable CaptureControlView getView() {
        IWorkbenchPage page;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
            return (CaptureControlView)page.findView(ID);
        }
        return null;
    }

    public static final void makeVisible() {
        if (PlatformUI.isWorkbenchRunning()) {
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(() -> {
                    CaptureControlView captureControlView = CaptureControlView.showView();
                });
            } else {
                CaptureControlView.showView();
            }
        }
    }

    public static final CaptureControlView showView() {
        try {
            IWorkbenchPage page;
            IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (workbenchWindow != null && (page = workbenchWindow.getActivePage()) != null) {
                return (CaptureControlView)page.showView(ID, null, 2);
            }
        }
        catch (Exception exception) {
            CommonPlugin.error((String)"Unable to display view: streamline.view.TargetView", (Throwable)exception);
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.mParent = (Composite)NullChecking.neverNull((Object)parent);
        GridLayoutFactory.fillDefaults().spacing(0, 0).applyTo(parent);
        this.mToolbar = new CaptureControlToolbar(parent, this.deviceConnectionModel);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mToolbar);
        this.deviceConnectionModel.addCaptureStateProxy(this);
    }

    public void dispose() {
        this.deviceConnectionModel.removeCaptureStateProxy(this);
        super.dispose();
    }

    public CaptureControlToolbar getToolbar() {
        return this.mToolbar;
    }

    public void setFocus() {
        this.mToolbar.setFocus();
    }

    private void refreshCountersPanel(boolean isEnableStart) {
        if (this.mCountersPanel != null) {
            this.mCountersPanel.dispose();
            this.mCountersPanel = null;
        }
        LiveEditor currentLiveEditor = this.currentLiveEditor;
        if (isEnableStart) {
            this.mToolbar.setTargetIsActive(false, null, null);
        } else if (currentLiveEditor != null) {
            @NonNull CounterConfiguration config = currentLiveEditor.getTargetLauncher().getCountersConfiguration();
            @NonNull LiveContent liveContent = currentLiveEditor.getContent();
            this.mCountersPanel = new CountersPanel(this.mParent, config, liveContent);
            this.mToolbar.setTargetIsActive(true, config, liveContent);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.mCountersPanel);
        }
        if (!this.mParent.isDisposed()) {
            this.mParent.requestLayout();
        }
    }

    private void clearCurrentLiveEditorAndCounterPanel(boolean isEnableStart) {
        Task.scheduleOnUIThread(() -> {
            this.currentLiveEditor = null;
            this.refreshCountersPanel(isEnableStart);
            this.setPartName(null);
        });
    }

    @Override
    public void captureError(String msg) {
        this.clearCurrentLiveEditorAndCounterPanel(true);
    }

    @Override
    public void captureError(@NonNull Throwable t) {
        this.clearCurrentLiveEditorAndCounterPanel(true);
    }

    @Override
    public void captureFinished(boolean isDicarded) {
        this.lastCaptureInput = null;
        this.clearCurrentLiveEditorAndCounterPanel(true);
    }

    @Override
    public void captureStarted(ILiveCapture doc, LiveCaptureDataProvider live, IPreferences settings, boolean discard) {
        Task.scheduleOnUIThread(() -> {
            this.setPartName(null);
            boolean editorFound = false;
            IWorkbenchWindow[] activeWorkbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (activeWorkbenchWindows != null && !(editorFound = this.findAndUpdateLiveEditor(doc, activeWorkbenchWindows)) && doc.isValid()) {
                this.openAndUpdateActiveEditor(doc, live, settings, discard);
            }
        });
    }

    private void openAndUpdateActiveEditor(ILiveCapture doc, LiveCaptureDataProvider live, IPreferences settings, boolean discard) {
        if (this.lastCaptureInput != null) {
            @NonNull CaptureInput reusedEditorInput = (CaptureInput)NullChecking.neverNull((Object)this.lastCaptureInput);
            @NonNull String editorApcPath = reusedEditorInput.getTargetLauncher().getOutputPath();
            try {
                if (doc.getApcDirectory().getCanonicalPath().equals(new File(editorApcPath).getCanonicalPath())) {
                    CaptureInput input = new CaptureInput(reusedEditorInput.getTargetLauncher());
                    IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        LiveEditor openEditor = (LiveEditor)activePage.openEditor((IEditorInput)input, "com.arm.streamline.live");
                        openEditor.captureStarted(doc, live, settings, discard);
                        this.currentLiveEditor = openEditor;
                        this.lastCaptureInput = input;
                        this.setPartName(input.getTargetLauncher().getSession().getTargetAddress());
                        this.refreshCountersPanel(false);
                    }
                    catch (PartInitException exception) {
                        CommonPlugin.error((Throwable)exception);
                    }
                }
            }
            catch (IOException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
    }

    private void setPartName(@Nullable TargetAddressString targetAddress) {
        if (targetAddress != null) {
            this.setPartName(MessageFormat.format(DocumentsMessages.LIVE_TARGET_TAB_TITLE, targetAddress));
        } else {
            this.setPartName(DocumentsMessages.LIVE_TARGET_TAB_TITLE_NO_CAPTURE);
        }
    }

    private boolean findAndUpdateLiveEditor(ILiveCapture doc, IWorkbenchWindow[] activeWorkbenchWindows) {
        @NonNull AtomicBoolean editorFound = new AtomicBoolean(false);
        Arrays.asList(activeWorkbenchWindows).forEach(workBenchWindow -> Arrays.asList(workBenchWindow.getPages()).forEach(activePage -> editorFound.set(Arrays.asList(activePage.getEditorReferences()).stream().anyMatch(editorRef -> {
            LiveEditor liveEditor;
            IEditorInput input;
            @NonNull IEditorPart editor = editorRef.getEditor(false);
            if (editor instanceof LiveEditor && (input = (liveEditor = (LiveEditor)editor).getEditorInput()) instanceof CaptureInput) {
                @NonNull String editorApcPath = ((CaptureInput)input).getTargetLauncher().getOutputPath();
                try {
                    if (doc.getApcDirectory().getCanonicalPath().equals(new File(editorApcPath).getCanonicalPath())) {
                        this.currentLiveEditor = liveEditor;
                        this.lastCaptureInput = (CaptureInput)liveEditor.getEditorInput();
                        this.setPartName(liveEditor.getTargetLauncher().getSession().getTargetAddress());
                        this.refreshCountersPanel(false);
                        return true;
                    }
                }
                catch (IOException exception) {
                    CommonPlugin.error((Throwable)exception);
                }
            }
            return false;
        }))));
        return editorFound.get();
    }

    @Override
    public void captureStopped(@NonNull ILiveCapture doc, boolean discard) {
        if (this.previousLiveContent != null && this.previousLiveContent.isSaveAndAnalyse()) {
            @NonNull LiveContent neverNull = (LiveContent)NullChecking.neverNull((Object)this.previousLiveContent);
            @NonNull SessionProcessor sessionProcessor = new SessionProcessor();
            LiveCaptureUiUtils.saveEditorStateAndOpenAnalysedEditor(neverNull, doc, discard, sessionProcessor);
        }
        this.clearCurrentLiveEditorAndCounterPanel(false);
    }

    @Override
    public void liveError(String msg) {
    }

    @Override
    public void liveWarning(@NonNull WarningItem msg) {
    }

    @Override
    public void stopLiveRequestSend() {
        if (this.currentLiveEditor != null) {
            this.previousLiveContent = this.currentLiveEditor.getContent();
        }
        this.clearCurrentLiveEditorAndCounterPanel(false);
    }
}

