/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.database.stream.factory.DatabaseLayout;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.databrowser.DocumentsView;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.databrowser.ICapture;
import com.arm.streamline.databrowser.IProgressMonitor;
import com.arm.streamline.databrowser.IProgressObserver;
import com.arm.streamline.databrowser.IStopHandler;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.model.StateFile;
import com.arm.streamline.utility.io.ProgressTracker;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import com.arm.utils.text.NumericStringComparator;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public abstract class Capture
implements ICapture {
    private double percentComplete;
    private @Nullable IProgressMonitor progressMonitor;
    private @NonNull File apcDirectory;
    protected @Nullable IStopHandler mStopHandler;
    private final @NonNull AtomicBoolean mHasBeenStopped = new AtomicBoolean(false);

    protected Capture(@NonNull File apcDirectory) {
        this.apcDirectory = FileUtils.canonicalise((File)apcDirectory);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        return this.apcDirectory.equals(((Capture)obj).apcDirectory);
    }

    public final int hashCode() {
        return this.apcDirectory.hashCode();
    }

    @Override
    public Set<ElfImage> getAvailableImages() {
        HashSet<ElfImage> elfImages = new HashSet<ElfImage>();
        File imagesDir = new File(this.apcDirectory, "images");
        @NonNull File[] files = imagesDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.isDirectory();
            }
        });
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ElfImage image = new ElfImage(file);
                image.setSeparateDebugDir(new File(imagesDir, "debug-files"));
                elfImages.add(image);
                ++n2;
            }
        }
        return elfImages;
    }

    @Override
    public @NonNull ElfImage importImage(@NonNull File elfFilePath) throws IOException, InterruptedException {
        File from = elfFilePath;
        File imagesDir = new File(this.apcDirectory, "images");
        File to = new File(imagesDir, elfFilePath.getName());
        ((File)NullChecking.neverNull((Object)to.getParentFile())).mkdirs();
        if (to.exists()) {
            throw new IOException("Image with this name is already imported.");
        }
        CommonFileUtils.copyFile((File)from, (File)to);
        ElfImage result = new ElfImage(to);
        result.setSeparateDebugDir(new File(imagesDir, "debug-files"));
        return result;
    }

    @Override
    public void appendSeparateDebugFile(@NonNull ElfImage elfImage, @NonNull File elfFilePath) throws IOException, InterruptedException, CodecException {
        File from = elfFilePath;
        File imagesDir = new File(this.apcDirectory, "images");
        File to = new File(new File(imagesDir, "debug-files"), elfFilePath.getName());
        ((File)NullChecking.neverNull((Object)to.getParentFile())).mkdirs();
        CommonFileUtils.copyFile((File)from, (File)to);
        elfImage.processFile();
    }

    @Override
    public void removeImage(@NonNull ElfImage image) {
        try {
            image.processFile();
        }
        catch (CodecException | NativeException | IOException throwable) {
            // empty catch block
        }
        @Nullable File separateDebugFile = image.getSeparateDebugFile();
        if (separateDebugFile != null && separateDebugFile.exists()) {
            FileUtils.delete((File)separateDebugFile);
        }
        FileUtils.delete((File)image.getFile());
    }

    @Override
    public void cleanDbAndReport() {
        if (!this.isInProgress()) {
            File chartConfigurationFile;
            File reportV3Directory;
            File reportDirectory;
            @NonNull File dbDirectory = DatabaseLayout.getDatabaseRoot((File)this.getApcDirectory());
            if (dbDirectory.exists()) {
                FileUtils.delete((File)dbDirectory);
            }
            if ((reportDirectory = new File(this.getApcDirectory(), "report")).exists()) {
                FileUtils.delete((File)reportDirectory);
            }
            if ((reportV3Directory = new File(this.getApcDirectory(), "report-new")).exists()) {
                FileUtils.delete((File)reportV3Directory);
            }
            if ((chartConfigurationFile = CommonFileUtils.getFile((File)new File(this.getApcDirectory(), "chart_configuration.xml"))).exists()) {
                FileUtils.delete((File)chartConfigurationFile);
            }
        }
    }

    @Override
    public int compareTo(ICapture other) {
        int result = NumericStringComparator.caselessCompareStrings((String)this.getApcDirectory().getParent(), (String)other.getApcDirectory().getParent());
        if (result == 0) {
            result = NumericStringComparator.caselessCompareStrings((String)this.getApcDirectory().getName(), (String)other.getApcDirectory().getName());
        }
        return result;
    }

    @Override
    public @NonNull String getAnalysisPath() {
        return (String)NullChecking.neverNull((Object)new File(this.getApcDirectory(), "report").toString());
    }

    @Override
    public @NonNull File getApcDirectory() {
        return this.apcDirectory;
    }

    @Override
    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"})
    public double getProgress() {
        return this.percentComplete;
    }

    @Override
    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"})
    public @Nullable IProgressMonitor getProgressMonitor() {
        return this.progressMonitor;
    }

    @Override
    public boolean hasBeenStopped() {
        return this.mHasBeenStopped.get();
    }

    @Override
    public boolean hasDb() {
        return DatabaseLayout.getDatabaseRoot((File)this.getApcDirectory()).exists();
    }

    @Override
    public boolean hasReport(boolean checkValidity) {
        File reportDir = new File(this.getApcDirectory(), "report");
        if (reportDir.exists()) {
            if (checkValidity) {
                try {
                    StateFile stateFile = StateFile.load(reportDir, new ProgressTracker());
                    if (!stateFile.isVersionValid()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isInProgress() {
        return this.mStopHandler != null;
    }

    @Override
    public boolean isStoppable() {
        if (this.mStopHandler != null) {
            return this.mStopHandler.isStoppable();
        }
        return false;
    }

    @Override
    public void openAsync() {
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().syncExec(() -> {
                DocumentsView view = DocumentsView.showView();
                if (view != null) {
                    ArrayList<ICapture> list = new ArrayList<ICapture>();
                    list.add(this);
                    view.closeEditors(list);
                    view.adjustActions();
                }
                DocumentsView.open(this);
            });
        }
    }

    @Override
    public void setFile(@NonNull File file) {
        this.apcDirectory = file;
    }

    @Override
    public void setHasBeenStopped(boolean stopped) {
        this.mHasBeenStopped.set(stopped);
    }

    @Override
    public synchronized void setProgress(double complete) {
        boolean progressUpdated = complete - this.percentComplete >= 0.1;
        this.percentComplete = Math.max(0.0, Math.min(100.0, complete < 99.9 ? complete : 100.0));
        if (this.progressMonitor != null && progressUpdated) {
            this.progressMonitor.progressUpdated();
        }
    }

    @Override
    public synchronized void setProgressMonitor(@Nullable IProgressMonitor monitor) {
        this.progressMonitor = monitor;
        if (this.progressMonitor != null) {
            this.progressMonitor.progressUpdated();
        }
    }

    @Override
    public void setStopHandler(@Nullable IStopHandler stopHandler, @NonNull IProgressObserver documentScanner) {
        this.mStopHandler = stopHandler;
        if (this.mStopHandler != null) {
            documentScanner.addToInProgress(this);
        } else {
            documentScanner.removeFromInProgress(this);
        }
        if (this.progressMonitor != null) {
            this.progressMonitor.progressUpdated();
        }
    }

    @Override
    public void stop(boolean discard) {
        this.setHasBeenStopped(true);
        IStopHandler mStopHandler = this.mStopHandler;
        if (mStopHandler != null) {
            if (discard) {
                mStopHandler.discard();
            } else {
                mStopHandler.stop();
            }
        }
    }

    public String toString() {
        return this.getPrettyName();
    }
}

