/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.barmancfg.wizard.utils.AbstractFileInputHelper;
import com.arm.streamline.barmancfg.wizard.utils.WizardUtils;
import com.arm.streamline.dataimport.ImportJobFactory;
import com.arm.streamline.dataimport.ImportMessages;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import com.arm.streamline.utility.ui.SimpleLastFilterPathStore;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class BarmanTraceDumpFilesDialog
extends TitleAreaDialog {
    static final @NonNull String @NonNull [] AGENT_IMAGE_FILTER_EXTS = new String[]{"*.*"};
    static final @NonNull String @NonNull [] AGENT_IMAGE_FILTER_NAMES = new String[]{ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_FILTER_ALL_FILES};
    static final @NonNull String @NonNull [] BARMAN_XML_FILTER_EXTS = new String[]{"*.xml"};
    static final @NonNull String @NonNull [] BARMAN_XML_FILTER_NAMES = new String[]{ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_FILTER_ALL_XML_FILES};
    private final @NonNull ILastFilterPathStore lastPathStore;
    private final boolean requireBarmanXml;
    private @Nullable BarmanTraceDumpFilesDialogView view;

    public BarmanTraceDumpFilesDialog(Shell parentShell, boolean requireBarmanXml, @NonNull String defaultPath) {
        super(parentShell);
        this.requireBarmanXml = requireBarmanXml;
        this.lastPathStore = new SimpleLastFilterPathStore(new File(defaultPath));
    }

    public void create() {
        super.create();
        this.setTitle(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_MESSAGE_TITLE);
        this.setMessage(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_MESSAGE);
    }

    public @NonNull String getLastPath() {
        return (String)NullChecking.neverNull((Object)this.lastPathStore.getLastFilterPath().getAbsolutePath());
    }

    public  @Nullable ImportJobFactory.BarmanXmlAndAgentImage getResult() {
        this.setBlockOnOpen(true);
        int result = this.open();
        if (result == 0) {
            @Nullable BarmanTraceDumpFilesDialogView view = this.view;
            if (view == null) {
                return null;
            }
            return view.getResult();
        }
        return null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_TITLE);
    }

    protected Control createDialogArea(Composite parent) {
        @NonNull Composite parentContainer = (Composite)NullChecking.neverNull((Object)((Composite)super.createDialogArea(parent)));
        this.view = new BarmanTraceDumpFilesDialogView(parentContainer, this.requireBarmanXml, this.lastPathStore);
        GridDataFactory.fillDefaults().align(4, 1).grab(true, false).applyTo((Control)this.view);
        return this.view;
    }

    protected boolean isResizable() {
        return false;
    }

    protected void okPressed() {
        @Nullable BarmanTraceDumpFilesDialogView view = this.view;
        if (view != null && view.isValid()) {
            super.okPressed();
        }
    }

    public static class BarmanTraceDumpFilesDialogView
    extends Composite {
        private final @NonNull WizardUtils.LabelAndTextField agentImageLabelAndTextInput;
        private final @NonNull WizardUtils.LabelAndTextField barmanXmlLabelAndTextInput;
        private final @NonNull IObservableValue<@Nullable File> propertyAgentImageFile;
        private final @NonNull IObservableValue<@Nullable File> propertyBarmanXmlFile;
        private boolean requireBarmanXml;
        private final @NonNull Label requiredLabel;

        public BarmanTraceDumpFilesDialogView(@NonNull Composite parent, boolean requireBarmanXml, @NonNull ILastFilterPathStore lastPathStore) {
            super(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this);
            this.propertyAgentImageFile = new WritableValue(null, File.class);
            this.propertyBarmanXmlFile = new WritableValue(null, File.class);
            this.agentImageLabelAndTextInput = WizardUtils.addFileInputToExistingComposite(this, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_LABEL_AGENT_IMAGE_PATH, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_TOOLTIP_AGENT_IMAGE_PATH, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_TOOLTIP_AGENT_IMAGE_BUTTON, "", new AbstractFileInputHelper(lastPathStore, AGENT_IMAGE_FILTER_NAMES, AGENT_IMAGE_FILTER_EXTS){

                @Override
                protected void handleInputCleared() {
                    propertyAgentImageFile.setValue(null);
                }

                @Override
                protected void handleInputInvalid(@NonNull String currentValue) {
                    propertyAgentImageFile.setValue(null);
                }

                @Override
                protected @Nullable File handleValidatedInputChanged(@NonNull File currentValue) {
                    propertyAgentImageFile.setValue((Object)currentValue);
                    return currentValue;
                }

                @Override
                protected boolean validate(@NonNull File currentValue) {
                    return FileUtils.isElfFile((File)currentValue);
                }
            });
            this.barmanXmlLabelAndTextInput = WizardUtils.addFileInputToExistingComposite(this, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_LABEL_BARMAN_XML_PATH, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_TOOLTIP_BARMAN_XML_PATH, ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_TOOLTIP_BARMAN_XML_BUTTON, "", new AbstractFileInputHelper(lastPathStore, BARMAN_XML_FILTER_NAMES, BARMAN_XML_FILTER_EXTS){

                @Override
                protected void handleInputCleared() {
                    propertyBarmanXmlFile.setValue(null);
                }

                @Override
                protected void handleInputInvalid(@NonNull String currentValue) {
                    propertyBarmanXmlFile.setValue(null);
                }

                @Override
                protected @Nullable File handleValidatedInputChanged(@NonNull File currentValue) {
                    propertyBarmanXmlFile.setValue((Object)currentValue);
                    return currentValue;
                }

                @Override
                protected boolean validate(@NonNull File currentValue) {
                    return true;
                }
            });
            this.requiredLabel = new Label((Composite)this, 0);
            this.requiredLabel.setVisible(false);
            this.requiredLabel.setText(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_LABEL_STAR_MEANS_REQUIRED);
            GridDataFactory.swtDefaults().span(2, 1).align(0x1000008, 0x1000000).applyTo((Control)this.requiredLabel);
            this.setRequiredFields(requireBarmanXml);
        }

        public BarmanTraceDumpFilesDialogView(@NonNull Composite parent, boolean requireBarmanXml, @NonNull String defaultPath) {
            this(parent, requireBarmanXml, new SimpleLastFilterPathStore(new File(defaultPath)));
        }

        public @NonNull IObservableValue<@Nullable File> getAgentImageFile() {
            return this.propertyAgentImageFile;
        }

        public @NonNull IObservableValue<@Nullable File> getBarmanXmlFile() {
            return this.propertyBarmanXmlFile;
        }

        public  @NonNull ImportJobFactory.BarmanXmlAndAgentImage getResult() {
            return new ImportJobFactory.BarmanXmlAndAgentImage((File)this.propertyBarmanXmlFile.getValue(), (File)this.propertyAgentImageFile.getValue(), null);
        }

        public boolean isValid() {
            @Nullable File barmanXML = (File)this.propertyBarmanXmlFile.getValue();
            boolean barmanXmlIsOk = barmanXML != null && barmanXML.exists() && barmanXML.isFile();
            boolean passBarmanXml = barmanXmlIsOk || barmanXML == null && !this.requireBarmanXml;
            return passBarmanXml;
        }

        public void setRequiredFields(boolean requireBarmanXml) {
            this.requireBarmanXml = requireBarmanXml;
            this.agentImageLabelAndTextInput.label.setText(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_LABEL_AGENT_IMAGE_PATH);
            this.barmanXmlLabelAndTextInput.label.setText(ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_LABEL_BARMAN_XML_PATH + (requireBarmanXml ? ImportMessages.TRACE_DUMP_ADDITIONAL_FILES_DIALOG_STAR : ""));
            this.requiredLabel.setVisible(requireBarmanXml);
        }
    }
}

