/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.databrowser;

import com.arm.streamline.analysis.IDirtyFlag;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.utility.SWTUtils;
import com.arm.streamline.widget.BorderedComposite;
import com.arm.utils.NullChecking;
import com.arm.utils.text.SWTLabelFilter;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AnalysisOptionsPanel
extends Composite
implements SelectionListener {
    final @NonNull IAnalysisInputSettings mSettings;
    final @NonNull IDirtyFlag mDirtyFlag;
    private BorderedComposite mTypeGroup;
    private Button mFilterCallStacksDataButton;
    private Button mParseDebugInfoButton;
    private Button mImageSearchEnabledButton;
    private Combo mResolutionModeCombo;
    private Label mWarningsIconLabel;
    private Composite mWarning;
    private boolean mSyncAllowed = true;

    public AnalysisOptionsPanel(Composite parent, @NonNull IAnalysisInputSettings settings, @NonNull IDirtyFlag dirtyFlag) {
        super(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        this.mSettings = settings;
        this.mDirtyFlag = dirtyFlag;
        this.mTypeGroup = new BorderedComposite(this, DocumentsMessages.ANALYSIS);
        GridLayout layout = new GridLayout(1, false);
        this.mTypeGroup.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mTypeGroup);
        Composite row = new Composite((Composite)this.mTypeGroup, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(row);
        SWTUtils.createLabel(row, DocumentsMessages.RESOLUTION_LABEL, DocumentsMessages.RESOLUTION_TOOLTIP, 0);
        this.mResolutionModeCombo = SWTUtils.createCombo(row, DocumentsMessages.RESOLUTION_TOOLTIP, ResolutionMode.values(), this);
        this.mParseDebugInfoButton = this.createCheckbox(this.mTypeGroup, DocumentsMessages.PARSE_DEBUG_INFO, DocumentsMessages.PARSE_DEBUG_INFO_TOOLTIP);
        this.mFilterCallStacksDataButton = this.createCheckbox(this.mTypeGroup, DocumentsMessages.FILTER_CALL_STACKS, DocumentsMessages.FILTER_CALL_STACKS_TOOLTIP);
        this.mImageSearchEnabledButton = this.createCheckbox(this.mTypeGroup, DocumentsMessages.SEARCH_FOR_IMAGES, DocumentsMessages.SEARCH_FOR_IMAGES_TOOLTIP);
        this.mWarning = new Composite(row, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.mWarning);
        this.mWarningsIconLabel = SWTUtils.createLabel(this.mWarning, "", "", 0);
        Image image = StreamlinePlugin.getImage("Warning.png");
        this.mWarningsIconLabel.setImage(image);
        SWTUtils.createLabel(this.mWarning, DocumentsMessages.RESOLUTION_ULTRA_WARNING, "", 0);
    }

    public String checkValidity() {
        return null;
    }

    public void initializeContent() {
        boolean allowSync = this.mSyncAllowed;
        this.mSyncAllowed = false;
        try {
            this.adjustControls();
        }
        finally {
            this.mSyncAllowed = allowSync;
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.mSyncAllowed) {
            if (event.widget == this.mFilterCallStacksDataButton) {
                this.mSettings.setFilterCallStacksData(this.mFilterCallStacksDataButton.getSelection());
            }
            if (event.widget == this.mImageSearchEnabledButton) {
                this.mSettings.setImageSearchEnabled(this.mImageSearchEnabledButton.getSelection());
            }
            if (event.widget == this.mParseDebugInfoButton) {
                this.mSettings.setParseDebugInfoEnabled(this.mParseDebugInfoButton.getSelection());
            }
            if (event.widget == this.mResolutionModeCombo) {
                int index = this.mResolutionModeCombo.getSelectionIndex();
                this.mSettings.setResolutionMode((ResolutionMode)NullChecking.neverNull((Object)ResolutionMode.values()[index]));
                this.updateWarningLabel();
            }
            this.mDirtyFlag.markDirty();
        }
    }

    private void adjustControls() {
        this.mFilterCallStacksDataButton.setSelection(this.mSettings.isFilterCallStacksDataEnabled());
        this.mImageSearchEnabledButton.setEnabled(this.mSettings.isImageSearchingSupported());
        this.mImageSearchEnabledButton.setSelection(this.mSettings.getImageSearchPaths() != null);
        this.mParseDebugInfoButton.setSelection(this.mSettings.isParseDebugInfoEnabled());
        ResolutionMode mode = this.mSettings.getResolutionMode();
        int i = 0;
        while (i < this.mResolutionModeCombo.getItemCount()) {
            if (this.mResolutionModeCombo.getItem(i).equals(mode.toString())) {
                this.mResolutionModeCombo.select(i);
                break;
            }
            ++i;
        }
        this.updateWarningLabel();
    }

    private Button createCheckbox(Composite parent, String title, String tooltip) {
        Button button = new Button(parent, 32);
        button.setText(title);
        button.setToolTipText(SWTLabelFilter.filterForToolTip((String)tooltip));
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    private void updateWarningLabel() {
        int selectedIndex = this.mResolutionModeCombo.getSelectionIndex();
        ResolutionMode resolutionMode = ResolutionMode.values()[selectedIndex];
        this.mWarning.setVisible(resolutionMode == ResolutionMode.ULTRAHIGH);
    }
}

