/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.outline;

import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.IAvailableEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.outline.BaseRow;
import com.arm.streamline.counterconfig.outline.CounterRow;
import com.arm.streamline.counterconfig.outline.IAvailableEventsRow;
import com.arm.streamline.widget.Colors;
import com.arm.streamline.widget.outline.SimpleColumn;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;

public class StockCounterRow
extends CounterRow
implements IAvailableEventsRow {
    private final @NonNull Configurations mConfigurations;
    private final @NonNull String mDisplayTitle;
    private final @NonNull StockCounter mCounter;
    private int mPopupCenter;

    public StockCounterRow(@NonNull Configurations configurations, @NonNull StockCounter counter, @NonNull Events events) {
        this.mCounter = counter;
        this.mDisplayTitle = events.getUniqueDisplayTitle(this.mCounter, true);
        this.mConfigurations = configurations;
    }

    @Override
    public Color getBackgroundColor(Device device, boolean selected, boolean active) {
        if (this.isEnabled()) {
            return super.getBackgroundColor(device, selected, active);
        }
        if (selected && active) {
            return Colors.getDarkGray();
        }
        if (selected) {
            return Colors.getGray();
        }
        return Colors.isDarkModeUI() ? Colors.lighten(Colors.getWidgetBackground(), 40) : Colors.create(224, 224, 224);
    }

    @Override
    public Color getForegroundTextColor(boolean selected, boolean active) {
        if (!this.isEnabled() && !this.mConfigurations.isInUse(this.mCounter, null, null)) {
            return Colors.getWhite();
        }
        return Colors.getText(selected && active);
    }

    public @NonNull StockCounter getCounter() {
        return this.mCounter;
    }

    @Override
    public double getDataAsDouble(SimpleColumn column) {
        return 0.0;
    }

    @Override
    public long getDataAsLong(SimpleColumn column) {
        return 0L;
    }

    @Override
    public String getDataAsText(SimpleColumn column) {
        return this.mDisplayTitle;
    }

    public int getPopupCenter() {
        return this.mPopupCenter;
    }

    @Override
    public @NonNull StockCounter getStockCounter() {
        return this.mCounter;
    }

    @Override
    public boolean isEnabled() {
        return this.mConfigurations.atLeastOneCombinationIsntEnabledAndCanBe(this.mCounter);
    }

    @Override
    public void setData(SimpleColumn column, Object data) {
    }

    public void setPopupCenter(int popupStart) {
        this.mPopupCenter = popupStart;
    }

    @Override
    public @NonNull IAvailableEvent getData() {
        return this.mCounter;
    }

    @Override
    public @NonNull BaseRow getBaseRow() {
        return this;
    }

    @Override
    public @NonNull Set<String> getSources() {
        return this.mCounter.getAllCombinations().map(StockCounter.Combination::getUniqueSourceName).collect(Collectors.toSet());
    }
}

