/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig.model;

import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.ClusterNameUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.Category;
import com.arm.streamline.common.xml.counters.CounterSet;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.counters.Option;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.common.xml.spe.SpeParsingException;
import com.arm.streamline.common.xml.spe.SpeTargetDescription;
import com.arm.streamline.common.xml.spe.SpeXMLParser;
import com.arm.streamline.counterconfig.model.TargetCounterUtils;
import com.arm.streamline.model.templates.TemplateFile;
import com.arm.utils.NullChecking;
import com.arm.utils.OptionalUtils;
import com.arm.utils.StreamUtils;
import com.arm.utils.collections.ObjIntPair;
import com.arm.utils.collections.Pair;
import com.arm.utils.function.Throwing;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.TIntSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Configurations {
    public static final int DEFAULT_EBS_THRESHOLD = 1000;
    private @NonNull Set<@NonNull TargetCounter> counters = new HashSet<TargetCounter>();
    private @NonNull Map<@NonNull CounterSet, @NonNull TargetCounterSet> currentCounterSetStates = Collections.emptyMap();
    private @NonNull Set<@NonNull TargetCounter> ebsCounters = new HashSet<TargetCounter>();
    private @NonNull TObjectIntMap<TargetCounter> ebsLastSetValues = new TObjectIntHashMap();
    private final @NonNull Events events;
    private @Nullable String gpuPublicName;
    private final @NonNull Collection<@NonNull IListener> listeners = new HashSet<IListener>();
    private @NonNull Set<@NonNull SpeFilterConfiguration> spes = new HashSet<SpeFilterConfiguration>();
    private @NonNull List<@NonNull TemplateFile> templates = new ArrayList<TemplateFile>();

    private static void saveCaptureTemplate(@NonNull XMLGenerator xml, @NonNull TemplateFile template) throws IOException {
        if (template.getCharts().isEmpty()) {
            return;
        }
        template.save(xml);
    }

    public Configurations(@NonNull Events events) {
        this.events = events;
    }

    public @NonNull Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> addCombinations(@NonNull Stream<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> combos) {
        return this.addCombinations(combos, i -> true);
    }

    public @NonNull Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> addCombinations(@NonNull Stream<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> combos, @NonNull IntPredicate clusterFilter) {
        @NonNull Pair<@NonNull List<@NonNull TargetCounter>, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull StockCounter.Combination>> addedAndNotAdded = this.getTargetCountersNotInUseFromCombinations(combos.filter(c -> {
            ObjIntPair cp = c.stockCounter.getClusterProperties(false);
            if (cp == null) {
                return true;
            }
            return clusterFilter.test(cp.second);
        }));
        this.notifyEventsAdded(Collections.emptySet(), (Collection)addedAndNotAdded.first);
        return (Collection)addedAndNotAdded.second;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> addCombinationsByAlias(@NonNull Stream<@NonNull String> names, @NonNull IntPredicate clusterFilter) {
        @NonNull @NonNull Map combosBySource = this.events.getSourceToComboMap();
        return this.addCombinations(StreamUtils.filterOutNull(names.map(combosBySource::get)), clusterFilter);
    }

    public Collection<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> addCombinationsByMetricId(@NonNull Set<@NonNull String> selectedMetrics, @NonNull IntPredicate clusterFilter) {
        return this.addCombinations(this.events.getSourceToComboMap().values().stream().filter(c -> {
            String n = c.stockCounter.getCounterName();
            if (n == null) {
                return false;
            }
            return selectedMetrics.contains(n);
        }), clusterFilter);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void addEvents(@NonNull Collection<@NonNull SpeTargetDescription> selectedSpeTargets, @NonNull Collection<@NonNull StockCounter> selectedStockCounters) {
        @NonNull ArrayList<@NonNull SpeFilterConfiguration> arrayList = new ArrayList<SpeFilterConfiguration>();
        for (SpeTargetDescription spe : selectedSpeTargets) {
            if (this.isAlreadyAddedToCollectEvents(spe)) continue;
            SpeFilterConfiguration speFilterConfiguration = new SpeFilterConfiguration(spe);
            this.spes.add(speFilterConfiguration);
            arrayList.add(speFilterConfiguration);
        }
        @NonNull @NonNull List targetCountersNotInUseFromCombinations = (List)this.getTargetCountersNotInUseFromCombinations(selectedStockCounters.stream().flatMap((Function<StockCounter, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getAllCombinations(), (Lcom/arm/streamline/common/xml/counters/StockCounter;)Ljava/util/stream/Stream;)())).first;
        this.notifyEventsAdded(arrayList, targetCountersNotInUseFromCombinations);
    }

    public void addListener(@NonNull IListener listener) {
        this.listeners.add(listener);
        this.listeners.forEach(IListener::handleListenersChanged);
    }

    public void addTemplate(@NonNull TemplateFile template) {
        this.templates.add(template);
    }

    public boolean atLeastOneCombinationIsntEnabledAndCanBe(@NonNull StockCounter counter) {
        return counter.getAllCombinations().anyMatch(this::isntInUseAndHasFreeCounter);
    }

    public void clear() {
        this.removeEvents(this.spes.stream(), this.counters.stream());
        this.templates.clear();
    }

    public boolean ebsIsEnabled(@NonNull StockCounter counter) {
        return this.getCountersOf(counter).anyMatch(this::ebsIsEnabled);
    }

    public boolean ebsIsEnabled(@NonNull TargetCounter counter) {
        return this.ebsCounters.contains(counter);
    }

    public final @NonNull Optional<TargetCounter> findCounter(@NonNull String counterName) {
        return this.getAllCounters().filter(c -> c.getCounterName().equals(counterName)).findAny();
    }

    public int getAdditionalUsedByMetrics(@NonNull CounterSet counterSet) {
        TargetCounterSet state = this.currentCounterSetStates.get(counterSet);
        if (state != null) {
            return state.additionalUsedByMetrics();
        }
        return 0;
    }

    public final @NonNull Stream<@NonNull TargetCounter> getAllCounters() {
        return this.counters.stream();
    }

    public final @NonNull Stream<@NonNull TargetCounter> getAllEbsCounters() {
        return this.ebsCounters.stream();
    }

    public final @NonNull Stream<@NonNull TargetCounter> getAllMatching(@NonNull TargetCounter counter) {
        return this.getAllCounters().filter(c -> c.getCombo().getUniqueSourceNameIgnoringCluster().equals(counter.getCombo().getUniqueSourceNameIgnoringCluster()));
    }

    public @NonNull Set<@NonNull String> getCountersInUse(@NonNull CounterSet counterSet) {
        return this.getAllCounters().map(TargetCounter::getCounterName).filter(arg_0 -> counterSet.contains(arg_0)).collect(Collectors.toSet());
    }

    public final @NonNull Stream<@NonNull TargetCounter> getCountersOf(@NonNull StockCounter stockCounter) {
        return this.counters.stream().filter(tc -> tc.getDerivedFrom().equals(stockCounter));
    }

    public @Nullable SpeFilterConfiguration getFilterConfiguration(@NonNull SpeTargetDescription targetCounter) {
        @NonNull String id = targetCounter.getId();
        @NonNull Optional<@NonNull SpeFilterConfiguration> findFirst = this.spes.stream().filter(spe -> spe.getId().equals(id)).findFirst();
        if (findFirst.isPresent()) {
            return findFirst.get();
        }
        return null;
    }

    public @Nullable String getGpuPublicName() {
        return this.gpuPublicName;
    }

    public int getLastSetEbsValue(@NonNull TargetCounter targetCounter) {
        return this.ebsLastSetValues.get((Object)targetCounter);
    }

    public int getLastSetEbsValueOrDefault(@NonNull TargetCounter targetCounter) {
        if (this.ebsLastSetValues.containsKey((Object)targetCounter)) {
            return this.ebsLastSetValues.get((Object)targetCounter);
        }
        return 1000;
    }

    public int getNumberOfEbsCounters() {
        return this.ebsCounters.size();
    }

    public final @NonNull Set<@Nullable Option> getOptionsInUse(@NonNull StockCounter stockCounter) {
        return this.getCountersOf(stockCounter).map(TargetCounter::getOption).collect(Collectors.toSet());
    }

    public final @NonNull Stream<@NonNull SpeFilterConfiguration> getSpeFilterConfigurationOf(@NonNull SpeTargetDescription stockCounter) {
        return this.spes.stream().filter(tc -> tc.getTargetDescription().equals(stockCounter));
    }

    public final @NonNull Set<@NonNull SpeFilterConfiguration> getSpeFilterConfigurations() {
        return this.spes;
    }

    public @NonNull List<@NonNull TemplateFile> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    public boolean hasSynchronizedListener(@NonNull Category category) {
        return this.listeners.stream().anyMatch(l -> l.isSynchronized(category));
    }

    public boolean isAlreadyAddedToCollectEvents(@NonNull SpeTargetDescription event) {
        @NonNull String id = event.getId();
        return this.spes.stream().anyMatch(spe -> spe.getId().equals(id));
    }

    public boolean isInUse(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination combo) {
        return this.isInUse(combo.stockCounter, combo.option, (Collection<String>)combo.counterSet);
    }

    public boolean isInUse(@NonNull StockCounter counter, @Nullable Option option, @Nullable Collection<@NonNull String> counterSet) {
        return this.getCountersOf(counter).anyMatch(t -> !(option != null && !option.equals((Object)t.getOption()) || counterSet != null && !counterSet.contains(t.getCounterName())));
    }

    public boolean isntInUse(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination combo) {
        return !this.isInUse(combo);
    }

    public boolean isntInUseAndHasFreeCounter(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination combo) {
        TargetCounterSet currentState;
        CounterSet metricCounterSet;
        CounterSet counterSet = (CounterSet)NullChecking.neverNullOrNullable((Object)combo.counterSet, (Object)combo.stockCounter.getCyclesCounterSet());
        if (this.isInUse(combo)) {
            return false;
        }
        StockCounter.MetricProperties metricProperties = combo.stockCounter.getMetricProperties();
        if (metricProperties != null && (metricCounterSet = metricProperties.counterSet()) != null && (currentState = this.currentCounterSetStates.get(metricCounterSet)) != null && !currentState.canAcceptMetric(metricProperties.usesCycles(), metricProperties.numEvents())) {
            return false;
        }
        if (counterSet == null) {
            return true;
        }
        TargetCounterSet currentState2 = this.currentCounterSetStates.get(counterSet);
        if (currentState2 != null) {
            boolean isCycles;
            String counterName = combo.stockCounter.getCounterName();
            boolean bl = isCycles = counterName != null && counterName.endsWith("_ccnt");
            if (!currentState2.canAcceptTimeline(isCycles)) {
                return false;
            }
        }
        return counterSet.stream().map(this::findCounter).anyMatch(o -> !o.isPresent());
    }

    public void load(@NonNull InputStream input) throws IOException {
        @NonNull HashSet<@NonNull TargetCounter> tempCounters = new HashSet<TargetCounter>();
        @NonNull HashSet<@NonNull SpeFilterConfiguration> tempSpe = new HashSet<SpeFilterConfiguration>();
        @NonNull ArrayList<@NonNull TemplateFile> tempTemplates = new ArrayList<TemplateFile>();
        TObjectIntHashMap tempEbsValues = new TObjectIntHashMap();
        Throwable throwable = null;
        Object var7_8 = null;
        try (XMLParser in = new XMLParser(input);){
            String tag;
            Map stockCounterMap = this.events.getStockCounterMap();
            while ((tag = in.nextTag()) != null) {
                block27: {
                    if (!"configurations".equals(tag)) break block27;
                    this.gpuPublicName = in.getAttribute("gpu_public_name");
                    String marker = in.getMarker();
                    block18: while ((tag = in.nextTag(marker)) != null) {
                        switch (tag) {
                            case "configuration": {
                                int ebsValue = TargetCounter.loadEbs((XMLParser)in);
                                TargetCounter counter = TargetCounterUtils.load(in, stockCounterMap);
                                if (counter == null) continue block18;
                                tempCounters.add(counter);
                                if (ebsValue <= 0) continue block18;
                                tempEbsValues.put((Object)counter, ebsValue);
                                break;
                            }
                            case "spe": {
                                try {
                                    @NonNull Consumer<@NonNull Throwable> errorHandler = e -> CommonPlugin.error((Throwable)e);
                                    @NonNull SpeFilterConfiguration speFilterConfig = SpeXMLParser.parseSpeConfigXml((XMLParser)in, (Map)this.events.getAllSpeTargetDescriptions(), errorHandler);
                                    tempSpe.add(speFilterConfig);
                                }
                                catch (SpeParsingException exception) {
                                    CommonPlugin.error((Throwable)exception);
                                }
                                continue block18;
                            }
                            case "template": {
                                TemplateFile template = new TemplateFile(in, (Map<String, TIntSet>)this.events.getSourceToClusterIdMap());
                                if (template.getCharts().isEmpty()) continue block18;
                                tempTemplates.add(template);
                                break;
                            }
                            default: {
                                in.skip();
                            }
                        }
                    }
                    continue;
                }
                in.skip();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        HashSet<@NonNull TargetCounter> tempEbsCounters = new HashSet<TargetCounter>(tempEbsValues.keySet());
        this.counters = tempCounters;
        this.spes = tempSpe;
        this.templates = tempTemplates;
        this.ebsCounters = tempEbsCounters;
        this.ebsLastSetValues = tempEbsValues;
        this.counters.stream().forEach(targetCounter -> {
            List<TargetCounter> allMatching;
            int currentCount = -1;
            @NonNull String uniqsrcNameIgnrCluster = targetCounter.getCombo().getUniqueSourceNameIgnoringCluster();
            @NonNull @NonNull Optional<@NonNull TargetCounter> match = this.ebsLastSetValues.keySet().stream().filter(ebsc -> ebsc.getCombo().getUniqueSourceNameIgnoringCluster().equals(uniqsrcNameIgnrCluster)).findFirst();
            if (match.isPresent()) {
                currentCount = this.ebsLastSetValues.get((Object)match.get());
            }
            if (!(allMatching = this.getAllMatching((TargetCounter)targetCounter).collect(Collectors.toList())).isEmpty() && currentCount > -1) {
                this.setDefaultIfNotAllEbsCountMatched((TargetCounter)targetCounter, currentCount, allMatching);
            }
        });
        this.recomputeCounterSetStates();
        this.notifyReload();
    }

    public final void removeCombination(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination combo) {
        @NonNull List<@NonNull TargetCounter> targetCounterstoRemove = this.getCountersOf(combo.stockCounter).filter(t -> NullChecking.equalsNullable((Object)t.getOption(), (Object)combination.option)).filter(t -> NullChecking.equalsNullable((Object)t.getCounterSet(), (Object)combination.counterSet)).collect(Collectors.toList());
        this.removeEvents(Collections.emptySet(), targetCounterstoRemove);
    }

    public void removeCounters(@NonNull List<@NonNull TargetCounter> targetCounterstoRemove) {
        this.removeEvents(Collections.emptySet(), targetCounterstoRemove);
    }

    public void removeEvents(@NonNull Collection<@NonNull SpeFilterConfiguration> speFilterToRemove, @NonNull Collection<@NonNull TargetCounter> countersToRemove) {
        this.removeEvents(speFilterToRemove.stream(), countersToRemove.stream());
    }

    public void removeEvents(@NonNull Stream<@NonNull SpeFilterConfiguration> speFilterToRemove, @NonNull Stream<@NonNull TargetCounter> countersToRemove) {
        List<@NonNull SpeFilterConfiguration> removedSpes = speFilterToRemove.filter(this.spes::contains).collect(Collectors.toList());
        List<@NonNull TargetCounter> removedCounters = countersToRemove.filter(this.counters::contains).collect(Collectors.toList());
        this.spes.removeAll(removedSpes);
        this.counters.removeAll(removedCounters);
        removedCounters.forEach(c -> this.clearEbsValue((TargetCounter)c));
        removedCounters.forEach(c -> {
            int n = this.ebsLastSetValues.remove(c);
        });
        this.recomputeCounterSetStates();
        this.notifyEventsRemoved(removedSpes, removedCounters);
    }

    public void removeListener(@NonNull IListener listener) {
        this.listeners.remove(listener);
        this.listeners.forEach(IListener::handleListenersChanged);
    }

    public void removeSelectedEvents(@NonNull Collection<@NonNull SpeTargetDescription> selectedSpeTargets, @NonNull Collection<@NonNull StockCounter> selectedStockCounters) {
        this.removeEvents(selectedSpeTargets.stream().flatMap(this::getSpeFilterConfigurationOf), selectedStockCounters.stream().flatMap(this::getCountersOf));
    }

    public void removeTemplateIfPresent(@NonNull TemplateFile template) {
        this.templates.removeIf(t -> t.matches(template, true) && t.getName().equals(template.getName()));
    }

    public void save(OutputStream stream) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (XMLGenerator xml = new XMLGenerator(stream);){
            xml.startDocument();
            this.save(xml);
            xml.endDocument();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void setEbsValueForAllMatching(@NonNull TargetCounter targetCounter, int value) {
        this.setEbsValue(targetCounter, value);
        @NonNull Stream<@NonNull TargetCounter> allMatching = this.getAllMatching(targetCounter);
        allMatching.forEach(c -> this.setEbsValue((TargetCounter)c, value));
    }

    public void setGpuPublicName(@Nullable String publicName) {
        this.gpuPublicName = publicName;
    }

    public void toggleEbs(boolean setEbsEnabled, @NonNull TargetCounter targetCounter) {
        if (setEbsEnabled) {
            int ebsCount = this.getLastSetEbsValueOrDefault(targetCounter);
            this.setEbsValueForAllMatching(targetCounter, ebsCount);
        } else {
            this.setEbsValueForAllMatching(targetCounter, 0);
        }
    }

    private void clearEbsValue(@NonNull TargetCounter targetCounter) {
        if (this.ebsCounters.remove(targetCounter)) {
            this.notifyEbsChanged(targetCounter);
        }
    }

    private final @NonNull Optional<TargetCounter> getNextAvailableTargetCounter(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination combo) {
        return combo.stockCounter.getCounterNames(combo.counterSet).filter(counter -> !this.isInUse((String)counter)).map(c -> new TargetCounter(combination.stockCounter, c, combination.option)).findAny();
    }

    private @NonNull Pair<@NonNull List<@NonNull TargetCounter>, @NonNull List<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination>> getTargetCountersNotInUseFromCombinations(@NonNull Stream<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull StockCounter.Combination> combos) {
        ArrayList<@NonNull E> added = new ArrayList();
        ArrayList<@NonNull E> notAdded = new ArrayList();
        combos.filter(this::isntInUse).collect(Collectors.toCollection(LinkedHashSet::new)).forEach(combo -> OptionalUtils.ifPresentOrElse(this.getNextAvailableTargetCounter((StockCounter.Combination)combo), t -> {
            if (this.isntInUseAndHasFreeCounter((StockCounter.Combination)combo)) {
                @NonNull Stream<@NonNull TargetCounter> allMatching = this.getAllMatching((TargetCounter)t);
                @NonNull Optional<@NonNull TargetCounter> findFirst = allMatching.findFirst();
                if (findFirst.isPresent()) {
                    @NonNull TargetCounter counter = findFirst.get();
                    if (this.ebsCounters.contains(counter)) {
                        this.ebsCounters.add((TargetCounter)t);
                    }
                    int ebsValue = this.getLastSetEbsValueOrDefault(counter);
                    this.ebsLastSetValues.put(t, ebsValue);
                }
                this.counters.add((TargetCounter)t);
                added.add(t);
                this.recomputeCounterSetStates();
            } else {
                notAdded.add(combo);
            }
        }, () -> {
            boolean bl = notAdded.add(combo);
        }));
        return new Pair(added, notAdded);
    }

    private final boolean isInUse(@NonNull String counterName) {
        return this.findCounter(counterName).isPresent();
    }

    private void notifyEbsChanged(@Nullable TargetCounter targetCounter) {
        this.listeners.stream().forEach(listener -> listener.handleEbsChanged(targetCounter));
    }

    private void notifyEventsAdded(@NonNull Collection<@NonNull SpeFilterConfiguration> speFilterConfig, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
        if (!speFilterConfig.isEmpty() || !targetCounters.isEmpty()) {
            this.listeners.forEach(l -> l.handleEventsAdded(speFilterConfig, targetCounters));
        }
    }

    private void notifyEventsRemoved(@NonNull Collection<@NonNull SpeFilterConfiguration> speFilterToRemove, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
        if (!speFilterToRemove.isEmpty() || !targetCounters.isEmpty()) {
            this.listeners.forEach(l -> l.handleEventsRemoved(speFilterToRemove, targetCounters));
        }
    }

    private void notifyReload() {
        this.listeners.stream().forEach(IListener::handleReload);
    }

    private void recomputeCounterSetStates() {
        HashMap<CounterSet, TargetCounterSet> map = new HashMap<CounterSet, TargetCounterSet>();
        for (TargetCounter targetCounter : this.counters) {
            CounterSet metricCounterSet;
            StockCounter.MetricProperties metricProperties;
            StockCounter targetStockCounter = targetCounter.getDerivedFrom();
            CounterSet targetCounterSet = (CounterSet)NullChecking.neverNullOrNullable((Object)targetCounter.getCounterSet(), (Object)targetStockCounter.getCyclesCounterSet());
            if (targetCounterSet != null) {
                boolean targetIsPmuEvent;
                String targetPmuId = targetCounterSet.getPmuId();
                if (targetPmuId == null || !ClusterNameUtils.isArmCortexOrNeoverse((String)targetPmuId)) continue;
                String targetCounterName = targetStockCounter.getCounterName();
                Long targetEventCode = targetStockCounter.getEvent();
                boolean targetIsCycles = targetCounterName != null && targetCounterName.endsWith("_ccnt");
                boolean bl = targetIsPmuEvent = !targetIsCycles && targetEventCode != null;
                if (!targetIsCycles && !targetIsPmuEvent) continue;
                TargetCounterSet state = map.computeIfAbsent(targetCounterSet, k -> new TargetCounterSet((CounterSet)k));
                if (targetIsCycles) {
                    state.timelineUsesCycles = true;
                }
                if (targetIsPmuEvent) {
                    ++state.numTimelineEvents;
                }
            }
            if ((metricProperties = targetStockCounter.getMetricProperties()) == null || (metricCounterSet = metricProperties.counterSet()) == null) continue;
            TargetCounterSet state = map.computeIfAbsent(metricCounterSet, k -> new TargetCounterSet((CounterSet)k));
            if (metricProperties.usesCycles()) {
                state.metricUsesCycles = true;
            }
            if (metricProperties.numEvents() <= state.numMetricEvents) continue;
            state.numMetricEvents = metricProperties.numEvents();
        }
        this.currentCounterSetStates = map;
    }

    private void save(@NonNull XMLGenerator xml) throws IOException {
        xml.startTag("configurations");
        xml.addAttribute("revision", 3);
        xml.addAttribute("gpu_public_name", this.gpuPublicName);
        int streamlineVersion = GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION.getVersionNumber();
        xml.addAttribute("streamline_version", streamlineVersion);
        Throwing.forEach(this.getAllCounters(), c -> c.saveAsTargetConfiguration(xml, "configuration", this.ebsCounters.contains(c) ? this.ebsLastSetValues.get(c) : 0));
        Throwing.forEach(this.getSpeFilterConfigurations(), spe -> SpeXMLParser.saveConfiguration((XMLGenerator)xml, (SpeFilterConfiguration)spe));
        Throwing.forEach(this.getTemplates(), template -> Configurations.saveCaptureTemplate(xml, template));
        xml.endTag();
    }

    private void setDefaultIfNotAllEbsCountMatched(@NonNull TargetCounter targetCounter, int currentCount, List<@NonNull TargetCounter> allMatchingCounters) {
        boolean allMatch = allMatchingCounters.stream().allMatch(matchedCounter -> !this.ebsCounters.contains(matchedCounter) || currentCount == this.ebsLastSetValues.get(matchedCounter));
        if (!allMatch) {
            this.ebsCounters.add(targetCounter);
            allMatchingCounters.stream().forEach(matchedCounter -> {
                int n = this.ebsLastSetValues.put(matchedCounter, 1000);
            });
        } else if (!this.ebsCounters.contains(targetCounter)) {
            this.ebsCounters.add(targetCounter);
            this.ebsLastSetValues.put((Object)targetCounter, currentCount);
        }
    }

    private void setEbsValue(@NonNull TargetCounter targetCounter, int value) {
        if (value > 0) {
            int previousValue = this.ebsLastSetValues.put((Object)targetCounter, value);
            if (this.ebsCounters.add(targetCounter) || previousValue != value) {
                this.notifyEbsChanged(targetCounter);
            }
        } else {
            this.clearEbsValue(targetCounter);
        }
    }

    public static interface IListener {
        default public void handleEbsChanged(@Nullable TargetCounter counter) {
            this.handleReload();
        }

        default public void handleEventsAdded(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfig, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
            this.handleReload();
        }

        default public void handleEventsRemoved(@NonNull Collection<@NonNull SpeFilterConfiguration> filterConfig, @NonNull Collection<@NonNull TargetCounter> targetCounters) {
            this.handleReload();
        }

        default public void handleListenersChanged() {
            this.handleReload();
        }

        public void handleReload();

        default public boolean isSynchronized(@NonNull Category category) {
            return false;
        }
    }

    public final class TargetCounterSet {
        private final @NonNull CounterSet counterSet;
        private boolean metricUsesCycles = false;
        private int numMetricEvents = 0;
        private int numTimelineEvents = 0;
        private boolean timelineUsesCycles = false;

        public TargetCounterSet(CounterSet counterSet) {
            this.counterSet = counterSet;
        }

        public int additionalUsedByMetrics() {
            int extraCyclesEvent = this.timelineUsesCycles && this.metricUsesCycles ? 1 : 0;
            return this.numMetricEvents + extraCyclesEvent;
        }

        public boolean canAcceptMetric(boolean usesCycles, int numEvents) {
            int extraCyclesEvent;
            boolean newMetricUsesCycles = this.metricUsesCycles || usesCycles;
            int newNumMetricEvents = Math.max(this.numMetricEvents, numEvents);
            int n = extraCyclesEvent = this.timelineUsesCycles && newMetricUsesCycles ? 1 : 0;
            return newNumMetricEvents + this.numTimelineEvents + extraCyclesEvent <= this.counterSet.size();
        }

        public boolean canAcceptTimeline(boolean isCycles) {
            int extraCyclesEvent;
            boolean newTimelineUsesCycles = this.timelineUsesCycles || isCycles;
            int newNumTimelineEvents = (isCycles ? 0 : 1) + this.numTimelineEvents;
            int n = extraCyclesEvent = newTimelineUsesCycles && this.metricUsesCycles ? 1 : 0;
            return this.numMetricEvents + newNumTimelineEvents + extraCyclesEvent <= this.counterSet.size();
        }

        public String toString() {
            return String.format("TCS (%s,%s) + (%s%s)", this.timelineUsesCycles, this.numTimelineEvents, this.metricUsesCycles, this.numMetricEvents);
        }
    }
}

