/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.counterconfig;

import com.arm.streamline.common.xml.counters.IConfiguredEvent;
import com.arm.streamline.common.xml.counters.StockCounter;
import com.arm.streamline.common.xml.counters.TargetCounter;
import com.arm.streamline.common.xml.spe.SpeFilterConfiguration;
import com.arm.streamline.counterconfig.CountersEbsShared;
import com.arm.streamline.counterconfig.SpeEditorComposite;
import com.arm.streamline.counterconfig.model.Configurations;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.outline.IEventSelectionListener;
import com.arm.streamline.counterconfig.viewmodel.CountersEbsSharedViewModel;
import com.arm.utils.function.IBooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EventsEditorComposite
implements IEventSelectionListener,
Configurations.IListener {
    private @NonNull CounterConfiguration config;
    private @Nullable IConfiguredEvent selectedEvent;
    private @NonNull CountersEbsShared ebs;
    private @NonNull CountersEbsSharedViewModel ebsViewModel;
    private final int EBS_LAYOUT_HEIGHT = 100;
    private SpeEditorComposite speEditorComposite;
    protected @NonNull Composite parent;
    protected @NonNull Composite mStack;
    protected @Nullable Text minLatency_text;
    private final @NonNull List<@NonNull IBooleanConsumer> validityListeners = new ArrayList<IBooleanConsumer>();
    private boolean mIsValid;

    public EventsEditorComposite(@NonNull Composite parent, @NonNull CounterConfiguration config) {
        this.config = config;
        this.parent = parent;
        this.mIsValid = config.isEbsConfigValid();
    }

    public void createComposite() {
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.parent);
        this.mStack = new Composite(this.parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.mStack);
        this.mStack.setLayout((Layout)new StackLayout());
        this.createCounterEditor(this.mStack);
        this.createSpeEditor(this.mStack);
        this.config.getConfigurations().addListener(this);
        this.hideEditingComposite();
    }

    private void hideEditingComposite() {
        this.updateSelectedTargetCounter(null);
        this.updateValidty(true);
        ((GridData)this.mStack.getLayoutData()).heightHint = 0;
        this.packAndlayout();
    }

    private void createSpeEditor(@NonNull Composite stack) {
        this.speEditorComposite = new SpeEditorComposite(stack, this);
        this.speEditorComposite.createSpeEditor();
    }

    private void createCounterEditor(@NonNull Composite stack) {
        this.ebsViewModel = CountersEbsSharedViewModel.create(this.config.getConfigurations(), this.config.getEvents());
        this.ebsViewModel.propertyCountValueIsValid().addValueChangeListener(event -> this.updateValidty((Boolean)event.diff.getNewValue()));
        this.ebs = new CountersEbsShared(stack, this.ebsViewModel);
        this.ebs.getControl().addDisposeListener(e -> this.ebsViewModel.dispose());
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.ebs.getControl());
    }

    @Override
    public void handleRequest(@NonNull TargetCounter event) {
        this.setSelectedEvent(event);
        this.showHideEbsEditor(event);
    }

    private void setSelectedEvent(@Nullable TargetCounter event) {
        this.selectedEvent = event;
        this.updateSelectedTargetCounter(event);
    }

    private void showHideEbsEditor(@NonNull TargetCounter counter) {
        this.clearSpeDecorator();
        @NonNull StockCounter derivedFrom = counter.getDerivedFrom();
        boolean supportsEventBasedSampling = derivedFrom.supportsEventBasedSampling();
        boolean ebsUpdated = this.config.getConfigurations().ebsIsEnabled(counter);
        if (supportsEventBasedSampling && ebsUpdated) {
            this.updateSelectedTargetCounter(counter);
            ((StackLayout)this.mStack.getLayout()).topControl = this.ebs.getControl();
            ((GridData)this.mStack.getLayoutData()).heightHint = 100;
        } else {
            this.hideEditingComposite();
        }
        this.packAndlayout();
    }

    private void packAndlayout() {
        this.mStack.pack();
        this.parent.layout();
    }

    private void clearSpeDecorator() {
        if (this.speEditorComposite != null) {
            this.speEditorComposite.clearDecorator();
        }
    }

    public void updateSelectedTargetCounter(@Nullable TargetCounter counter) {
        this.ebsViewModel.propertyTargetCounter().setValue((Object)counter);
    }

    public void addValidityListener(@NonNull IBooleanConsumer listener) {
        this.validityListeners.add(listener);
        listener.accept(this.mIsValid);
    }

    public void removeValidityListener(@NonNull IBooleanConsumer listener) {
        this.validityListeners.remove(listener);
    }

    public void updateValidty(boolean isValid) {
        this.mIsValid = isValid && this.config.isEbsConfigValid();
        this.validityListeners.forEach(l -> l.accept(this.mIsValid));
    }

    @Override
    public void handleRequest(@NonNull SpeFilterConfiguration event) {
        this.setSelectedEvent(null);
        this.clearSpeDecorator();
        ((StackLayout)this.mStack.getLayout()).topControl = this.speEditorComposite.getControl();
        ((GridData)this.mStack.getLayoutData()).heightHint = -1;
        this.speEditorComposite.displaySpeConfiguration((IConfiguredEvent)event);
        this.packAndlayout();
    }

    @Override
    public void handleClearRequest() {
        this.setSelectedEvent(null);
        this.hideEditingComposite();
    }

    public Control getControl() {
        return this.mStack;
    }

    @Override
    public void handleEbsChanged(@Nullable TargetCounter counter) {
        if (!this.mStack.isDisposed()) {
            if (counter == null) {
                this.hideEditingComposite();
            } else if (this.selectedEvent == null || counter.equals(this.selectedEvent)) {
                this.showHideEbsEditor(counter);
            }
        }
    }

    @Override
    public void handleReload() {
    }
}

