/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.cmdline.CmdLineMessages;
import com.arm.streamline.cmdline.IReportPrintStream;
import com.arm.streamline.cmdline.ValueReporting;
import com.arm.streamline.common.model.Position;
import com.arm.streamline.common.model.Scales;
import com.arm.streamline.common.model.TimeUnit;
import com.arm.streamline.common.model.ZoomLevel;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.model.topology.ProcessingElementReference;
import com.arm.streamline.editortabs.callpath.CallPathColumn;
import com.arm.streamline.editortabs.callpath.CallPathRow;
import com.arm.streamline.editortabs.report.ColumnUtils;
import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureBuild;
import com.arm.streamline.jni.apcdbgen.proto.AccelerationStructureTransfer;
import com.arm.streamline.jni.apcdbgen.proto.BufferTransfer;
import com.arm.streamline.jni.apcdbgen.proto.CallPathNode;
import com.arm.streamline.jni.apcdbgen.proto.Dispatch;
import com.arm.streamline.jni.apcdbgen.proto.GPUWorkloadJobResolver;
import com.arm.streamline.jni.apcdbgen.proto.ICAMDataProvider;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJob;
import com.arm.streamline.jni.apcdbgen.proto.ICAMJobTypeResolver;
import com.arm.streamline.jni.apcdbgen.proto.ICAMTrack;
import com.arm.streamline.jni.apcdbgen.proto.IGPUWorkloadJob;
import com.arm.streamline.jni.apcdbgen.proto.ILabelVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ImageTransfer;
import com.arm.streamline.jni.apcdbgen.proto.Renderpass;
import com.arm.streamline.jni.apcdbgen.proto.StageType;
import com.arm.streamline.jni.apcdbgen.proto.TimelineWorkload;
import com.arm.streamline.jni.apcdbgen.proto.TraceRays;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.jni.reportmodel.icounters.CallPathRowValue;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.Analysis;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.model.capture.IChartDataProvider;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.capture.ISeriesDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.model.timeline.ProcessIdentifierRegex;
import com.arm.streamline.model.timeline.ThreadData;
import com.arm.streamline.protocol.capture.apc.protocol.external.MaliOpenCLCAMGenerator;
import com.arm.streamline.report.model.pe.ProcessingElementTopology;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.utility.text.ScaledFormat;
import com.arm.streamline.widget.outline.Column;
import com.arm.streamline.widget.outline.EnumColumn;
import com.arm.streamline.widget.outline.IColumnCompareType;
import com.arm.streamline.widget.outline.OutlineModel;
import com.arm.streamline.widget.outline.Row;
import com.arm.streamline.widget.outline.SimpleColumn;
import com.arm.streamline.widget.outline.TextCell;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Pair;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ReportProcessor {
    private static final boolean USE_TOTAL_COLUMNS = false;
    private static final @NonNull String CONTEXT_PREFIX = "Context 0x";
    protected boolean mAnalyzing;
    protected boolean mAnalyzingEarlyStop;
    private @NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames = Collections.emptyMap();
    private @NonNull Set<@NonNull String> mCallPathSources = Collections.emptySet();
    private boolean mDumpBookmark;
    private boolean mDumpCallPath;
    private boolean mDumpCAM;
    private boolean mDumpFunctions;
    private boolean mDumpHeatmap;
    private boolean mDumpIndividualThreads;
    private boolean mDumpLog;
    private boolean mDumpOpenCL;
    private boolean mDumpTimeline;
    private boolean mDumpWarnings;
    private @NonNull Format mFormat = Format.COMMAS;
    private @NonNull Set<@NonNull String> mFunctionSources = Collections.emptySet();
    private @NonNull Set<@NonNull String> mHeatmapSourceNames = Collections.emptySet();
    private String mSpecificProcessRegex;
    private String mThreadSpecifier;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$model$Analysis$DefaultTemplateMode;

    public static void dumpTimelineForEachThread(Analysis analysis, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, long start, long stop, IReportPrintStream stream, Format format, IProgressMonitor monitor, @NonNull List<@NonNull ThreadData> list) throws IOException {
        for (ThreadData thread : list) {
            int uid = thread.getUID();
            String name = (String)thread.getNameAndTid().first;
            int tid = (Integer)thread.getNameAndTid().second;
            Throwable throwable = null;
            Object var17_16 = null;
            try (PrintStream out = stream.forThreadTimeline(tid);){
                TIntHashSet selectedThread = new TIntHashSet();
                selectedThread.add(uid);
                ReportProcessor.emitTitle(out, String.format("Timeline Counter Values (for thread '%s', tid: %d)", name, tid));
                ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, (TIntSet)selectedThread, out, format, monitor);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private static void dumpReportOfFilteredProcessesAndThreads(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, int start, int stop, IReportPrintStream stream, Format format, PrintStream out, Analysis analysis, String threadSpecifier, Pair<List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filtered, boolean individualThreads) throws ReportException, IOException {
        if (out == null) {
            throw new IOException("Output stream can't be null");
        }
        ReportProcessor.emitThreadProcessData(out, (List)filtered.first, threadSpecifier, analysis);
        TIntHashSet threadDataUids = new TIntHashSet((Collection)((List)filtered.second).stream().map(ThreadData::getUID).collect(Collectors.toList()));
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, (TIntSet)threadDataUids, out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), (List)filtered.second);
        }
    }

    private static String threadsIn(List<@NonNull ProcessData> processData, Analysis analysis) {
        ArrayList<@NonNull String> allThreadsforProcess = new ArrayList<String>();
        List<@NonNull ThreadData> processThreads = ReportProcessor.getMatchingThreadsForProcesses(processData, null, analysis.getUniqueIdMap());
        for (ThreadData thread : processThreads) {
            @NonNull Pair<@NonNull String, @NonNull Integer> tData = thread.getNameAndTid();
            allThreadsforProcess.add(String.format("%s#%d%n", tData.first, tData.second));
        }
        Collections.sort(allThreadsforProcess, String.CASE_INSENSITIVE_ORDER);
        return String.join((CharSequence)"", allThreadsforProcess);
    }

    private static void dumpReportOfFilteredProcesses(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, Analysis analysis, int start, int stop, PrintStream out, IReportPrintStream stream, Format format, String processSpecifier, @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filtered, boolean individualThreads) throws IOException {
        if (out == null) {
            throw new IOException("Output stream can't be null");
        }
        ReportProcessor.emitProcessData(processSpecifier, (List)filtered.first, stream, out);
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, (TIntSet)ReportProcessor.asProcessUIDSet((List)filtered.first), out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), (List)filtered.second);
        }
    }

    private static void dumpReportUnfiltered(ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, Analysis analysis, int start, int stop, @NonNull PrintStream out, IReportPrintStream stream, Format format, List<@NonNull ProcessData> processes, boolean individualThreads) throws IOException {
        ReportProcessor.emitTitle(out, CmdLineMessages.TIME_TITLE_DEFAULT);
        ReportProcessor.dumpTimeline(analysis, valueReporting, zoomLevel, start, stop, null, out, format, (IProgressMonitor)new NullProgressMonitor());
        if (individualThreads) {
            List<@NonNull ThreadData> processThreads = ReportProcessor.getMatchingThreadsForProcesses(processes, null, analysis.getUniqueIdMap());
            ReportProcessor.dumpTimelineForEachThread(analysis, valueReporting, zoomLevel, start, stop, stream, format, (IProgressMonitor)new NullProgressMonitor(), processThreads);
        }
    }

    private static @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filterBySpecifiers(String processSpecifier, String threadSpecifier, Analysis analysis) throws ReportException {
        IProcessDataProvider processDataProvider = analysis.getProcessDataProvider();
        @NonNull List<@NonNull ProcessData> processDataList = ReportProcessor.filterProcesses(processSpecifier, processDataProvider);
        @NonNull ProcessIdentifierRegex threadIdentifierRegex = ReportProcessor.getThreadIdentifierRegex(threadSpecifier);
        @NonNull List<@NonNull ThreadData> threadDataList = ReportProcessor.getMatchingThreadsForProcesses(processDataList, threadIdentifierRegex, analysis.getUniqueIdMap());
        return new Pair(processDataList, threadDataList);
    }

    private static @NonNull List<@NonNull ThreadData> getMatchingThreadsForProcesses(List<@NonNull ProcessData> processDataList, ProcessIdentifierRegex threadIdentifierRegex, @NonNull IUniqueIds map) {
        Stream result = processDataList.stream().map(proc -> ReportProcessor.getThreadsForProcess(map, map.findProcess(proc.getUID()).orElse(null))).flatMap(list -> list.stream());
        if (threadIdentifierRegex == null) {
            return result.collect(Collectors.toList());
        }
        return result.filter(thrd -> threadIdentifierRegex.match(thrd.getNameAndTid())).collect(Collectors.toList());
    }

    private static List<ThreadData> getThreadsForProcess(@NonNull IUniqueIds map, UniqueProcess process) {
        ArrayList<ThreadData> threadData = new ArrayList<ThreadData>();
        map.getThreadsOf(process).forEach(thrd -> threadData.add(new ThreadData(0, thrd.getUid(), ((AbstractPerVmId.PerVmNonUniqueTid)thrd.getNonUid().getId()).id, thrd.getNonUid().getNameOrUnresolved())));
        return threadData;
    }

    private static @NonNull ProcessIdentifierRegex getThreadIdentifierRegex(String threadSpecifier) throws ReportException {
        return threadSpecifier == null ? ProcessIdentifierRegex.MATCH_ANY : ReportProcessor.parseOrThrow(threadSpecifier, "Invalid value for thread specifier: ");
    }

    private static @NonNull List<@NonNull ProcessData> filterProcesses(@Nullable String processSpecifier, @NonNull IProcessDataProvider processProvider) throws ReportException {
        if (processSpecifier != null) {
            try {
                return processProvider.getSpecificProcessData(processSpecifier, IProcessDataProvider.ThreadMode.PROCESS_ONLY);
            }
            catch (PatternSyntaxException e) {
                throw new ReportException(String.format("Invalid value for process specifier: %s", e.getMessage()));
            }
        }
        return processProvider.getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY);
    }

    private static @NonNull ProcessIdentifierRegex parseOrThrow(@NonNull String matchSpecifier, @NonNull String errorMsgPrefix) throws ReportException {
        try {
            return ProcessIdentifierRegex.parse(matchSpecifier);
        }
        catch (PatternSyntaxException e) {
            throw new ReportException(errorMsgPrefix + e.getMessage());
        }
    }

    private static void emitProcessData(String processSpecifier, List<@NonNull ProcessData> processDataList, IReportPrintStream stream, PrintStream out) throws IOException {
        if (processDataList.size() > 1) {
            stream.message(MessageFormat.format(CmdLineMessages.MORE_THAN_ONE_PROCESSES_FOUND, processSpecifier));
        }
        String matchedProcesses = processDataList.stream().map(processData -> {
            boolean validID = processData.getProcessID() > 0;
            return String.format("<%s%s%s>", processData.getProcessName(), validID ? Character.valueOf('#') : "", validID ? Integer.valueOf(processData.getProcessID()) : "");
        }).collect(Collectors.joining(", "));
        ReportProcessor.emitTitle(out, MessageFormat.format(CmdLineMessages.TIME_TITLE_FILTERED_PROCESS, matchedProcesses.toString()));
    }

    private static void emitThreadProcessData(PrintStream out, List<@NonNull ProcessData> processData, String threadSpecifier, Analysis analysis) throws ReportException {
        @NonNull ProcessIdentifierRegex threadIdentifierRegex = ReportProcessor.getThreadIdentifierRegex(threadSpecifier);
        IUniqueIds map = analysis.getUniqueIdMap();
        StringBuilder result = new StringBuilder();
        Collections.sort(processData, (proc1, proc2) -> {
            int pid2;
            int pid1 = (Integer)proc1.getNameAndPid().second;
            return pid1 < (pid2 = ((Integer)proc2.getNameAndPid().second).intValue()) ? -1 : (pid1 > pid2 ? 1 : 0);
        });
        processData.stream().forEach(proc -> {
            @NonNull List<ThreadData> threadsForProcess = ReportProcessor.getThreadsForProcess(map, map.findProcess(proc.getUID()).orElse(null));
            Collections.sort(threadsForProcess, (thrd1, thrd2) -> {
                int tid2;
                int tid1 = (Integer)thrd1.getNameAndTid().second;
                return tid1 < (tid2 = ((Integer)thrd2.getNameAndTid().second).intValue()) ? -1 : (tid1 > tid2 ? 1 : 0);
            });
            threadsForProcess.stream().filter(thrd -> threadIdentifierRegex.match(thrd.getNameAndTid())).forEach(thrd -> {
                @NonNull Pair<@NonNull String, @NonNull Integer> procNamePid = proc.getNameAndPid();
                @NonNull @NonNull Pair<@NonNull String, @NonNull Integer> thrdNameTid = thrd.getNameAndTid();
                result.append(String.format("<%s#%d.%s#%d>,", procNamePid.first, procNamePid.second, thrdNameTid.first, thrdNameTid.second));
            });
        });
        ReportProcessor.emitTitle(out, MessageFormat.format(CmdLineMessages.TIME_TITLE_FILTERED_THREAD, result.toString()));
    }

    private static void generateProcessError(String processSpecifier, Analysis analysis) throws ReportException {
        Object wrongProcessError = String.format("Specifier '%s' did not match any process. Processes found are:%n", processSpecifier);
        ArrayList<@NonNull String> allAvailableProc = new ArrayList<String>();
        for (ProcessData process : analysis.getProcessDataProvider().getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY)) {
            Pair<@NonNull String, @NonNull Integer> processData = process.getNameAndPid();
            allAvailableProc.add(String.format("%s#%d%n", processData.first, processData.second));
        }
        Collections.sort(allAvailableProc, String.CASE_INSENSITIVE_ORDER);
        wrongProcessError = (String)wrongProcessError + String.join((CharSequence)"", allAvailableProc);
        throw new ReportException((String)wrongProcessError);
    }

    public static void dumpTimeline(Analysis analysis, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, long start, long stop, TIntSet selectedProcessAndThreadIds, PrintStream out, Format format, IProgressMonitor monitor) {
        TimeUnit timeUnit = analysis.getTimeUnit();
        TIntHashSet selected = analysis.convertToThreadUIDs(selectedProcessAndThreadIds);
        List<@NonNull IChartDataProvider> timelines = analysis.getCharts().getCharts();
        monitor.beginTask(CmdLineMessages.TIMELINE_PROGRESS_TITLE, (int)(stop - start));
        long nextUpdate = System.currentTimeMillis() + 100L;
        ArrayList<String> titles = new ArrayList<String>();
        TIntArrayList columnMaxes = new TIntArrayList();
        titles.add(MessageFormat.format(CmdLineMessages.TIME, timeUnit.getBaseSymbol()));
        columnMaxes.add(ReportProcessor.formatTimeMaxWidth(stop, zoomLevel, timeUnit));
        for (IChartDataProvider timeline : timelines) {
            @NonNull IChartDataProvider.IChartCoreInformationProvider coreInformationProvider = timeline.getCoreInformationProvider();
            @NonNull ProcessingElementReference @NonNull [] channels = coreInformationProvider.getChannelDescriptors();
            @NonNull List<@NonNull ISeriesDataProvider> series = timeline.getSeries();
            int sc = 0;
            String chartTitle = timeline.getTitle();
            String text = ScaledFormat.format(valueReporting == ValueReporting.PER_CORE ? timeline.getCoreLimit() : timeline.getAggregateLimit(), timeline.isPercentage(), -1, null);
            int limit = text.length() + 3;
            boolean hasMultipleVms = analysis.hasMultipleVms();
            while (sc < series.size()) {
                String name = series.get(sc).getName();
                String fullName = null;
                if (name != null) {
                    fullName = chartTitle + ':' + name;
                }
                switch (valueReporting) {
                    case PER_CORE: {
                        @Nullable DeviceType deviceType = coreInformationProvider.getDeviceType();
                        if (deviceType != null && channels.length > 1) {
                            ProcessingElementReference[] processingElementReferenceArray = channels;
                            int n = channels.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ProcessingElementReference channel = processingElementReferenceArray[n2];
                                if (name != null) {
                                    Object number;
                                    String vmNameAndNumber;
                                    String vmName;
                                    String string = vmName = hasMultipleVms ? (String)NullChecking.neverNullOr((Object)analysis.getVmName(channel.vmUID), (Object)"") : "";
                                    String string2 = hasMultipleVms ? (vmName.isEmpty() ? Long.toString(channel.vmUID) : String.format("%d: %s", channel.vmUID, name)) : (vmNameAndNumber = "");
                                    if (deviceType.isSystemWide()) {
                                        assert (hasMultipleVms);
                                        number = vmNameAndNumber;
                                    } else if (deviceType.isCPU()) {
                                        @Nullable ProcessingElementTopology topology = coreInformationProvider.getTopology(channel);
                                        number = (String)(hasMultipleVms ? vmNameAndNumber + " " : "") + (topology != null ? Integer.toString(topology.osID) : Integer.toString(channel.deviceNumber));
                                    } else {
                                        number = (String)(hasMultipleVms ? vmNameAndNumber + " " : "") + Integer.toString(channel.deviceNumber);
                                    }
                                    titles.add(MessageFormat.format(CmdLineMessages.PER, fullName, number));
                                } else {
                                    titles.add(null);
                                }
                                columnMaxes.add(limit);
                                ++n2;
                            }
                            break;
                        }
                    }
                    case AGGREGATE: {
                        titles.add(fullName);
                        columnMaxes.add(limit);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown ValueReporting variant: " + String.valueOf((Object)valueReporting));
                    }
                }
                ++sc;
            }
        }
        int cols = titles.size();
        String[] text = titles.toArray(new String[cols]);
        int[] widths = null;
        if (format == Format.SPACES) {
            widths = new int[cols];
            int i = 0;
            while (i < widths.length) {
                if (text[i] != null) {
                    widths[i] = Math.max(text[i].length(), columnMaxes.get(i));
                }
                ++i;
            }
        }
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 0x1000000);
        if (widths != null) {
            int i = 0;
            while (i < widths.length) {
                if (text[i] != null) {
                    text[i] = TableExport.makeFiller(widths[i], '-');
                }
                ++i;
            }
            TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 16384);
        }
        int work = 0;
        if (start < (long)analysis.getBinCount(zoomLevel)) {
            int pos = 0;
            ArrayList<SeriesData> seriesData = new ArrayList<SeriesData>();
            long binIndex = start;
            while (binIndex < stop) {
                int j = 0;
                text[j++] = ReportProcessor.formatTimeForReport(binIndex, zoomLevel, timeUnit);
                if ((binIndex - start) % 1024L == 0L) {
                    seriesData.clear();
                    long end = Math.min(binIndex + 1024L - 1L, Math.min((long)analysis.getBinCountForDensestScale(), stop));
                    for (IChartDataProvider timeline : timelines) {
                        @NonNull List<@NonNull ISeriesDataProvider> series = timeline.getSeries();
                        for (ISeriesDataProvider serie : series) {
                            seriesData.add(new SeriesData(timeline, serie, binIndex, end, selected, valueReporting));
                        }
                    }
                    pos = 0;
                }
                for (SeriesData data : seriesData) {
                    if (data.mCoreData != null) {
                        int k = 0;
                        while (k < data.mCoreCount) {
                            if (text[j] != null) {
                                text[j] = ScaledFormat.formatForReport(data.mCoreData[k][pos], data.isPercentage, -1, null);
                            }
                            ++j;
                            ++k;
                        }
                        continue;
                    }
                    if (text[j] != null) {
                        text[j] = ScaledFormat.formatForReport(data.mData[pos], data.isPercentage, -1, null);
                    }
                    ++j;
                }
                ++pos;
                TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, text, 131072);
                ++work;
                long now = System.currentTimeMillis();
                if (now >= nextUpdate) {
                    nextUpdate = now + 100L;
                    monitor.worked(work);
                    work = 0;
                    if (monitor.isCanceled()) break;
                }
                ++binIndex;
            }
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpAllCAM(Analysis analysis, int start, int stop, IReportPrintStream stream, Format format, IProgressMonitor monitor) throws IOException {
        Analysis analysis2 = analysis;
        synchronized (analysis2) {
            for (ICAMDataProvider model : analysis.getCAMDataProviders()) {
                PrintStream out = stream.forCAM(model);
                ReportProcessor.emitTitle(out, String.format("%s %s%s", CmdLineMessages.CAM_TITLE, model.getName(), analysis.hasMultipleVms() ? String.format(" [%d - %s]", model.getVmUID(), analysis.getVmName(model.getVmUID())) : ""));
                ReportProcessor.dumpCAM(model, start, stop, out, format, monitor, analysis.getTimeUnit());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpAllOpenCL(Analysis analysis, int start, int stop, @NonNull IReportPrintStream stream, Format format, IProgressMonitor monitor) throws IOException {
        Analysis analysis2 = analysis;
        synchronized (analysis2) {
            for (ICAMDataProvider model : analysis.getCAMDataProviders()) {
                if (!model.isOpenCL()) continue;
                @NonNull PrintStream out = stream.forOpenCL(model.getVmUID());
                ReportProcessor.emitTitle(out, CmdLineMessages.OPENCL_TITLE);
                ReportProcessor.dumpOpenCL(model, start, stop, out, format, monitor, analysis.getTimeUnit());
                break;
            }
        }
    }

    private static @NonNull String idToString(int id) {
        return Long.toString((long)id & 0xFFFFFFFFL);
    }

    private static int[] calculateInitialWidths(@NonNull List<@NonNull String> columns, ICAMDataProvider model, TimeUnit timeUnit) {
        int[] widths = new int[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            String column = columns.get(i);
            int width = column.length();
            if (CmdLineMessages.CAM_ID.equals(column)) {
                width = Math.max(width, ReportProcessor.idToString(model.getMaxEventId()).length());
            } else if (CmdLineMessages.CAM_NAME.equals(column)) {
                width = Math.max(width, model.getMaxCommandStringLength());
            } else if (CmdLineMessages.CAM_START.equals(column) || CmdLineMessages.CAM_STOP.equals(column)) {
                width = Math.max(width, timeUnit.maxWidth((double)model.getLastTime(), 1000.0, TimeUnit.Style.NO_UNIT));
            } else if (CmdLineMessages.CAM_PRIMARY_DEPENDENCY.equals(column) || CmdLineMessages.CAM_DEPENDENCIES.equals(column)) {
                int idWidth = ReportProcessor.idToString(model.getMaxEventId()).length();
                width = Math.max(width, model.getMaxDependencies() * (idWidth + 1));
            }
            widths[i] = width;
            ++i;
        }
        return widths;
    }

    private static void dumpCAM(@NonNull ICAMDataProvider model, int start, int stop, PrintStream out, Format format, IProgressMonitor monitor, @NonNull TimeUnit timeUnit) {
        start *= 1000;
        stop *= 1000;
        @NonNull ArrayList<@NonNull String> columnOrder = new ArrayList<String>(List.of(CmdLineMessages.CAM_ID, CmdLineMessages.CAM_TRACK_TITLE, CmdLineMessages.CAM_NAME, CmdLineMessages.CAM_START, CmdLineMessages.CAM_STOP, CmdLineMessages.CAM_PRIMARY_DEPENDENCY, CmdLineMessages.CAM_DEPENDENCIES));
        if (model.isMaliTimeline()) {
            columnOrder.add(CmdLineMessages.CAM_CONTEXT_ID);
            if (model.hasGPUWorkloadJobs()) {
                columnOrder.addAll(new ArrayList<String>(List.of(CmdLineMessages.CAM_DEBUG_LABELS, CmdLineMessages.CAM_STAGE, CmdLineMessages.CAM_WORKLOAD_ID, CmdLineMessages.CAM_FRAME, CmdLineMessages.CAM_CMD_BUFFER, CmdLineMessages.CAM_COUNT, CmdLineMessages.CAM_TYPE, CmdLineMessages.CAM_X, CmdLineMessages.CAM_Y, CmdLineMessages.CAM_Z, CmdLineMessages.CAM_RENDERPASS_SUBPASS_COUNT, CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS, CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS_LOADED, CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS_STORED)));
            }
        }
        int[] widths = ReportProcessor.calculateInitialWidths(columnOrder, model, timeUnit);
        long nextUpdate = System.currentTimeMillis() + 100L;
        List events = model.getAllJobsAsList();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, columnOrder.toArray(new String[0]), 0x1000000);
        if (format == Format.SPACES) {
            String[] divider = new String[columnOrder.size()];
            int i = 0;
            while (i < columnOrder.size()) {
                divider[i] = TableExport.makeFiller(widths[i], '-');
                ++i;
            }
            TableExport.exportTextInColumns(writer, widths, format == Format.TABS, format == Format.COMMAS, divider, 16384);
        }
        int work = 0;
        for (ICAMJob item : events) {
            IGPUWorkloadJob gpuWorkloadJob;
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long stopTime = Math.round((double)item.getStopTime() / 1000.0);
            if ((startTime < (long)start || startTime > (long)stop) && (stopTime < (long)start || stopTime > (long)stop)) continue;
            CAMRow row = new CAMRow(columnOrder);
            row.set(CmdLineMessages.CAM_ID, ReportProcessor.idToString(item.getId()));
            row.set(CmdLineMessages.CAM_NAME, item.getName());
            row.set(CmdLineMessages.CAM_START, timeUnit.formatInBase((double)(startTime * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true));
            row.set(CmdLineMessages.CAM_STOP, timeUnit.formatInBase((double)(stopTime * 1000L), 1000.0, TimeUnit.Style.NO_UNIT, true));
            ICAMJob primaryDependency = item.getPrimaryDependency();
            if (primaryDependency != null && primaryDependency.getId() != -1) {
                row.set(CmdLineMessages.CAM_PRIMARY_DEPENDENCY, ReportProcessor.idToString(primaryDependency.getId()));
            } else {
                row.set(CmdLineMessages.CAM_PRIMARY_DEPENDENCY, "");
            }
            List dependencies = item.getDependencies();
            if (dependencies.size() > 0) {
                StringBuilder depStr = new StringBuilder(ReportProcessor.idToString(((ICAMJob)dependencies.get(0)).getId()));
                int i = 1;
                while (i < dependencies.size()) {
                    depStr.append(",");
                    depStr.append(ReportProcessor.idToString(((ICAMJob)dependencies.get(i)).getId()));
                    ++i;
                }
                row.set(CmdLineMessages.CAM_DEPENDENCIES, depStr.toString());
            } else {
                row.set(CmdLineMessages.CAM_DEPENDENCIES, "");
            }
            ICAMTrack track = item.getTrack();
            row.set(CmdLineMessages.CAM_TRACK_TITLE, track.getTitle());
            if (model.isMaliTimeline() && columnOrder.contains(CmdLineMessages.CAM_CONTEXT_ID)) {
                ICAMTrack parentTrack = track.getParent();
                if (parentTrack != null && parentTrack.getTitle().startsWith(CONTEXT_PREFIX)) {
                    String context = parentTrack.getTitle().substring(CONTEXT_PREFIX.length() - 2);
                    row.set(CmdLineMessages.CAM_CONTEXT_ID, context);
                } else {
                    row.set(CmdLineMessages.CAM_CONTEXT_ID, "");
                }
            }
            if ((gpuWorkloadJob = (IGPUWorkloadJob)item.accept((ICAMJobTypeResolver)new GPUWorkloadJobResolver())) != null) {
                TimelineWorkload gpuWorkload = gpuWorkloadJob.getTimelineWorkload();
                row.set(CmdLineMessages.CAM_NAME, gpuWorkload.getName());
                row.set(CmdLineMessages.CAM_WORKLOAD_ID, Long.toString(gpuWorkload.getId()));
                row.set(CmdLineMessages.CAM_DEBUG_LABELS, String.join((CharSequence)",", gpuWorkload.getDebugLabels()));
                StageType stageTypeAsEnum = gpuWorkloadJob.getPerfettoWorkload().getStageTypeAsEnum();
                if (stageTypeAsEnum != null) {
                    row.set(CmdLineMessages.CAM_STAGE, stageTypeAsEnum.stageName());
                }
                row.set(CmdLineMessages.CAM_FRAME, Long.toString(gpuWorkload.getFrame()));
                Long commandBuffer = gpuWorkloadJob.getPerfettoWorkload().commandBufferHandle();
                if (commandBuffer != null) {
                    row.set(CmdLineMessages.CAM_CMD_BUFFER, String.format("0x%x", commandBuffer));
                }
                CSVVisitor visitor = new CSVVisitor(row);
                gpuWorkload.accept((ILabelVisitor)visitor);
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, row.toArray(), 131072);
            ++work;
            long now = System.currentTimeMillis();
            if (now < nextUpdate) continue;
            nextUpdate = now + 100L;
            monitor.worked(work);
            work = 0;
            if (monitor.isCanceled()) break;
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    private static void dumpOpenCL(@NonNull ICAMDataProvider model, int start, int stop, PrintStream out, Format format, IProgressMonitor monitor, @NonNull TimeUnit timeUnit) {
        start *= 1000;
        stop *= 1000;
        String[] text = new String[10];
        int[] widths = new int[text.length];
        long nextUpdate = System.currentTimeMillis() + 100L;
        List events = model.getAllJobsAsList();
        TIntHashSet completedEventIds = new TIntHashSet();
        PrintWriter writer = new PrintWriter(new OutputStreamWriter(out));
        text[0] = CmdLineMessages.OPENCL_ID;
        text[1] = CmdLineMessages.OPENCL_COMMAND;
        text[2] = CmdLineMessages.OPENCL_INITIATED_TIME;
        text[3] = CmdLineMessages.OPENCL_TIME_TO_START;
        text[4] = CmdLineMessages.OPENCL_DURATION;
        text[5] = CmdLineMessages.OPENCL_THREAD;
        text[6] = CmdLineMessages.OPENCL_CONTEXT;
        text[7] = CmdLineMessages.OPENCL_DEVICE;
        text[8] = CmdLineMessages.OPENCL_QUEUE;
        text[9] = CmdLineMessages.OPENCL_DEPENDENCIES;
        widths[0] = ReportProcessor.idToString(model.getMaxEventId()).length();
        widths[1] = model.getMaxCommandStringLength();
        widths[2] = timeUnit.maxWidth((double)model.getLastTime(), 1000.0, TimeUnit.Style.NO_UNIT);
        widths[3] = widths[2];
        widths[4] = widths[3];
        widths[5] = 10;
        widths[6] = 10;
        widths[7] = CmdLineMessages.OPENCL_DEVICE.length();
        widths[8] = 10;
        widths[9] = model.getMaxDependencies() * (widths[0] + 1);
        int i = 0;
        while (i < text.length) {
            widths[i] = Math.max(widths[i], text[i].length());
            ++i;
        }
        int maxDeviceTitleLength = widths[7];
        for (ICAMTrack track : model.getTracksNonHierarchical()) {
            if (!MaliOpenCLCAMGenerator.isNotSpeciallyNamedOpenCLTrack((String)track.getTitle())) continue;
            maxDeviceTitleLength = Math.max(maxDeviceTitleLength, track.getTitle().length());
        }
        widths[7] = maxDeviceTitleLength;
        TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 0x1000000);
        if (format == Format.SPACES) {
            int i2 = 0;
            while (i2 < text.length) {
                text[i2] = TableExport.makeFiller(widths[i2], '-');
                ++i2;
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 16384);
        }
        int work = 0;
        for (ICAMJob eventItem : events) {
            int[] dependencies;
            ICAMTrack queueTrack;
            ICAMTrack contextTrack;
            ICAMJob item = ReportProcessor.getOpenCLRootItem(eventItem);
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long stopTime = Math.round((double)item.getStopTime() / 1000.0);
            if (completedEventIds.contains(item.getId()) || (startTime < (long)start || startTime > (long)stop) && (stopTime < (long)start || stopTime > (long)stop)) continue;
            String commandName = item.getName();
            text[0] = ReportProcessor.idToString(item.getId());
            text[1] = commandName;
            text[2] = timeUnit.formatInBase((double)(1000L * startTime), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[3] = timeUnit.formatInBase((double)(1000L * ReportProcessor.getOpenCLCommandTimeToStart(item)), 1000.0, TimeUnit.Style.NO_UNIT, true);
            text[4] = timeUnit.formatInBase((double)(1000L * ReportProcessor.getOpenCLCommandDuration(item)), 1000.0, TimeUnit.Style.NO_UNIT, true);
            ICAMTrack threadTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item), "Thread ");
            if (threadTrack != null) {
                text[5] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(threadTrack.getTitle(), "Thread ");
            } else {
                threadTrack = item.getTrack();
            }
            ICAMTrack contextDependentTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item), "Queue ");
            ICAMTrack deviceTrack = null;
            if (contextDependentTrack != null) {
                deviceTrack = contextDependentTrack.getParent();
            }
            if (deviceTrack != null && (contextTrack = deviceTrack.getParent()) != null) {
                text[6] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(contextTrack.getTitle(), "OpenCL Context: ");
            }
            if (deviceTrack != null) {
                text[7] = deviceTrack.getTitle();
            }
            if ((queueTrack = ReportProcessor.getOpenCLTrackForItem(ReportProcessor.getOpenCLRootItem(item), "Queue ")) != null) {
                text[8] = ReportProcessor.getOpenCLTrackNameWithoutPrefix(queueTrack.getTitle(), "Queue ");
            }
            if ((dependencies = ReportProcessor.getOpenCLDependencyIdsForEventItem(item)).length == 0) {
                text[9] = "";
            } else {
                StringBuilder depStr = new StringBuilder(ReportProcessor.idToString(dependencies[0]));
                int dependenciesLength = dependencies.length;
                int i3 = 1;
                while (i3 < dependenciesLength) {
                    depStr.append(",");
                    depStr.append(ReportProcessor.idToString(dependencies[i3]));
                    ++i3;
                }
                text[9] = depStr.toString();
            }
            TableExport.exportTextInColumns(writer, (int[])(format == Format.SPACES ? widths : null), format == Format.TABS, format == Format.COMMAS, text, 131072);
            ++work;
            long now = System.currentTimeMillis();
            if (now >= nextUpdate) {
                nextUpdate = now + 100L;
                monitor.worked(work);
                work = 0;
                if (monitor.isCanceled()) break;
            }
            ReportProcessor.markOpenCLEventAndItsPrimaryLinksAsCompleted(item, completedEventIds);
        }
        monitor.worked(work);
        writer.flush();
        monitor.done();
    }

    private static void emitTitle(PrintStream out, String title) {
        out.println();
        out.println(title);
        out.println();
    }

    private static long getOpenCLCommandDuration(ICAMJob item) {
        long startTime;
        long endTime = startTime = Math.round((double)item.getStartTime() / 1000.0);
        Stack<ICAMJob> stack = new Stack<ICAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            ICAMJob currentItem = (ICAMJob)stack.pop();
            startTime = currentItem.getStartTime();
            endTime = currentItem.getStopTime();
            ICAMJob event = currentItem.getPrimaryDependent();
            if (event == null) continue;
            stack.push(event);
        }
        startTime = Math.round((double)startTime / 1000.0);
        endTime = Math.round((double)endTime / 1000.0);
        return endTime - startTime;
    }

    private static long getOpenCLCommandTimeToStart(ICAMJob item) {
        ICAMJob dependent = item.getPrimaryDependent();
        if (dependent != null) {
            long startTime = Math.round((double)item.getStartTime() / 1000.0);
            long dependentStartTime = Math.round((double)dependent.getStartTime() / 1000.0);
            return dependentStartTime - startTime;
        }
        return 0L;
    }

    private static int[] getOpenCLDependencyIdsForEventItem(ICAMJob item) {
        TIntHashSet ids = new TIntHashSet();
        Stack<ICAMJob> stack = new Stack<ICAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            ICAMJob currentItem = (ICAMJob)stack.pop();
            int dependentCount = currentItem.getDependencies().size();
            int i = 0;
            while (i < dependentCount) {
                ICAMJob dependencyItem = (ICAMJob)currentItem.getDependencies().get(i);
                ids.add(ReportProcessor.getOpenCLRootItem(dependencyItem).getId());
                ++i;
            }
            ICAMJob event = currentItem.getPrimaryDependent();
            if (event == null) continue;
            stack.push(event);
        }
        return ids.toArray();
    }

    private static ICAMJob getOpenCLRootItem(ICAMJob item) {
        Stack<ICAMJob> stack = new Stack<ICAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            ICAMJob currentItem = (ICAMJob)stack.pop();
            ICAMJob event = currentItem.getPrimaryDependency();
            if (event == null) {
                return currentItem;
            }
            stack.push(event);
        }
        return item;
    }

    private static ICAMTrack getOpenCLTrackForItem(ICAMJob item, String trackName) {
        Stack<ICAMJob> stack = new Stack<ICAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            ICAMJob currentItem = (ICAMJob)stack.pop();
            ICAMTrack track = currentItem.getTrack();
            String trackLabel = track.getTitle();
            if (trackLabel.length() >= trackName.length() && trackLabel.substring(0, trackName.length()).equals(trackName)) {
                return track;
            }
            ICAMJob event = currentItem.getPrimaryDependency();
            if (event == null) continue;
            stack.push(event);
        }
        return null;
    }

    private static String getOpenCLTrackNameWithoutPrefix(String trackName, String prefix) {
        if (trackName.length() >= prefix.length()) {
            return trackName.substring(prefix.length());
        }
        return " ";
    }

    private static void markOpenCLEventAndItsPrimaryLinksAsCompleted(ICAMJob item, TIntHashSet completedEventIds) {
        Stack<ICAMJob> stack = new Stack<ICAMJob>();
        stack.push(item);
        while (stack.size() > 0) {
            ICAMJob currentItem = (ICAMJob)stack.pop();
            completedEventIds.add(currentItem.getId());
            ICAMJob event = currentItem.getPrimaryDependent();
            if (event == null) continue;
            stack.push(event);
        }
    }

    static @NonNull String formatTime(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBin(bin, zoomLevel, TimeUnit.Style.NO_UNIT, true);
    }

    static @NonNull String formatTimeForReport(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatTimeNonLocalised(bin, zoomLevel);
    }

    static int formatTimeMaxWidth(long bin, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
        return timeUnit.formatBinMaxWidth(bin, zoomLevel, TimeUnit.Style.NO_UNIT);
    }

    public @Nullable Format getFormat() {
        return this.mFormat;
    }

    public void setCallpathSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mCallPathSources = sourceNames;
    }

    public void setDisasmSourcesAndImageNames(@NonNull Map<@NonNull String, @NonNull Pair<@Nullable String, @Nullable Set<@NonNull String>>> disasmSourcesAndImageNames) {
        this.disasmSourcesAndImageNames = disasmSourcesAndImageNames;
    }

    public void setDumpAll() {
        this.mDumpBookmark = true;
        this.mDumpCallPath = true;
        this.mDumpCAM = true;
        this.mDumpFunctions = true;
        this.mDumpHeatmap = true;
        this.mDumpLog = true;
        this.mDumpOpenCL = true;
        this.mDumpTimeline = true;
        this.mDumpWarnings = true;
    }

    public void setDumpBookmarks(boolean dumpBookmarks) {
        this.mDumpBookmark = dumpBookmarks;
    }

    public void setDumpCallPath(boolean dumpCallPath) {
        this.mDumpCallPath = dumpCallPath;
    }

    public void setDumpCAM(boolean dumpCAM) {
        this.mDumpCAM = dumpCAM;
    }

    public void setDumpFunctions(boolean dumpFunctions) {
        this.mDumpFunctions = dumpFunctions;
    }

    public void setDumpHeatmap(boolean dumpHeatMap) {
        this.mDumpHeatmap = dumpHeatMap;
    }

    public void setDumpIndividualThreads(boolean dumpIndividualThreads) {
        this.mDumpIndividualThreads = dumpIndividualThreads;
    }

    public void setDumpLog(boolean dumpLog) {
        this.mDumpLog = dumpLog;
    }

    public void setDumpOpenCL(boolean dumpOpenCL) {
        this.mDumpOpenCL = dumpOpenCL;
    }

    public void setDumpTimeline(boolean dumpTimeline) {
        this.mDumpTimeline = dumpTimeline;
    }

    public void setDumpWarnings(boolean dumpWarnings) {
        this.mDumpWarnings = dumpWarnings;
    }

    public void setFormat(@NonNull Format format) {
        this.mFormat = format;
    }

    public void setFunctionSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mFunctionSources = sourceNames;
    }

    public void setHeatmapSources(@NonNull Set<@NonNull String> sourceNames) {
        this.mHeatmapSourceNames = sourceNames;
    }

    public void setProcessSpecifier(String processSpecifier) {
        this.mSpecificProcessRegex = processSpecifier;
    }

    public void setThreadSpecifier(String threadSpecifier) {
        this.mThreadSpecifier = threadSpecifier;
    }

    /*
     * Exception decompiling
     */
    public boolean start(List<String> files, @NonNull Analysis.DefaultTemplateMode defaultTemplate, @Nullable List<@NonNull String> templatePaths, ValueReporting valueReporting, @NonNull ZoomLevel zoomLevel, double startSeconds, double stopSeconds, String bookmarkStart, String bookmarkStop, @NonNull IReportPrintStream stream, boolean averageHeatmapPerCore) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean filterCallPathProcessOrThread(@NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filteredProcessesAndThreads, @NonNull CallPathRowValue node, boolean showProcessRows) {
        switch (node.getCallPathNode().type) {
            case PROCESS: {
                return ((List)filteredProcessesAndThreads.first).stream().anyMatch(d -> (long)d.getUID() == callPathRowValue.getCallPathNode().itemUID);
            }
            case THREAD: {
                if (!showProcessRows && ((List)filteredProcessesAndThreads.first).stream().anyMatch(d -> (long)d.getUID() == callPathRowValue.getCallPathNode().itemUID)) {
                    return true;
                }
                return ((List)filteredProcessesAndThreads.second).stream().anyMatch(d -> (long)d.getUID() == callPathRowValue.getCallPathNode().itemUID);
            }
        }
        throw new AssertionError(node.getCallPathNode().type);
    }

    private void dumpCallpathsForEachThread(@NonNull IReportPrintStream stream, @NonNull IInstructionCounterSource instructionCounterSource, @Nullable List<? extends @NonNull Row<EnumColumn<CallPathRowValue>>> rows, @Nullable List<@NonNull ThreadData> onlyMatchingThreads) throws IOException {
        if (rows == null) {
            return;
        }
        block4: for (Row<EnumColumn<CallPathRowValue>> row : rows) {
            CallPathRow cpr = (CallPathRow)row;
            CallPathNode node = ((CallPathRowValue)cpr.getModelObject()).getCallPathNode();
            switch (node.type) {
                case PROCESS: 
                case VMUID: {
                    this.dumpCallpathsForEachThread(stream, instructionCounterSource, row.getChildren(), onlyMatchingThreads);
                    return;
                }
                case THREAD: {
                    boolean matches;
                    boolean bl = matches = onlyMatchingThreads != null ? onlyMatchingThreads.stream().anyMatch(t -> (long)t.getUID() == callPathNode.itemUID) : true;
                    if (!matches) continue block4;
                    this.dumpCallpathsForEachThread(stream, instructionCounterSource, cpr);
                    break;
                }
                default: {
                    throw new AssertionError(node.type);
                }
            }
        }
    }

    private void dumpCallpathsForEachThread(@NonNull IReportPrintStream stream, @NonNull IInstructionCounterSource instructionCounterSource, @NonNull CallPathRow cpr) throws IOException {
        OutlineModel thisThreadModel = new OutlineModel();
        thisThreadModel.addRow(cpr, true);
        Pair<String, Integer> threadNameTidPair = ProcessIdentifierRegex.getNameAndPidPair(((CallPathRowValue)cpr.getModelObject()).getName());
        Throwable throwable = null;
        Object var7_8 = null;
        try (PrintStream threadCallPathOut = stream.forThreadCallpath((Integer)threadNameTidPair.second);){
            ColumnUtils.createColumns(thisThreadModel, CallPathColumn.aggregateColumns(instructionCounterSource, false), null);
            this.dumpReport(threadCallPathOut, thisThreadModel, CmdLineMessages.CALL_CHAIN_TITLE, true, true);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void validateProcessAndThreadArgs(Analysis analysis, String processSpecifier, String threadSpecifier, @NonNull Pair<@NonNull List<@NonNull ProcessData>, @NonNull List<@NonNull ThreadData>> filteredProcessesAndThreads) throws ReportException {
        if (processSpecifier == null && threadSpecifier != null) {
            throw new ReportException(String.format("The -%s option requires the -%s option to be set also.", "thread", "process"));
        }
        @NonNull @NonNull List filteredProcesses = (List)filteredProcessesAndThreads.first;
        @NonNull @NonNull List filteredThreads = (List)filteredProcessesAndThreads.second;
        if (processSpecifier != null && filteredProcesses.isEmpty()) {
            ReportProcessor.generateProcessError(processSpecifier, analysis);
        }
        if (threadSpecifier != null && filteredThreads.isEmpty()) {
            throw new ReportException(String.format("Specifier '%s' does not match any available thread in the selected process(es).  Threads available are:%n%s", threadSpecifier, ReportProcessor.threadsIn(filteredProcesses, analysis)));
        }
    }

    private static TIntHashSet asProcessUIDSet(@NonNull List<@NonNull ProcessData> processes) {
        return new TIntHashSet((Collection)processes.stream().map(ProcessData::getUID).collect(Collectors.toList()));
    }

    private void dumpBookmarks(Analysis analysis, PrintStream out) throws IOException {
        @NonNull ArrayList<@NonNull SimpleColumn> columns = new ArrayList<SimpleColumn>();
        int i = 0;
        columns.add(new SimpleColumn(i++, MessageFormat.format(CmdLineMessages.TIME, analysis.getTimeUnit().getBaseSymbol()), new TextCell<SimpleColumn>(131072, IColumnCompareType.INTEGER())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.BOOKMARK, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        @NonNull ZoomLevel zoomLevel = analysis.getStateFile().getResolution().toDensestZoomLevel();
        @NonNull TimeUnit timeUnit = analysis.getTimeUnit();
        @NonNull ArrayList<@NonNull BookmarkRow> rows = new ArrayList<BookmarkRow>();
        for (Bookmark bookmark : analysis.getBookmarks()) {
            rows.add(new BookmarkRow(bookmark, zoomLevel, timeUnit));
        }
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.addNonHierarchicalRowsFast(rows);
        for (SimpleColumn column : columns) {
            model.addColumn(column);
        }
        this.dumpReport(out, model, CmdLineMessages.BOOKMARK_TITLE, false, false);
    }

    private <C extends Column<C>> void dumpReport(PrintStream out, OutlineModel<C> model, String title, boolean sort, boolean includeChildren) throws IOException {
        ReportProcessor.emitTitle(out, title);
        if (sort) {
            model.sort();
        }
        TableExport.export(out, this.mFormat == Format.TABS, this.mFormat == Format.COMMAS, includeChildren, model.getColumns(), model.getRows());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void dumpWarnings(Analysis analysis, PrintStream out) throws IOException {
        @NonNull ArrayList<@NonNull SimpleColumn> columns = new ArrayList<SimpleColumn>();
        int i = 0;
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_NAME, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_TYPE, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_SEVERITY, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        columns.add(new SimpleColumn(i++, CmdLineMessages.WARNING_DESC, new TextCell<SimpleColumn>(16384, IColumnCompareType.TEXT())));
        @NonNull @NonNull List warningItems = analysis.getWarnings().getItems();
        @NonNull ArrayList<@NonNull WarningsRow> rows = new ArrayList<WarningsRow>();
        for (WarningItem item : warningItems) {
            rows.add(new WarningsRow(item));
        }
        OutlineModel<SimpleColumn> model = new OutlineModel<SimpleColumn>();
        model.addNonHierarchicalRowsFast(rows);
        for (SimpleColumn column : columns) {
            model.addColumn(column);
        }
        this.dumpReport(out, model, CmdLineMessages.WARNINGS_TITLE, false, false);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$arm$streamline$model$Analysis$DefaultTemplateMode() {
        if ($SWITCH_TABLE$com$arm$streamline$model$Analysis$DefaultTemplateMode != null) {
            return $SWITCH_TABLE$com$arm$streamline$model$Analysis$DefaultTemplateMode;
        }
        int[] nArray = new int[Analysis.DefaultTemplateMode.values().length];
        try {
            nArray[Analysis.DefaultTemplateMode.FORCE_PROVIDED.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Analysis.DefaultTemplateMode.USE_DEFAULT_BASIC.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Analysis.DefaultTemplateMode.USE_DEFAULT_WITH_METRICS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Analysis.DefaultTemplateMode.USE_PROVIDED_OR_PREFER_BASIC.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Analysis.DefaultTemplateMode.USE_PROVIDED_OR_PREFER_METRICS.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$arm$streamline$model$Analysis$DefaultTemplateMode = nArray;
        return nArray;
    }

    private static /* synthetic */ boolean lambda$11(String string, IInstructionCounterSource src) {
        return src.getName().contentEquals(string);
    }

    private static /* synthetic */ boolean lambda$12(Pair pair, boolean bl, CallPathRowValue node) {
        return ReportProcessor.filterCallPathProcessOrThread((Pair<List<ProcessData>, List<ThreadData>>)pair, node, bl);
    }

    private static /* synthetic */ boolean lambda$13(CallPathRowValue node) {
        return true;
    }

    private static /* synthetic */ boolean lambda$14(String string, IInstructionCounterSource src) {
        return src.getName().contentEquals(string);
    }

    private static class BookmarkRow
    extends Row<SimpleColumn> {
        private Bookmark mBookmark;
        private final @NonNull TimeUnit mTimeUnit;
        private final @NonNull ZoomLevel mZoomLevel;

        public BookmarkRow(Bookmark bookmark, @NonNull ZoomLevel zoomLevel, @NonNull TimeUnit timeUnit) {
            this.mBookmark = bookmark;
            this.mZoomLevel = zoomLevel;
            this.mTimeUnit = timeUnit;
        }

        @Override
        public double getDataAsDouble(SimpleColumn column) {
            return this.getDataAsLong(column);
        }

        @Override
        public long getDataAsLong(SimpleColumn column) {
            if (column.getID() == 0) {
                return Position.scale((long)this.mBookmark.getTimestamp(), (ZoomLevel)Scales.ONE_NANOSECOND_ZOOM_LEVEL, (ZoomLevel)this.mZoomLevel);
            }
            return 0L;
        }

        @Override
        public String getDataAsText(SimpleColumn column) {
            if (column.getID() == 0) {
                return ReportProcessor.formatTime(this.getDataAsLong(column), this.mZoomLevel, this.mTimeUnit);
            }
            return this.mBookmark.getTitle();
        }

        @Override
        public void setData(SimpleColumn column, Object data) {
        }
    }

    private static class CAMRow {
        private final LinkedHashMap<String, String> columnMap = new LinkedHashMap();

        public CAMRow(List<String> columnOrder) {
            for (String key : columnOrder) {
                this.columnMap.put(key, "");
            }
        }

        public void set(String key, String value) {
            if (!this.columnMap.containsKey(key)) {
                throw new IllegalArgumentException("Unknown column: " + key);
            }
            this.columnMap.put(key, value);
        }

        public String[] toArray() {
            return this.columnMap.values().toArray(new String[0]);
        }
    }

    private static class CSVVisitor
    implements ILabelVisitor {
        private @NonNull CAMRow mRow;

        public CSVVisitor(@NonNull CAMRow row) {
            this.mRow = row;
        }

        public void visit(@NonNull Renderpass renderPass) {
            this.mRow.set(CmdLineMessages.CAM_X, Long.toString(renderPass.getWidth()));
            this.mRow.set(CmdLineMessages.CAM_Y, Long.toString(renderPass.getHeight()));
            this.mRow.set(CmdLineMessages.CAM_COUNT, Long.toString(renderPass.getDrawCallCount()));
            this.mRow.set(CmdLineMessages.CAM_RENDERPASS_SUBPASS_COUNT, Long.toString(renderPass.getSubpassCount()));
            this.mRow.set(CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS, renderPass.getAttachments());
            this.mRow.set(CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS_LOADED, renderPass.getAttachmentsLoaded());
            this.mRow.set(CmdLineMessages.CAM_RENDERPASS_ATTACHMENTS_STORED, renderPass.getAttachmentsStored());
        }

        public void visit(@NonNull Dispatch dispatch) {
            this.mRow.set(CmdLineMessages.CAM_X, Long.toString(dispatch.getX()));
            this.mRow.set(CmdLineMessages.CAM_Y, Long.toString(dispatch.getY()));
            this.mRow.set(CmdLineMessages.CAM_Z, Long.toString(dispatch.getZ()));
        }

        public void visit(@NonNull TraceRays traceRays) {
            this.mRow.set(CmdLineMessages.CAM_X, Long.toString(traceRays.getX()));
            this.mRow.set(CmdLineMessages.CAM_Y, Long.toString(traceRays.getY()));
            this.mRow.set(CmdLineMessages.CAM_Z, Long.toString(traceRays.getZ()));
        }

        public void visit(@NonNull ImageTransfer imageTransfer) {
            this.mRow.set(CmdLineMessages.CAM_COUNT, Long.toString(imageTransfer.getPixelCount()));
            this.mRow.set(CmdLineMessages.CAM_TYPE, imageTransfer.getTransferType().displayName());
        }

        public void visit(@NonNull BufferTransfer bufferTransfer) {
            this.mRow.set(CmdLineMessages.CAM_COUNT, Long.toString(bufferTransfer.getByteCount()));
            this.mRow.set(CmdLineMessages.CAM_TYPE, bufferTransfer.getTransferType().displayName());
        }

        public void visit(AccelerationStructureBuild build) {
            this.mRow.set(CmdLineMessages.CAM_COUNT, Long.toString(build.getPrimitiveCount()));
            this.mRow.set(CmdLineMessages.CAM_TYPE, build.getBuildType().displayName());
        }

        public void visit(AccelerationStructureTransfer accStructTransfer) {
            this.mRow.set(CmdLineMessages.CAM_COUNT, Long.toString(accStructTransfer.getByteCount()));
            this.mRow.set(CmdLineMessages.CAM_TYPE, accStructTransfer.getBuildType().displayName());
        }
    }

    public static enum Format {
        COMMAS,
        SPACES,
        TABS;

    }

    private static class ReportException
    extends Exception {
        public ReportException(@NonNull String message, @NonNull Throwable cause) {
            super(message, cause);
        }

        public ReportException(@NonNull String message) {
            super(message);
        }
    }

    private static class SeriesData {
        boolean isPercentage;
        int mCoreCount;
        double[][] mCoreData;
        double[] mData;

        SeriesData(IChartDataProvider chart, ISeriesDataProvider series, long start, long end, TIntHashSet selected, ValueReporting valueReporting) {
            @NonNull ProcessingElementReference @NonNull [] channels = chart.getCoreInformationProvider().getChannelDescriptors();
            @Nullable DeviceType deviceType = chart.getCoreInformationProvider().getDeviceType();
            this.isPercentage = chart.isPercentage();
            switch (valueReporting) {
                case PER_CORE: {
                    if (deviceType != null && channels.length > 1) {
                        this.mCoreCount = channels.length;
                        this.mCoreData = new double[channels.length][];
                        int k = 0;
                        while (k < channels.length) {
                            this.mCoreData[k] = series.getData(channels[k], (int)start, (int)end, (TIntSet)selected);
                            ++k;
                        }
                        break;
                    }
                }
                case AGGREGATE: {
                    this.mData = series.getData((int)start, (int)end, (TIntSet)selected);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown ValueReporting variant: " + String.valueOf((Object)valueReporting));
                }
            }
        }
    }

    private static class WarningsRow
    extends Row<SimpleColumn> {
        private @NonNull String mDesc;
        private @NonNull String mName;
        private @NonNull WarningSeverity mSeverity;
        private @NonNull WarningType mType;

        public WarningsRow(@NonNull WarningItem item) {
            this.mName = item.getTitle();
            this.mType = item.getType();
            this.mSeverity = item.getSeverity();
            this.mDesc = item.getDescription();
        }

        @Override
        public double getDataAsDouble(@NonNull SimpleColumn column) {
            return 0.0;
        }

        @Override
        public long getDataAsLong(@NonNull SimpleColumn column) {
            return 0L;
        }

        @Override
        public String getDataAsText(SimpleColumn column) {
            switch (column.getID()) {
                case 0: {
                    return this.mName;
                }
                case 1: {
                    return this.mType.getXmlKey();
                }
                case 2: {
                    return this.mSeverity.getXmlKey();
                }
            }
            return this.mDesc;
        }

        @Override
        public void setData(@NonNull SimpleColumn column, Object data) {
        }
    }
}

