/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.cmdline;

import com.arm.streamline.common.utility.text.NumberUtils;
import com.arm.streamline.editortabs.report.TableExport;
import com.arm.streamline.jni.apcdbgen.proto.IColumnDescriptor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleCounterColumnValueVisitor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataAccessor;
import com.arm.streamline.jni.apcdbgen.proto.ISampleInstructionRowDataProperties;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportData;
import com.arm.streamline.jni.apcdbgen.proto.ISamplesReportDataForDisasmAndSourceAnnotations;
import com.arm.streamline.jni.apcdbgen.proto.ImageFile;
import com.arm.streamline.jni.apcdbgen.proto.SourceLocation;
import com.arm.streamline.jni.apcdbgen.proto.Symbol;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.jni.reportmodel.icounters.IInstructionCounterSource;
import com.arm.streamline.model.icounters.InstructionCounterCodeColumnsWithMetadata;
import com.arm.streamline.model.icounters.proto.NullProgressMonitorFactory;
import com.arm.utils.StreamUtils;
import com.arm.utils.function.IThrowingConsumer;
import com.arm.utils.function.IThrowingFunction;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;

public final class ExportDisasm {
    public static void generateCsv(@NonNull List<@NonNull ImageFile> availableImages, @NonNull IInstructionCounterSource sourceToUse, @NonNull PrintStream outputStream) throws IOException, CodecException {
        ExportDisasm.generateOutput(sourceToUse, (IThrowingFunction<List<InstructionCounterCodeColumnsWithMetadata>, ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback<IOException>, IOException>)((IThrowingFunction)columns -> ExportDisasm.createCsvConsumer(columns, outputStream)), availableImages);
    }

    public static void generateCsvFor(@NonNull List<@NonNull ImageFile> availableImages, @NonNull IInstructionCounterSource sourceToUse, @NonNull Set<@NonNull String> allowedImageNames, @NonNull PrintStream outputStream) throws IOException, CodecException {
        List<ImageFile> filteredImages = availableImages.stream().filter(i -> ExportDisasm.isRetainedImage(i, allowedImageNames)).collect(Collectors.toList());
        ExportDisasm.generateCsv(filteredImages, sourceToUse, outputStream);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback<IOException> createCsvConsumer(@NonNull List<@NonNull InstructionCounterCodeColumnsWithMetadata> columns, @NonNull OutputStream outputStream) throws IOException {
        @NonNull String title = StreamUtils.concat((Stream[])new Stream[]{Arrays.stream(ForEachFunctionCallback.COLUMNS).map(TableExport::makeCSVSafe), columns.stream().map(ExportDisasm::makeColumnTitle)}).collect(Collectors.joining(",", "", "\n"));
        outputStream.write(title.getBytes(StandardCharsets.UTF_8));
        return new ForEachFunctionCallback(columns, (IThrowingConsumer<String[], IOException>)((IThrowingConsumer)row -> {
            @NonNull String string = Arrays.stream(row).map(TableExport::makeCSVSafe).collect(Collectors.joining(",", "", "\n"));
            outputStream.write(string.getBytes(StandardCharsets.UTF_8));
        }));
    }

    private static @NonNull List<@NonNull InstructionCounterCodeColumnsWithMetadata> extractAllExportableColumns(@NonNull IInstructionCounterSource source) {
        ArrayList<InstructionCounterCodeColumnsWithMetadata> result = new ArrayList<InstructionCounterCodeColumnsWithMetadata>();
        InstructionCounterCodeColumnsWithMetadata.extractSubcolumns(result, source, source.getInstructionAndSourceLineColumns());
        result.removeIf(c -> !c.column.isExportable());
        return result;
    }

    private static void generateOutput(@NonNull IInstructionCounterSource source, @NonNull IThrowingFunction<@NonNull List<@NonNull InstructionCounterCodeColumnsWithMetadata>, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback<IOException>, IOException> outputFactory, @NonNull List<@NonNull ImageFile> availableImages) throws IOException, CodecException {
        List<InstructionCounterCodeColumnsWithMetadata> exportableColumns = ExportDisasm.extractAllExportableColumns(source);
        NullProgressMonitorFactory progressMonitorFactory = new NullProgressMonitorFactory();
        ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback consumer = (ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback)outputFactory.apply(exportableColumns);
        Throwable throwable = null;
        Object var7_8 = null;
        try (CancellationPredicate cancellationPredicate = new CancellationPredicate();){
            for (ImageFile image : availableImages) {
                ISamplesReportData reportData = source.getActiveReportData();
                ISamplesReportDataForDisasmAndSourceAnnotations imageData = reportData.computeDisasmAndSourceData(image.uid, false, cancellationPredicate, (IProgressMonitorFactory)progressMonitorFactory);
                if (imageData == null) continue;
                imageData.forEachInstruction(true, consumer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean isRetainedImage(@NonNull ImageFile i, @NonNull Set<@NonNull String> allowedImageNames) {
        String cn = i.containerName;
        return allowedImageNames.contains(i.imageName) || cn != null && (allowedImageNames.contains(cn) || allowedImageNames.contains(i.getNameWithContainer()));
    }

    private static @NonNull String makeColumnTitle(@NonNull InstructionCounterCodeColumnsWithMetadata column) {
        return column.getNestedTitle();
    }

    private static final class ForEachFunctionCallback
    implements ISamplesReportDataForDisasmAndSourceAnnotations.IForEachFunctionCallback<IOException> {
        public static final @NonNull String @NonNull [] COLUMNS = new String[]{"Image", "Function", "Address", "Type", "OpCode", "Disassembly", "Target Symbol", "Source File", "Source Line", "Inlined"};
        private final @NonNull List<@NonNull InstructionCounterCodeColumnsWithMetadata> columns;
        private final @NonNull IThrowingConsumer<@NonNull String @NonNull [], IOException> consumer;

        private static @NonNull String opcodeType(byte @NonNull [] opcode, // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ISampleInstructionRowDataProperties.RowType rowType) {
            switch (rowType) {
                case ARM32: {
                    if (opcode.length != 4) break;
                    return "A32";
                }
                case ARM64: {
                    if (opcode.length != 4) break;
                    return "A64";
                }
                case THUMB: {
                    if (opcode.length == 4) {
                        return "T32";
                    }
                    if (opcode.length != 2) break;
                    return "T16";
                }
            }
            throw new AssertionError((Object)("Invalid opcode: " + String.valueOf(rowType) + ", " + opcode.length));
        }

        public ForEachFunctionCallback(@NonNull List<@NonNull InstructionCounterCodeColumnsWithMetadata> columns, @NonNull IThrowingConsumer<@NonNull String @NonNull [], IOException> consumer) {
            this.consumer = consumer;
            this.columns = columns;
        }

        public boolean accept(long index, @NonNull ISampleInstructionRowDataAccessor rowDataAccessor) throws IOException {
            ISampleInstructionRowDataProperties properties = rowDataAccessor.getRowProperties();
            switch (properties.getRowType()) {
                case SYMBOL_LABEL: {
                    this.emitSymbol(properties);
                    break;
                }
                case DATA: 
                case NONE: {
                    break;
                }
                case ARM32: 
                case ARM64: 
                case THUMB: {
                    this.emitInstruction(rowDataAccessor);
                    break;
                }
                default: {
                    throw new AssertionError(properties.getRowType());
                }
            }
            return true;
        }

        private void emitInstruction(@NonNull ISampleInstructionRowDataAccessor rowDataAccessor) throws IOException {
            ISampleInstructionRowDataProperties properties = rowDataAccessor.getRowProperties();
            byte[] opcode = properties.getOpcodeOrData();
            SourceLocation sourceLocation = properties.getOriginalSourceLocation();
            SourceLocation inlineSourceLocation = properties.getInlinedSourceLocation();
            boolean inline = inlineSourceLocation != null || properties.getInlinedSymbolName() != null;
            @NonNull String @NonNull [] row = new String[COLUMNS.length + this.columns.size()];
            row[0] = properties.getSymbol().image.getNameWithContainer();
            row[1] = properties.getSymbol().getName();
            row[2] = String.format("0x%016x", properties.getAddress());
            row[3] = ForEachFunctionCallback.opcodeType(opcode, properties.getRowType());
            row[4] = NumberUtils.formatOpcode((byte[])opcode, (properties.getRowType() == ISampleInstructionRowDataProperties.RowType.THUMB ? 1 : 0) != 0, (properties.getRowType() == ISampleInstructionRowDataProperties.RowType.ARM32 || properties.getRowType() == ISampleInstructionRowDataProperties.RowType.ARM64 ? 1 : 0) != 0);
            row[5] = properties.getDisassembly();
            row[6] = ForEachFunctionCallback.formatTargetSymbol(properties);
            String string = sourceLocation != null ? sourceLocation.sourceFile.filePath : (row[7] = inlineSourceLocation != null ? inlineSourceLocation.sourceFile.filePath : "");
            row[8] = sourceLocation != null ? String.format("%d", sourceLocation.lineNo) : (inlineSourceLocation != null ? String.format("%d", inlineSourceLocation.lineNo) : "");
            row[9] = inline ? "I" : "";
            int index = COLUMNS.length;
            for (InstructionCounterCodeColumnsWithMetadata column : this.columns) {
                String val = (String)rowDataAccessor.getColumnValueFor(column.column, (ISampleCounterColumnValueVisitor)new ISampleCounterColumnValueVisitor<Void, String, RuntimeException>(){

                    public @NonNull String empty(Void data, @NonNull IColumnDescriptor descriptor) throws RuntimeException {
                        return "";
                    }

                    public @NonNull String histogram(Void data, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IColumnDescriptor.IHistogramColumnDescriptor descriptor, long limit, long @NonNull [] values) throws RuntimeException {
                        return Arrays.stream(values).mapToObj(String::valueOf).collect(Collectors.joining("/", "", ""));
                    }

                    public @NonNull String number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor descriptor, double value) throws RuntimeException {
                        switch (descriptor.getFormat()) {
                            case number: {
                                return String.format("%01.2f", value);
                            }
                            case mpki: 
                            case percent: {
                                return String.format("%01.02f", value);
                            }
                        }
                        throw new AssertionError(descriptor.getFormat());
                    }

                    public @NonNull String number(Void data, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IColumnDescriptor.ISimpleValueColumnDescriptor descriptor, long value) throws RuntimeException {
                        return Long.toString(value);
                    }

                    public @NonNull String percentAndNumber(Void data, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IColumnDescriptor.IPercentAndValueColumnDescriptor descriptor, long value, double percent) throws RuntimeException {
                        return String.format("%01 (%02.2f%%)", value, percent);
                    }

                    public @NonNull String ratio(Void data, // Could not load outer class - annotation placement on inner may be incorrect
                    @NonNull IColumnDescriptor.IRatioColumnDescriptor descriptor, long @NonNull [] values) throws RuntimeException {
                        return Arrays.stream(values).mapToObj(String::valueOf).collect(Collectors.joining(":", "", ""));
                    }
                }, null);
                row[index++] = val;
            }
            this.consumer.accept((Object)row);
        }

        private static @NonNull String formatTargetSymbol(@NonNull ISampleInstructionRowDataProperties properties) {
            Symbol targetSymbol = properties.getTargetSymbol();
            long targetOffset = properties.getTargetSymbolOffset();
            if (targetSymbol == null) {
                return "";
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(targetSymbol.getName());
            if (targetOffset > 0L) {
                buffer.append(" + ");
                buffer.append("0x");
                buffer.append(Long.toHexString(targetOffset).toUpperCase());
            }
            return buffer.toString();
        }

        private void emitSymbol(@NonNull ISampleInstructionRowDataProperties properties) throws IOException {
            Symbol symbol = properties.getSymbol();
            this.consumer.accept((Object)new String[]{symbol.image.getNameWithContainer(), symbol.getName()});
        }
    }
}

