/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture.astf;

import com.arm.streamline.astf.ASTFClusterInfo;
import com.arm.streamline.astf.ASTFCoreInfo;
import com.arm.streamline.capture.astf.InvalidASTFClustersInfoException;
import com.arm.streamline.capture.astf.Messages;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.TIntList;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TIntIntMap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.File;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ASTFClustersInfo
implements IClustersInfo {
    private final @NonNull TIntObjectMap<@NonNull TIntList> clusterToCores;
    private final @NonNull TIntObjectMap<@NonNull String> clusterHumanNames;
    private final @NonNull TIntObjectMap<@NonNull String> clusterNames;
    private final @NonNull TIntObjectMap<@NonNull ASTFCoreInfo> clusterToCoreInfo = new TIntObjectHashMap(10, 0.5f, -1);
    private final @NonNull TIntIntMap coreClusterMap;

    public ASTFClustersInfo(@NonNull List<@NonNull ASTFClusterInfo> clusters) throws InvalidASTFClustersInfoException {
        this.clusterHumanNames = new TIntObjectHashMap(10, 0.5f, -1);
        this.clusterNames = new TIntObjectHashMap(10, 0.5f, -1);
        this.clusterToCores = new TIntObjectHashMap(10, 0.5f, -1);
        this.coreClusterMap = new TIntIntHashMap(10, 0.5f);
        if (clusters.size() == 0) {
            throw new InvalidASTFClustersInfoException(Messages.Error_ASTF_Duplicate_ClusterId);
        }
        for (ASTFClusterInfo cluster : clusters) {
            int clusterId = cluster.getId();
            String clusterName = cluster.getName();
            @NonNull String coreName = ASTFClustersInfo.getCoreNameFromCluster(cluster);
            if (this.clusterNames.containsKey(clusterId)) {
                throw new InvalidASTFClustersInfoException(Messages.Error_ASTF_Duplicate_ClusterId);
            }
            this.clusterNames.put(clusterId, (Object)clusterName);
            this.clusterHumanNames.put(clusterId, (Object)coreName);
            TIntArrayList coreIds = new TIntArrayList();
            for (ASTFCoreInfo core : cluster.getCores()) {
                int coreId = core.getId();
                coreIds.add(coreId);
                if (this.coreClusterMap.containsKey(coreId)) {
                    throw new InvalidASTFClustersInfoException(Messages.Error_ASTF_Duplicate_CoreId);
                }
                this.coreClusterMap.put(coreId, clusterId);
                this.clusterToCoreInfo.put(clusterId, (Object)core);
            }
            this.clusterToCores.put(clusterId, (Object)coreIds);
        }
    }

    private static @NonNull String getCoreNameFromCluster(@NonNull ASTFClusterInfo cluster) throws InvalidASTFClustersInfoException {
        if (cluster.getCores().size() == 0) {
            throw new InvalidASTFClustersInfoException("Cluster " + cluster.getName() + " contains no cores");
        }
        return cluster.getCores().getFirst().getName();
    }

    public @Nullable Integer findClusterIndex(int core) {
        TIntObjectIterator iterator = this.clusterToCores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            TIntList coreList = (TIntList)iterator.value();
            if (!coreList.contains(core)) continue;
            return iterator.key();
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Integer findClusterIndex(@Nullable String clusterName) {
        if (this.clusterNames.containsValue((Object)clusterName)) {
            @NonNull TIntObjectIterator iterator = this.clusterNames.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (!((String)iterator.value()).equals(clusterName)) continue;
                return iterator.key();
            }
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable String getClusterHumanName(int clusterId) {
        if (this.clusterHumanNames.containsKey(clusterId)) {
            @NonNull TIntObjectIterator iterator = this.clusterHumanNames.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (iterator.key() != clusterId) continue;
                return (String)iterator.value();
            }
        }
        return null;
    }

    public @Nullable Integer getClusterIndex(CounterRecord record) {
        return record.getCluster();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable String getClusterName(int clusterId) {
        if (this.clusterNames.containsKey(clusterId)) {
            @NonNull TIntObjectIterator iterator = this.clusterNames.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                if (iterator.key() != clusterId) continue;
                return (String)iterator.value();
            }
        }
        return null;
    }

    public @NonNull TIntObjectMap<String> getClusterNames() {
        return this.clusterNames;
    }

    public @Nullable TIntList getCores(int clusterIndex) {
        return (TIntList)this.clusterToCores.get(clusterIndex);
    }

    public @NonNull TIntIntMap getCpuClusterIds() {
        return this.coreClusterMap;
    }

    public int getNumberOfClusters() {
        return this.clusterToCores.size();
    }

    public boolean hasClusters() {
        return this.getNumberOfClusters() > 0;
    }

    public boolean isGatorClusterInformationMissing() {
        return false;
    }

    public void updateCounterRecordsWithClusterInformation(boolean forceClusters, @NonNull List<@NonNull CounterRecord> counterRecordList) {
    }

    public void writeXML(@NonNull File outputPath) {
        GatorClusters.writeXml((File)outputPath, this.getClusterNames(), (TIntIntMap)this.getCpuClusterIds());
    }
}

