/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.capture;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.report.model.ResolutionMode;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.IElfImageStore;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.model.session.IAnalysisInputSettings;
import com.arm.streamline.model.session.PathWithEnabledFlag;
import com.arm.streamline.model.session.SessionImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class SimpleAnalysisSettings
implements IAnalysisInputSettings {
    public static final String APC_FILE_PATH = "report/analysis-settings.xml";
    private static final String ANALYSIS_SETTINGS_ELEM = "analysis-settings";
    private static final String FILTER_CALL_STACKS_DATA_ATTR = "filter-call-stacks";
    private static final String IMAGE_SEARCH_PATH_ELEM = "image-search-path";
    private static final String PARSE_DEBUG_INFO_ATTR = "parse-debug-info";
    private static final String RESOLUTION_MODE_ATTR = "resolution-mode";
    private static final @NonNull String ATTR_IMAGE_SEARCH_ENABLED = "image_search_enabled";
    private final boolean allowImageSearch;
    private @Nullable File file;
    private boolean filterCallStacksData;
    private @NonNull List<@NonNull SessionImage> images;
    private boolean imageSearchEnabled;
    private @NonNull Set<@NonNull PathWithEnabledFlag> imageSearchPaths;
    private boolean parseDebugInfo;
    private @NonNull ResolutionMode resolutionMode;

    /*
     * Unable to fully structure code
     */
    public SimpleAnalysisSettings(@NonNull File file, @NonNull ResolutionMode defaultResolutionMode, @NonNull IElfImageStore elfImageStore, boolean allowImageSearch) {
        block15: {
            super();
            this.filterCallStacksData = true;
            this.images = new ArrayList<SessionImage>();
            this.imageSearchEnabled = false;
            this.imageSearchPaths = new TreeSet<PathWithEnabledFlag>();
            this.parseDebugInfo = true;
            this.resolutionMode = ResolutionMode.NORMAL;
            this.file = file;
            this.allowImageSearch = allowImageSearch;
            this.resolutionMode = defaultResolutionMode;
            try {
                var5_5 = null;
                var6_8 = null;
                try {
                    parser = XMLParser.create((File)file);
                    try {
                        this.load(parser);
                        break block15;
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                catch (Throwable var6_9) {
                    if (var5_5 == null) {
                        var5_5 = var6_9;
                    } else if (var5_5 != var6_9) {
                        var5_5.addSuppressed(var6_9);
                    }
                    throw var5_5;
                }
            }
            catch (IOException exception) {
                this.parseDebugInfo = true;
                this.filterCallStacksData = true;
                this.resolutionMode = defaultResolutionMode;
                this.images.clear();
                ** for (elfImage : elfImageStore.getAvailableImages())
            }
lbl-1000:
            // 1 sources

            {
                try {
                    elfImage.processFile();
                    this.images.add(new SessionImage(elfImage.getFile(), true));
                }
                catch (CodecException e) {
                    CommonPlugin.warning((Throwable)e);
                }
                catch (IOException e) {
                    CommonPlugin.warning((Throwable)e);
                }
                continue;
            }
        }
    }

    protected SimpleAnalysisSettings(@NonNull InputStream stream, boolean allowImageSearch) throws IOException {
        this.filterCallStacksData = true;
        this.images = new ArrayList<SessionImage>();
        this.imageSearchEnabled = false;
        this.imageSearchPaths = new TreeSet<PathWithEnabledFlag>();
        this.parseDebugInfo = true;
        this.resolutionMode = ResolutionMode.NORMAL;
        this.allowImageSearch = allowImageSearch;
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLParser parser = new XMLParser(stream);){
            this.load(parser);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public @NonNull List<@NonNull SessionImage> getImages() {
        return this.images;
    }

    @Override
    public @NonNull File @Nullable [] getImageSearchPaths() {
        return this.allowImageSearch && this.imageSearchEnabled ? (File[])this.imageSearchPaths.stream().map(e -> e.isUsed() ? e.getFile() : null).filter(f -> f != null).toArray(File[]::new) : null;
    }

    @Override
    public @NonNull Set<@NonNull PathWithEnabledFlag> getImageSearchPathsWithEnabledFlags() {
        return this.imageSearchPaths;
    }

    @Override
    public @NonNull List<@NonNull PathWithEnabledFlag> getJitDumpFilePaths() {
        return Collections.emptyList();
    }

    @Override
    public ResolutionMode getResolutionMode() {
        return this.resolutionMode;
    }

    @Override
    public boolean isFilterCallStacksDataEnabled() {
        return this.filterCallStacksData;
    }

    @Override
    public boolean isGenerateSpeSampleLogEnabled() {
        return false;
    }

    @Override
    public boolean isImageSearchingSupported() {
        return this.allowImageSearch;
    }

    @Override
    public boolean isJitDumpProfilingSupported() {
        return false;
    }

    @Override
    public boolean isParseDebugInfoEnabled() {
        return this.parseDebugInfo;
    }

    @Override
    public void save() throws IOException {
        File file = this.file;
        if (file != null) {
            CommonFileUtils.makeDirectory((String)file.getParent());
            Throwable throwable = null;
            Object var3_4 = null;
            try (@NonNull XMLGenerator generator = XMLGenerator.create((File)file);){
                this.save(generator);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void setFilterCallStacksData(boolean enabled) {
        this.filterCallStacksData = enabled;
    }

    @Override
    public void setImageSearchEnabled(boolean enabled) {
        this.imageSearchEnabled = enabled;
    }

    @Override
    public void setImageSearchPathsWithEnabledFlags(@NonNull Set<@NonNull PathWithEnabledFlag> paths) {
        this.imageSearchPaths = new TreeSet<PathWithEnabledFlag>(paths);
    }

    @Override
    public void setJitDumpFilePaths(@NonNull List<@NonNull PathWithEnabledFlag> pathsWithEnabledFlag) {
    }

    @Override
    public void setParseDebugInfoEnabled(boolean enabled) {
        this.parseDebugInfo = enabled;
    }

    @Override
    public void setResolutionMode(@NonNull ResolutionMode mode) {
        this.resolutionMode = mode;
    }

    protected void save(@NonNull XMLGenerator generator) throws IOException {
        generator.startDocument();
        generator.startTag(ANALYSIS_SETTINGS_ELEM);
        generator.addAttribute(PARSE_DEBUG_INFO_ATTR, this.parseDebugInfo);
        generator.addAttribute(FILTER_CALL_STACKS_DATA_ATTR, this.filterCallStacksData);
        generator.addAttribute(RESOLUTION_MODE_ATTR, this.resolutionMode.getStringValue());
        generator.addAttribute(ATTR_IMAGE_SEARCH_ENABLED, this.imageSearchEnabled);
        for (SessionImage image : this.getImages()) {
            image.save(generator);
        }
        for (PathWithEnabledFlag path : this.imageSearchPaths) {
            path.save(generator, IMAGE_SEARCH_PATH_ELEM);
        }
        generator.endTag();
        generator.endDocument();
    }

    private void load(@NonNull XMLParser parser) throws IOException {
        String tag = parser.nextTag(ANALYSIS_SETTINGS_ELEM);
        if (tag != null) {
            this.parseDebugInfo = parser.isAttributeSet(PARSE_DEBUG_INFO_ATTR, true);
            this.filterCallStacksData = parser.isAttributeSet(FILTER_CALL_STACKS_DATA_ATTR, true);
            this.resolutionMode = ResolutionMode.fromStringValue((String)parser.getAttribute(RESOLUTION_MODE_ATTR, RESOLUTION_DEFAULT.toString()));
            this.imageSearchEnabled = parser.isAttributeSet(ATTR_IMAGE_SEARCH_ENABLED, false);
        }
        String marker = parser.getMarker();
        while ((tag = parser.nextTag(marker)) != null) {
            switch (tag) {
                case "image": {
                    this.images.add(new SessionImage(parser));
                    break;
                }
                case "image-search-path": {
                    this.imageSearchPaths.add(new PathWithEnabledFlag(parser));
                    break;
                }
                default: {
                    parser.skip();
                }
            }
        }
    }
}

