/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.utils;

import com.arm.streamline.barmancfg.wizard.utils.AbstractFileOrDirectoryInputHelper;
import com.arm.streamline.barmancfg.wizard.utils.WizardUtils;
import com.arm.streamline.utility.ui.ILastFilterPathStore;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class AbstractFileInputHelper
extends AbstractFileOrDirectoryInputHelper
implements WizardUtils.IFileInputHelper {
    private final @NonNull String @NonNull [] filterExtensions;
    private final @NonNull String @NonNull [] filterNames;

    public AbstractFileInputHelper(@NonNull ILastFilterPathStore filterPathStore, @NonNull String @NonNull [] filterNames, @NonNull String @NonNull [] filterExtensions) {
        super(filterPathStore);
        this.filterExtensions = filterExtensions;
        this.filterNames = filterNames;
    }

    @Override
    public final @NonNull String @NonNull [] getFilterExtensions() {
        return this.filterExtensions;
    }

    @Override
    public final @NonNull String @NonNull [] getFilterNames() {
        return this.filterNames;
    }

    @Override
    protected final @Nullable String handleInputChanged(@NonNull String currentValue) {
        File result;
        File file = new File(currentValue);
        if (file.exists() && file.isFile() && this.validate(file) && (result = this.handleValidatedInputChanged(file)) != null) {
            return result.getAbsolutePath();
        }
        if (currentValue.isEmpty()) {
            this.handleInputCleared();
        } else {
            this.handleInputInvalid(currentValue);
        }
        return null;
    }

    protected abstract boolean validate(@NonNull File var1);

    protected abstract void handleInputCleared();

    protected abstract void handleInputInvalid(@NonNull String var1);

    protected abstract @Nullable File handleValidatedInputChanged(@NonNull File var1);
}

