/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard.events;

import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.barmancfg.wizard.events.AbstractProcessorPmuRow;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventPair;
import com.arm.streamline.barmancfg.wizard.events.ProcessorPmuEventRow;
import com.arm.streamline.barmancfg.wizard.events.SelectedEventsOutlineModel;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.NullChecking;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AvailableProcessorPmuRow
extends AbstractProcessorPmuRow {
    private final @NonNull SelectedEventsOutlineModel outlineModel;

    private static boolean doesEventMatchPattern(ProcessorPmuEventDescription event, @Nullable Pattern pattern) {
        @NonNull String eventName = (String)NullChecking.neverNull((Object)event.getEventName());
        @NonNull String groupName = (String)NullChecking.neverNull((Object)event.getGroupName());
        return AvailableProcessorPmuRow.doesEventMatchPattern(eventName, groupName, pattern);
    }

    private static boolean doesEventMatchPattern(@NonNull String eventName, @NonNull String groupName, @Nullable Pattern pattern) {
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(eventName).find() || pattern.matcher(groupName).find();
    }

    public AvailableProcessorPmuRow(@NonNull ProcessorPmu pmu, @NonNull SelectedEventsOutlineModel outlineModel, @Nullable Pattern pattern) {
        super(pmu);
        this.outlineModel = outlineModel;
        ArrayList<@NonNull V> events = new ArrayList(pmu.getEvents().values());
        events.sort((a, b) -> {
            int result = a.getGroupName().compareTo(b.getGroupName());
            if (result != 0) {
                return result;
            }
            return a.getEventName().compareTo(b.getEventName());
        });
        for (ProcessorPmuEventDescription event : events) {
            if (!AvailableProcessorPmuRow.doesEventMatchPattern(event, pattern)) continue;
            this.addChild(new ProcessorPmuEventRow(new ProcessorPmuEventPair(pmu, event), outlineModel));
        }
    }

    public boolean areEventSlotsAvailable() {
        int nEventSlots;
        int nSelected = this.getNumberOfSelectedChildrenForThisPmu();
        return nSelected < (nEventSlots = this.pmu.getNumberOfEventCounters());
    }

    public String getAvailableText() {
        int nSelected = this.getNumberOfSelectedChildrenForThisPmu();
        int nEventSlots = this.pmu.getNumberOfEventCounters();
        return MessageFormat.format(BarmanWizardMessages.PAGE_3_N_SELECTED, nSelected, nEventSlots);
    }

    private int getNumberOfSelectedChildrenForThisPmu() {
        return this.outlineModel.getNumEventsForPmu(this.getPmu());
    }
}

