/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.wizard;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.DWTConfiguration;
import com.arm.streamline.barmancfg.wizard.BarmanWizardMessages;
import com.arm.streamline.dwt.DWTUtils;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class BarmanDWTConfigPage
extends WizardPage {
    public static final String PAGE_NAME = "DWT_CONFIG_PAGE";
    private static final String[] periodsAsStrings;
    private static int defaultPCSamplePeriodIndex;
    private @NonNull IWizardPage nextPage;
    private Combo combo;
    private @NonNull BarmanConfiguration defaults;
    private int periodSelected;

    static {
        String s = Arrays.toString(DWTUtils.VALID_PC_SAMPLING_INTERVALS);
        periodsAsStrings = s.substring(1, s.length() - 1).split(", ");
        defaultPCSamplePeriodIndex = periodsAsStrings.length / 2;
    }

    protected BarmanDWTConfigPage(@NonNull IWizard wizard, @NonNull IWizardPage nextPage, @NonNull BarmanConfiguration defaults) {
        super(PAGE_NAME);
        super.setWizard(wizard);
        super.setTitle(BarmanWizardMessages.BarmanDWTConfigPage_TITLE);
        this.nextPage = nextPage;
        this.defaults = defaults;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 6).numColumns(3).applyTo(composite);
        BarmanDWTConfigPage.addLabel(composite, BarmanWizardMessages.BarmanDWTConfigPage_SAMPLING_INTERVAL_LABEL);
        this.combo = new Combo(composite, 0);
        this.combo.setItems(periodsAsStrings);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.combo);
        BarmanDWTConfigPage.addLabel(composite, BarmanWizardMessages.BarmanDWTConfigPage_CYCLES_LABEL);
        this.setDefaults();
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BarmanDWTConfigPage.this.periodSelected = DWTUtils.VALID_PC_SAMPLING_INTERVALS[BarmanDWTConfigPage.this.combo.getSelectionIndex()];
                defaultPCSamplePeriodIndex = BarmanDWTConfigPage.this.combo.getSelectionIndex();
                BarmanDWTConfigPage.this.setMessage("");
            }
        });
        this.setControl((Control)composite);
    }

    private static void addLabel(Composite composite, String text) {
        Label label = new Label(composite, 0);
        label.setText(text);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
    }

    private void setDefaults() {
        @Nullable DWTConfiguration config = this.defaults.getDWTConfiguration();
        if (config != null) {
            int periodInXML = config.getPCSamplingPeriod();
            int period = DWTUtils.convertToValidSamplingInterval(periodInXML);
            if (period != periodInXML) {
                this.setMessage(BarmanWizardMessages.BarmanDWTConfigPage_INTERVAL_TRUNCATED, 2);
            }
            String periodString = Integer.toString(period);
            int i = 0;
            while (i < this.combo.getItemCount()) {
                String s = this.combo.getItem(i);
                if (s.equals(periodString)) {
                    this.combo.select(i);
                    this.periodSelected = period;
                    return;
                }
                ++i;
            }
            assert (false);
        } else {
            this.combo.select(defaultPCSamplePeriodIndex);
            this.periodSelected = DWTUtils.VALID_PC_SAMPLING_INTERVALS[defaultPCSamplePeriodIndex];
        }
    }

    public IWizardPage getNextPage() {
        return this.nextPage;
    }

    public @NonNull DWTConfiguration getDWTConfiguration() {
        @NonNull DWTConfiguration config = new DWTConfiguration();
        config.setPCSamplingPeriod(this.periodSelected);
        return config;
    }
}

