/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.preprocessor;

import com.arm.utils.NullChecking;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CFileStripperPreprocessor {
    private static final Pattern[] STRIP_PATTERNS = new Pattern[]{Pattern.compile("^[ \\t]*#[ \\t]*ifndef[ \\t]*(INCLUDE_BARMAN[0-9A-Z_]*)([ \\t]+.*)?$"), Pattern.compile("^[ \\t]*#[ \\t]*define[ \\t]*(INCLUDE_BARMAN[0-9A-Z_]*)([ \\t]+.*)?$"), Pattern.compile("^[ \\t]*#[ \\t]*endif[ \\t]*/\\*[ \\t]*(INCLUDE_BARMAN[0-9A-Z_]*)([ \\t]+.*)?\\*/([ \\t]+.*)?$"), Pattern.compile("^/\\* Copyright \\(c\\) [0-9]{4} by Arm Limited. All rights reserved. \\*/$"), Pattern.compile("^/\\*\\*[ \\t]*@file([ \\t]+.+)?[ \\t]*\\*/$")};

    public static @NonNull String process(@NonNull InputStream inputStream) throws IOException {
        StringBuilder builder = new StringBuilder();
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            boolean lastLineWasEmpty = true;
            while ((line = reader.readLine()) != null) {
                if ((line = CFileStripperPreprocessor.stipLine(line)) == null || line.isEmpty()) {
                    if (!lastLineWasEmpty) {
                        builder.append('\n');
                    }
                    lastLineWasEmpty = true;
                    continue;
                }
                lastLineWasEmpty = false;
                builder.append(line).append('\n');
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return (String)NullChecking.neverNull((Object)builder.toString());
    }

    public static @NonNull String process(@NonNull String text) throws IOException {
        return CFileStripperPreprocessor.process(new ByteArrayInputStream(text.getBytes()));
    }

    private static @Nullable String stipLine(@NonNull String line) {
        Pattern[] patternArray = STRIP_PATTERNS;
        int n = STRIP_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(line);
            if (matcher.matches()) {
                return null;
            }
            ++n2;
        }
        return line;
    }
}

