/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.preprocessor;

import com.arm.streamline.barmancfg.preprocessor.AbstractCFileResource;
import com.arm.streamline.barmancfg.preprocessor.ICFileResourceLocator;
import com.arm.utils.NullChecking;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CFileMergerPreprocessor {
    private static final Pattern DEFINE_PATTERN = Pattern.compile("^[ \\t]*#[ \\t]*define[ \\t]*(\\w*)[ \\t]*(.*)$");
    private static final Pattern INCLUDE_PATTERN = Pattern.compile("^[ \\t]*#[ \\t]*include[ \\t]*((?:\"[^\"]+\")|(?:<[^>]+>))(.*)$");
    private final @NonNull Set<@NonNull AbstractCFileResource> alreadyIncludedResources;
    private final @NonNull Map<@NonNull String, String> definesToReplace;
    private final @NonNull AbstractCFileResource initialFile;
    private final @NonNull ICFileResourceLocator locator;
    private final @NonNull String processedSources;
    private final @NonNull Set<String> replacedDefines = new HashSet<String>();

    public CFileMergerPreprocessor(@NonNull AbstractCFileResource initialFile, @NonNull ICFileResourceLocator locator) throws IOException {
        this(initialFile, locator, Collections.emptySet(), Collections.emptyMap());
    }

    public CFileMergerPreprocessor(@NonNull AbstractCFileResource initialFile, @NonNull ICFileResourceLocator locator, @NonNull Set<@NonNull AbstractCFileResource> alreadyIncludedResources, @NonNull Map<@NonNull String, String> definesToReplace) throws IOException {
        this.initialFile = initialFile;
        this.locator = locator;
        this.alreadyIncludedResources = new HashSet<AbstractCFileResource>(alreadyIncludedResources);
        this.definesToReplace = new HashMap<String, String>(definesToReplace);
        StringBuilder builder = new StringBuilder();
        this.processFile(builder, initialFile);
        this.processedSources = (String)NullChecking.neverNull((Object)builder.toString());
        for (String define : definesToReplace.keySet()) {
            if (!this.replacedDefines.contains(define)) {
                throw new AssertionError((Object)("Define " + define + " not replaced"));
            }
        }
    }

    public @NonNull Set<@NonNull AbstractCFileResource> getAlreadyIncludedResources() {
        return Collections.unmodifiableSet(this.alreadyIncludedResources);
    }

    public @NonNull AbstractCFileResource getInitialFile() {
        return this.initialFile;
    }

    public @NonNull ICFileResourceLocator getLocator() {
        return this.locator;
    }

    public @NonNull String getProcessedSources() {
        return this.processedSources;
    }

    private @Nullable AbstractCFileResource examineIncludeLine(@NonNull String line) {
        Matcher match = INCLUDE_PATTERN.matcher(line);
        if (!match.matches()) {
            return null;
        }
        String name = (String)NullChecking.neverNull((Object)match.group(1));
        AbstractCFileResource result = this.locator.find((String)NullChecking.neverNull((Object)name.substring(1, name.length() - 1)));
        if (result == null) {
            throw new AssertionError((Object)("Missing file: " + name));
        }
        return result;
    }

    private void processFile(@NonNull StringBuilder builder, @NonNull AbstractCFileResource file) throws IOException {
        this.alreadyIncludedResources.add(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                AbstractCFileResource includedResource = this.examineIncludeLine(line);
                if (includedResource == null) {
                    builder.append(this.replaceDefineLine(line)).append('\n');
                    continue;
                }
                if (this.alreadyIncludedResources.contains(includedResource)) continue;
                this.processFile(builder, includedResource);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private @NonNull String replaceDefineLine(@NonNull String line) {
        Matcher match = DEFINE_PATTERN.matcher(line);
        if (!match.matches()) {
            return line;
        }
        String name = match.group(1);
        String replacement = this.definesToReplace.get(name);
        if (replacement == null) {
            return line;
        }
        if (!this.replacedDefines.add(name)) {
            throw new AssertionError((Object)("Duplicate define " + name + " found"));
        }
        return line.substring(0, match.start(2)) + replacement;
    }
}

