/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen.header;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.gen.header.IBarmanHeaderGenerator;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.streamline.common.xml.pmus.ProcessorPmuEventDescription;
import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;

public class ApiFunctionsGenerator
implements IBarmanHeaderGenerator {
    public static final String TOKEN = "API_FUNCTIONS_IMPL";
    private static final String HEADER = "bm_bool barman_generated_initialize(void)\n{\n    bm_bool initialize_success = BM_FALSE;\n\n";
    private static final String FOOTER = "    return initialize_success;\n}\n\n";

    @Override
    public @NonNull String generate(@NonNull String token, @NonNull BarmanConfiguration configuration) {
        StringBuilder result = new StringBuilder();
        result.append(HEADER);
        for (BarmanProcessorConfiguration processor : configuration.getProcessors()) {
            ProcessorPmu pmu = processor.getProcessorPmu();
            StringBuilder events = new StringBuilder();
            for (Integer event : processor.getEvents()) {
                if (ProcessorPmuEventDescription.CYCLE_COUNTER_KEY.equals(event)) continue;
                if (events.length() > 0) {
                    events.append(", ");
                }
                events.append(event);
            }
            result.append(String.format("    /* %s */\n", pmu.getCoreName())).append("    {\n").append("        const bm_uint32 pmu_event_types[").append(processor.getEvents().size()).append("] = {").append((CharSequence)events).append("};\n\n");
            int[] cpuids = pmu.getCpuids();
            if (cpuids.length > 0) {
                int[] nArray = cpuids;
                int n = cpuids.length;
                int n2 = 0;
                while (n2 < n) {
                    int cpuid = nArray[n2];
                    int midr = (cpuid & 0xFF000) << 12 | (cpuid & 0xFFF) << 4;
                    String midrHexString = String.format("0x%x", midr);
                    result.append("        if (barman_initialize_pmu_family(").append(midrHexString).append(", ").append(processor.getEvents().size()).append(", pmu_event_types, BM_NULL)) {\n").append("            initialize_success = BM_TRUE;\n").append("        }\n");
                    ++n2;
                }
            }
            result.append("    }\n\n");
        }
        result.append(FOOTER);
        return (String)NullChecking.neverNull((Object)result.toString());
    }
}

