/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.barmancfg.gen.BaseGenerator;
import com.arm.streamline.barmancfg.preprocessor.AbstractCFileResource;
import com.arm.streamline.barmancfg.preprocessor.CFileMergerPreprocessor;
import com.arm.streamline.barmancfg.preprocessor.CFileStripperPreprocessor;
import com.arm.streamline.barmancfg.preprocessor.ICFileResourceLocator;
import com.arm.streamline.barmancfg.preprocessor.StringCFileResource;
import com.arm.utils.NullChecking;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class SourceGenerator
extends BaseGenerator {
    private static final String C_FILE_BOILER_PLATE = "/* Copyright (C) 2018-2024 by Arm Limited. */\n/* SPDX-License-Identifier:\u00a0BSD-3-Clause */\n\n\n#include \"barman.h\"\n\n#if (!defined(BARMAN_DISABLED)) || (!BARMAN_DISABLED)\n%s\n#endif /* (!defined(BARMAN_DISABLED)) || (!BARMAN_DISABLED) */\n";
    private static final @NonNull String @NonNull [] GLOBAL_SOURCES = new String[]{"barman-internal.h", "barman-api.c", "barman-atomics.c", "barman-custom-counter-definitions.c", "barman-initialize.c", "barman-protocol.c", "barman-memutils.c", "multicore/barman-multicore-mpcore.c"};

    private static void appendIncludes(@NonNull StringBuilder builder, @NonNull String @NonNull [] sources) {
        String[] stringArray = sources;
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            String source = stringArray[n2];
            builder.append(String.format("#include \"%s\"\n", source));
            ++n2;
        }
    }

    private static @NonNull String genRawSource(@NonNull BarmanConfiguration configuration) {
        StringBuilder builder = new StringBuilder();
        SourceGenerator.appendIncludes(builder, GLOBAL_SOURCES);
        DataStorageBackend[] dataStorageBackendArray = DataStorageBackend.values();
        int n = dataStorageBackendArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataStorageBackend backend = dataStorageBackendArray[n2];
            backend.addRequiredSourceLines(builder);
            ++n2;
        }
        builder.append("#if BM_DATASTORE_USES_STREAMING_INTERFACE\n");
        builder.append("#include \"data-store/barman-streaming-interface.c\"\n");
        builder.append("#endif\n");
        builder.append("#if !BM_CONFIG_USER_SUPPLIED_PMU_DRIVER\n");
        builder.append("#if BM_ARM_64BIT_STATE\n");
        builder.append("#include \"aarch64/barman-cache.c\"\n");
        builder.append("#include \"aarch64/barman-external-dependencies.c\"\n");
        builder.append("#elif BM_ARM_32BIT_STATE\n");
        builder.append("#include \"arm/barman-cache.c\"\n");
        builder.append("#include \"arm/barman-external-dependencies.c\"\n");
        builder.append("#endif\n");
        if (configuration.getDWTConfiguration() == null) {
            builder.append("#include \"pmu/barman-arm-pmu.c\"\n");
        } else {
            builder.append("#include \"pmu/barman-arm-dwt.c\"\n");
        }
        builder.append("#endif\n");
        return (String)NullChecking.neverNull((Object)builder.toString());
    }

    private static @NonNull String stripPragmaSystemHeader(@NonNull String text) {
        return (String)NullChecking.neverNull((Object)text.replaceAll("^[ \\t]*#pragma[ \\t]+(GCC|clang)[ \\t]+system_header[ \\t]*.*$", ""));
    }

    public @NonNull String doProcessing(@NonNull BarmanConfiguration configuration, @NonNull ICFileResourceLocator locator, @NonNull Set<@NonNull AbstractCFileResource> alreadyIncludedHeaders) throws IOException {
        String rawSource = SourceGenerator.genRawSource(configuration);
        CFileMergerPreprocessor processorPass = new CFileMergerPreprocessor(new StringCFileResource("barman.c", rawSource), locator, alreadyIncludedHeaders, (Map)NullChecking.neverNull(Collections.emptyMap()));
        String source = CFileStripperPreprocessor.process(processorPass.getProcessedSources());
        StringReader reader = new StringReader(String.format(C_FILE_BOILER_PLATE, source));
        return this.tokenReplaceStream(configuration, reader);
    }

    @Override
    protected @NonNull String preProcessLine(@NonNull String line) {
        return SourceGenerator.stripPragmaSystemHeader(line);
    }
}

