/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.gen;

import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.gen.header.ApiFunctionsGenerator;
import com.arm.streamline.barmancfg.gen.header.CustomCountersConstantsGenerator;
import com.arm.streamline.barmancfg.gen.header.IBarmanHeaderGenerator;
import com.arm.streamline.barmancfg.gen.header.PmuConstantsGenerator;
import com.arm.streamline.barmancfg.gen.header.PmuEventConstantsGenerator;
import com.arm.utils.NullChecking;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;

public abstract class BaseGenerator {
    private static final Map<String, IBarmanHeaderGenerator> GENERATORS = new HashMap<String, IBarmanHeaderGenerator>(){
        {
            this.put("PMU_CONSTANTS", new PmuConstantsGenerator());
            this.put("PMU_EVENT_CONSTANTS", new PmuEventConstantsGenerator());
            this.put("CUSTOM_COUNTERS_CONSTANTS_HEADER", new CustomCountersConstantsGenerator());
            this.put("CUSTOM_COUNTERS_CONSTANTS", new CustomCountersConstantsGenerator());
            this.put("CUSTOM_COUNTERS_DEFINITIONS", new CustomCountersConstantsGenerator());
            this.put("API_FUNCTIONS_IMPL", new ApiFunctionsGenerator());
        }
    };
    private static final Pattern TOKEN_PATTERN = Pattern.compile("/\\*#([0-9A-Za-z_]+)\\*/");

    private static @NonNull String callGenerator(@NonNull String token, @NonNull BarmanConfiguration configuration) {
        IBarmanHeaderGenerator generator = GENERATORS.get(token);
        if (generator == null) {
            throw new AssertionError((Object)("Invalid token: '" + token + "'"));
        }
        return generator.generate(token, configuration);
    }

    protected @NonNull String postProcessLine(@NonNull String line) {
        return line;
    }

    protected @NonNull String preProcessLine(@NonNull String line) {
        return line;
    }

    protected @NonNull String tokenReplaceStream(@NonNull BarmanConfiguration configuration, @NonNull BufferedReader reader) throws IOException {
        String line;
        StringBuilder resultBuilder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = this.preProcessLine((String)NullChecking.neverNull((Object)line));
            StringBuilder lineBuilder = new StringBuilder();
            Matcher matcher = TOKEN_PATTERN.matcher(line);
            int appendFrom = 0;
            while (matcher.find()) {
                int appendTo = matcher.start();
                if (appendFrom < appendTo) {
                    lineBuilder.append(line.substring(appendFrom, appendTo));
                }
                appendFrom = matcher.end();
                lineBuilder.append(BaseGenerator.callGenerator((String)NullChecking.neverNull((Object)matcher.group(1)), configuration));
            }
            lineBuilder.append(line.substring(appendFrom)).append("\n");
            resultBuilder.append(this.postProcessLine((String)NullChecking.neverNull((Object)lineBuilder.toString())));
        }
        return (String)NullChecking.neverNull((Object)resultBuilder.toString());
    }

    protected @NonNull String tokenReplaceStream(@NonNull BarmanConfiguration configuration, @NonNull InputStream inputStream) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            return this.tokenReplaceStream(configuration, reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected @NonNull String tokenReplaceStream(@NonNull BarmanConfiguration configuration, @NonNull Reader source) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader reader = new BufferedReader(source);){
            return this.tokenReplaceStream(configuration, reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

