/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.configuration;

public class DefaultConfigSettings {
    public static final boolean DEFAULT_ENABLE_DEBUG_LOGGING = false;
    public static final boolean DEFAULT_ENABLE_LOGGING = false;
    public static final int DEFAULT_MAX_MMAP_LAYOUT_ENTRIES = 0;
    public static final int DEFAULT_MAX_PROCESSORS = 1;
    public static final int DEFAULT_MAX_TASK_ENTRIES = 0;
    public static final long DEFAULT_MIN_SAMPLE_PERIOD = 0L;
    public static final boolean DEFAULT_USE_BUILTIN_MEMFUNCS = true;
    private final boolean enableBuiltinMemFuncs;
    private final boolean enableDebugLogging;
    private final boolean enableLogging;
    private final int maxCores;
    private final int maxMmapLayoutEntries;
    private final int maxTaskEntries;
    private final long minimumSamplePeriod;

    public DefaultConfigSettings() {
        this(false, false, true, 1, 0, 0, 0L);
    }

    public DefaultConfigSettings(boolean enableLogging, boolean enableDebugLogging, boolean enableBuiltinMemFuncs, int maxCores, int maxTaskEntries, int maxMmapLayoutEntries, long minimumSamplePeriod) {
        this.enableLogging = enableLogging;
        this.enableDebugLogging = enableLogging && enableDebugLogging;
        this.enableBuiltinMemFuncs = enableBuiltinMemFuncs;
        this.maxCores = maxCores;
        this.maxTaskEntries = maxTaskEntries;
        this.maxMmapLayoutEntries = maxMmapLayoutEntries;
        this.minimumSamplePeriod = minimumSamplePeriod;
    }

    public int getMaxCores() {
        return this.maxCores;
    }

    public int getMaxMmapLayoutEntries() {
        return this.maxMmapLayoutEntries;
    }

    public int getMaxTaskEntries() {
        return this.maxTaskEntries;
    }

    public long getMinimumSamplePeriod() {
        return this.minimumSamplePeriod;
    }

    public boolean isEnableBuiltinMemFuncs() {
        return this.enableBuiltinMemFuncs;
    }

    public boolean isEnableDebugLogging() {
        return this.enableDebugLogging;
    }

    public boolean isEnableLogging() {
        return this.enableLogging;
    }
}

