/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barmancfg.configuration;

import com.arm.streamline.barmancfg.configuration.CustomChartSeries;
import com.arm.streamline.common.model.counters.GraphRenderingType;
import com.arm.streamline.common.model.counters.SeriesComposition;
import com.arm.utils.NullChecking;
import com.arm.utils.text.BasicStringUtils;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class CustomChart {
    public static final boolean DEFAULT_AVERAGE_CORES = false;
    public static final boolean DEFAULT_AVERAGE_SELECTION = false;
    public static final boolean DEFAULT_PER_CORE = false;
    public static final boolean DEFAULT_PERCENTAGE = false;
    public static final @NonNull GraphRenderingType DEFAULT_RENDERING_TYPE = GraphRenderingType.DEFAULT;
    public static final @NonNull SeriesComposition DEFAULT_SERIES_COMPOSITION = SeriesComposition.DEFAULT;
    private final boolean averageCores;
    private final boolean averageSelection;
    private final @NonNull String name;
    private final boolean percentage;
    private final boolean perCpu;
    private final @NonNull GraphRenderingType renderingType;
    private final @NonNull List<@NonNull CustomChartSeries> series;
    private final @NonNull SeriesComposition seriesComposition;

    public CustomChart(@NonNull String name, @Nullable SeriesComposition seriesComposition, @Nullable GraphRenderingType renderingType, @Nullable Boolean averageSelection, @Nullable Boolean averageCores, @Nullable Boolean percentage, @Nullable Boolean perCpu, @NonNull List<@NonNull CustomChartSeries> series) {
        this.name = name;
        this.seriesComposition = seriesComposition != null ? seriesComposition : DEFAULT_SERIES_COMPOSITION;
        this.renderingType = renderingType != null ? renderingType : DEFAULT_RENDERING_TYPE;
        this.averageSelection = averageSelection != null ? averageSelection : false;
        this.averageCores = averageCores != null ? averageCores : false;
        this.percentage = percentage != null ? percentage : false;
        this.perCpu = perCpu != null ? perCpu : false;
        this.series = series;
    }

    public CustomChart(@NonNull String name, @NonNull SeriesComposition seriesComposition, @NonNull GraphRenderingType renderingType, boolean averageSelection, boolean averageCores, boolean percentage, boolean perCpu) {
        this.name = name;
        this.seriesComposition = seriesComposition;
        this.renderingType = renderingType;
        this.averageSelection = averageSelection;
        this.averageCores = averageCores;
        this.percentage = percentage;
        this.perCpu = perCpu;
        this.series = (List)NullChecking.neverNull(Collections.emptyList());
    }

    public @NonNull String getKeyName() {
        return (String)NullChecking.neverNull((Object)BasicStringUtils.makeIdentifier((String)this.name).toLowerCase());
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull GraphRenderingType getRenderingType() {
        return this.renderingType;
    }

    public @NonNull List<@NonNull CustomChartSeries> getSeries() {
        return (List)NullChecking.neverNull(Collections.unmodifiableList(this.series));
    }

    public @NonNull SeriesComposition getSeriesComposition() {
        return this.seriesComposition;
    }

    public boolean isAverageCores() {
        return this.averageCores;
    }

    public boolean isAverageSelection() {
        return this.averageSelection;
    }

    public boolean isPercentage() {
        return this.percentage;
    }

    public boolean isPerCpu() {
        return this.perCpu;
    }

    public String toString() {
        return String.format("CustomChart [name=%s, seriesComposition=%s, renderingType=%s, averageCores=%s, averageSelection=%s, percentage=%s, perCpu=%s]", this.name, this.seriesComposition, this.renderingType, this.averageCores, this.averageSelection, this.percentage, this.perCpu);
    }
}

