/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.v1;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.recordstream.BarmanDataStoreParameters;
import com.arm.streamline.barman.v1.BarmanHeaderDataV1;
import com.arm.streamline.barmancfg.configuration.BarmanConfiguration;
import com.arm.streamline.barmancfg.configuration.BarmanProcessorConfiguration;
import com.arm.streamline.barmancfg.configuration.DataStorageBackend;
import com.arm.streamline.common.utility.MIDRUtilities;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class BarmanHeaderDataFactoryV1 {
    public static @Nullable BarmanHeaderDataV1 fromConfig(@NonNull BarmanConfiguration config) {
        @Nullable BarmanHeaderDataV1.ClockInfo clockInfo = config.getClockInfo();
        if (config.getProcessors().size() != 1) {
            return null;
        }
        @NonNull BarmanProcessorConfiguration processorConfig = config.getProcessors().get(0);
        @NonNull BarmanHeaderDataV1.PmuSettings @NonNull [] perCorePmuSettings = (BarmanHeaderDataV1.PmuSettings[])Arrays.stream(processorConfig.getProcessorPmu().getCpuids()).map(MIDRUtilities::makeMidrFromGatorCpuid).mapToObj(midr -> new BarmanHeaderDataV1.PmuSettings(0, 0, midr, 0L, new int[0], 0, 0L)).toArray(BarmanHeaderDataV1.PmuSettings[]::new);
        @NonNull BarmanDataStoreParameters dataStoreParameters = new BarmanDataStoreParameters();
        long lastTimestamp = 0L;
        @NonNull BarmanHeaderDataV1.MmapLayout @NonNull [] mmapLayout = new BarmanHeaderDataV1.MmapLayout[]{};
        @NonNull BarmanHeaderDataV1.TaskInfo @NonNull [] taskInfo = new BarmanHeaderDataV1.TaskInfo[]{};
        boolean timerSampleRate = false;
        @NonNull BarmanTypeAndVersion typeAndVersion = new BarmanTypeAndVersion(false, false, 3, 0);
        @NonNull BarmanHeaderDataV1.DataStoreType dataStoreType = switch (config.getDataStorageBackend()) {
            case DataStorageBackend.CIRCULAR_RAM_BUFFER -> BarmanHeaderDataV1.DataStoreType.CIRCULAR;
            case DataStorageBackend.ITM_INTERFACE -> BarmanHeaderDataV1.DataStoreType.ITM;
            case DataStorageBackend.LINEAR_RAM_BUFFER -> BarmanHeaderDataV1.DataStoreType.LINEAR;
            case DataStorageBackend.STM_INTERFACE -> BarmanHeaderDataV1.DataStoreType.STM;
            default -> throw new AssertionError((Object)"Unknown data store type");
        };
        @Nullable String targetName = config.getTargetName();
        if (targetName == null || clockInfo == null) {
            return null;
        }
        return new BarmanHeaderDataV1(clockInfo, dataStoreParameters, dataStoreType, 0L, mmapLayout, perCorePmuSettings, targetName, taskInfo, 0, typeAndVersion);
    }
}

