/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.itm;

import com.arm.coresight.itm.IITMPacketReceiver;
import com.arm.streamline.barman.itm.ITimestampedPacketReceiver;
import com.arm.streamline.barman.itm.packets.DataTraceDataAddressPacket;
import com.arm.streamline.barman.itm.packets.DataTraceDataValuePacket;
import com.arm.streamline.barman.itm.packets.DataTraceMatchPacket;
import com.arm.streamline.barman.itm.packets.DataTracePcValuePacket;
import com.arm.streamline.barman.itm.packets.EventCounterPacket;
import com.arm.streamline.barman.itm.packets.ExceptionTracePacket;
import com.arm.streamline.barman.itm.packets.ISourcePacket;
import com.arm.streamline.barman.itm.packets.InstrumentationPacket;
import com.arm.streamline.barman.itm.packets.OtherHardwareSourcePacket;
import com.arm.streamline.barman.itm.packets.PeriodicPcSamplePacket;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class LocalTimestampedPacketEmitter
implements IITMPacketReceiver {
    private long currentTimestamp = 0L;
    private final @NonNull ITimestampedPacketReceiver receiver;
    private final @NonNull List<ISourcePacket> packets = new ArrayList<ISourcePacket>();

    public LocalTimestampedPacketEmitter(@NonNull ITimestampedPacketReceiver receiver) {
        this.receiver = receiver;
    }

    public void onSourcePacket(@NonNull ISourcePacket packet) {
        this.packets.add(packet);
    }

    public void onOverflowPacket() {
        if (this.packets.isEmpty()) {
            this.receiver.onTimeLost(this.currentTimestamp);
        } else {
            this.packets.clear();
            this.receiver.onPacketsLost(this.currentTimestamp);
        }
    }

    public void onLocalTimestampPacket(long timestamp) {
        this.currentTimestamp += timestamp;
        for (ISourcePacket packet : this.packets) {
            packet.callReceiver(this.receiver, this.currentTimestamp);
        }
        this.packets.clear();
    }

    public void onGlobalTimestampPacket(long timestamp, IITMPacketReceiver.GlobalTimestampValueHint hint, long updateBitMask) {
    }

    public void onInstrumentationPacket(byte portNumber, byte @NonNull [] data) {
        this.onSourcePacket(new InstrumentationPacket(portNumber, data));
    }

    public void onEventCounterPacket(BitSet eventFlags) {
        this.onSourcePacket(new EventCounterPacket(eventFlags));
    }

    public void onExceptionTracePacket(int exceptionNumber, IITMPacketReceiver.ExceptionFunction exceptionFunction) {
        this.onSourcePacket(new ExceptionTracePacket(exceptionNumber, exceptionFunction));
    }

    public void onExtensionPacket(long extensionInformation) {
    }

    public void onDataTraceMatchPacket(int comparatorIndex) {
        this.onSourcePacket(new DataTraceMatchPacket(comparatorIndex));
    }

    public void onDataTracePCValuePacket(int comparatorIndex, long pcValue) {
        this.onSourcePacket(new DataTracePcValuePacket(comparatorIndex, (int)pcValue));
    }

    public void onDataTraceDataValuePacket(int comparatorIndex, long dataValue, IITMPacketReceiver.DataOperation operation) {
        this.onSourcePacket(new DataTraceDataValuePacket(comparatorIndex, operation, (int)dataValue));
    }

    public void onDataTraceDataAddressPacket(int comparatorIndex, long dataAddress) {
        this.onSourcePacket(new DataTraceDataAddressPacket(comparatorIndex, (int)dataAddress));
    }

    public void onPeriodicPCSamplePacket(long pcSample) {
        this.onSourcePacket(new PeriodicPcSamplePacket((int)pcSample));
    }

    public void onPeriodicPCSamplePacketSleeping() {
        this.onSourcePacket(new PeriodicPcSamplePacket(PeriodicPcSamplePacket.NotSampledReason.Sleeping));
    }

    public void onPeriodicPCSamplePacketProhibited() {
        this.onSourcePacket(new PeriodicPcSamplePacket(PeriodicPcSamplePacket.NotSampledReason.Prohibited));
    }

    public void onHardwarePacket(byte typeDescrimiator, byte @NonNull [] data) {
        this.onSourcePacket(new OtherHardwareSourcePacket(typeDescrimiator, data));
    }
}

