/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.itm;

import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.frames.objects.EventCounterWithoutTaskId;
import com.arm.streamline.barman.frames.objects.HaltEventFrame;
import com.arm.streamline.barman.frames.objects.PcWithoutTaskId;
import com.arm.streamline.barman.frames.objects.TimestampedSimpleFrame;
import com.arm.streamline.barman.frames.objects.WarningFrame;
import com.arm.streamline.barman.itm.IITMFrameHandler;
import com.arm.streamline.barman.v1.BarmanWarningType;
import java.util.function.Consumer;
import org.eclipse.jdt.annotation.NonNull;

public final class ITMFrameHandler
implements IITMFrameHandler {
    private final @NonNull Consumer<@NonNull IBarmanSerializableFrame> frameConsumer;

    public ITMFrameHandler(@NonNull Consumer<@NonNull IBarmanSerializableFrame> frameConsumer) {
        this.frameConsumer = frameConsumer;
    }

    @Override
    public void onTimestampedRecordFrame(long timestamp, byte @NonNull [] bytes) {
        this.frameConsumer.accept(new TimestampedSimpleFrame(timestamp, bytes));
    }

    @Override
    public void onEventCounterOverflow(long timestamp, int coreNumber, int eventNo, int amount) {
        this.frameConsumer.accept(new EventCounterWithoutTaskId(timestamp, coreNumber, eventNo, amount));
    }

    @Override
    public void onPCSample(long timestamp, int coreNumber, long address) {
        this.frameConsumer.accept(new PcWithoutTaskId(timestamp, coreNumber, address));
    }

    @Override
    public void onHalt(long timestamp, int coreNumber, boolean halted) {
        this.frameConsumer.accept(new HaltEventFrame(timestamp, coreNumber, halted));
    }

    @Override
    public void onDataLost(long timestamp, int coreNumber) {
        this.frameConsumer.accept(new WarningFrame(timestamp, coreNumber, BarmanWarningType.DATA_LOST));
    }

    @Override
    public void onTimeLost(long timestamp, int coreNumber) {
        this.frameConsumer.accept(new WarningFrame(timestamp, coreNumber, BarmanWarningType.TIME_OVERFLOW));
    }
}

