/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.itm;

import com.arm.coresight.itm.IITMPacketReceiver;
import com.arm.streamline.barman.itm.IITMFrameHandler;
import com.arm.streamline.barman.itm.ITimestampedPacketReceiver;
import com.arm.utils.NullChecking;
import com.arm.utils.collections.Container;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.BitSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class ITMFrameDataMerger
implements ITimestampedPacketReceiver {
    static final int CYCLE_COUNTER_INDEX = 5;
    static final int EVENT_COUNTER_OVERFLOW_AMOUNT = 256;
    private final @NonNull Container<@NonNull Byte> barmanAgentPortNumbers;
    private final @NonNull TIntObjectHashMap<@NonNull FrameData> barmanFrameData = new TIntObjectHashMap(1);
    private final int coreNumber;
    private final int cycleCounterOverflow;
    private final long @NonNull [] eventCounterTimestamps = new long[5];
    private final int @NonNull [] eventCounterValues = new int[5];
    private final @NonNull IITMFrameHandler frameHandler;
    private boolean haltEntered = false;

    public ITMFrameDataMerger(int coreNumber, int cycleCounterOverflow, @NonNull Container<@NonNull Byte> barmanAgentPortNumbers, @NonNull IITMFrameHandler frameHandler) {
        this.coreNumber = coreNumber;
        this.cycleCounterOverflow = cycleCounterOverflow;
        this.barmanAgentPortNumbers = barmanAgentPortNumbers;
        this.frameHandler = frameHandler;
    }

    public void addEnterHaltEventFrameIfNotHalted(long timestamp) {
        if (!this.haltEntered) {
            this.haltEntered = true;
            this.frameHandler.onHalt(timestamp, this.coreNumber, true);
        }
    }

    public void addLeaveHaltEventFrameIfHalted(long timestamp) {
        if (this.haltEntered) {
            this.haltEntered = false;
            this.frameHandler.onHalt(timestamp, this.coreNumber, false);
        }
    }

    public void flush() {
        int i = 0;
        while (i < 5) {
            if (this.eventCounterValues[i] != 0) {
                this.frameHandler.onEventCounterOverflow(this.eventCounterTimestamps[i], this.coreNumber, i, this.eventCounterValues[i]);
                this.eventCounterValues[i] = 0;
            }
            ++i;
        }
    }

    public @Nullable FrameData getBarmanPartialFrames(byte port) {
        return (FrameData)this.barmanFrameData.get((int)port);
    }

    @Override
    public void onDataTraceDataAddressPacket(long timestamp, int comparatorIndex, long dataAddress) {
    }

    @Override
    public void onDataTraceDataValuePacket(long timestamp, int comparatorIndex, long dataAddress, IITMPacketReceiver.DataOperation operation) {
    }

    @Override
    public void onDataTraceMatchPacket(long timestamp, int comparatorIndex) {
    }

    @Override
    public void onDataTracePCValuePacket(long timestamp, int comparatorIndex, long pcValue) {
    }

    @Override
    public void onEventCounterPacket(long timestamp, BitSet eventFlags) {
        int i = eventFlags.nextSetBit(0);
        while (i >= 0 & i < 5) {
            int n = i;
            this.eventCounterValues[n] = this.eventCounterValues[n] + 256;
            this.eventCounterTimestamps[i] = timestamp;
            i = eventFlags.nextSetBit(i + 1);
        }
        if (eventFlags.get(5)) {
            this.onCycleCounterOverflow(timestamp);
        }
    }

    @Override
    public void onExceptionTracePacket(long timestamp, int exceptionNumber, IITMPacketReceiver.ExceptionFunction exceptionFunction) {
    }

    @Override
    public void onHardwarePacket(long timestamp, byte typeDescrimiator, byte[] data) {
    }

    @Override
    public void onInstrumentationPacket(long timestamp, byte portNumber, byte[] data) {
        block8: {
            this.addLeaveHaltEventFrameIfHalted(timestamp);
            if (this.barmanAgentPortNumbers.contains((Object)((Byte)NullChecking.neverNull((Object)portNumber)))) {
                try {
                    if (data.length == 2) {
                        if (this.barmanFrameData.containsKey((int)portNumber)) {
                            @NonNull FrameData frame = (FrameData)this.barmanFrameData.get((int)portNumber);
                            byte @NonNull [] bytes = (byte[])NullChecking.neverNull((Object)frame.stream.toByteArray());
                            if (bytes.length > 0) {
                                this.frameHandler.onTimestampedRecordFrame(frame.timestamp, bytes);
                            }
                            this.barmanFrameData.remove((int)portNumber);
                        }
                        this.barmanFrameData.put((int)portNumber, (Object)new FrameData(timestamp, new byte[0]));
                        break block8;
                    }
                    if (data.length == 4 || data.length == 1) {
                        if (this.barmanFrameData.containsKey((int)portNumber)) {
                            @NonNull FrameData frame = (FrameData)this.barmanFrameData.get((int)portNumber);
                            frame.stream.write(data);
                        }
                        break block8;
                    }
                    throw new AssertionError((Object)"Illegal number of data bytes given - should be 2 or 4 or 1.");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void onPacketsLost(long timestamp) {
        this.barmanFrameData.clear();
        this.frameHandler.onDataLost(timestamp, this.coreNumber);
    }

    @Override
    public void onPeriodicPCSamplePacket(long timestamp, long pcSample) {
        this.addLeaveHaltEventFrameIfHalted(timestamp);
        this.frameHandler.onPCSample(timestamp, this.coreNumber, pcSample);
        this.onCycleCounterOverflow(timestamp);
    }

    @Override
    public void onPeriodicPCSamplePacketProhibited(long timestamp) {
        this.onCycleCounterOverflow(timestamp);
    }

    @Override
    public void onPeriodicPCSamplePacketSleeping(long timestamp) {
        this.onCycleCounterOverflow(timestamp);
        this.addEnterHaltEventFrameIfNotHalted(timestamp);
    }

    @Override
    public void onTimeLost(long timestamp) {
        this.frameHandler.onTimeLost(timestamp, this.coreNumber);
    }

    private void onCycleCounterOverflow(long timestamp) {
        this.frameHandler.onEventCounterOverflow(timestamp, this.coreNumber, 5, this.cycleCounterOverflow);
        this.flush();
    }

    public static class FrameData {
        public @NonNull ByteArrayOutputStream stream;
        public long timestamp;

        FrameData(long timestamp, byte[] data) throws IOException {
            this.timestamp = timestamp;
            this.stream = new ByteArrayOutputStream(data.length);
            this.stream.write(data);
        }
    }
}

