/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman.frames.objects;

import com.arm.streamline.barman.BarmanTypeAndVersion;
import com.arm.streamline.barman.frames.IBarmanSerializableFrame;
import com.arm.streamline.barman.v1.BarmanRecordType;
import com.arm.utils.NullChecking;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class HaltEventFrame
implements IBarmanSerializableFrame {
    private final int core;
    private final long timestamp;
    private final boolean enteredHalt;

    public HaltEventFrame(long timestamp, int core, boolean enteredHalt) {
        this.core = core;
        this.timestamp = timestamp;
        this.enteredHalt = enteredHalt;
    }

    @Override
    public byte @Nullable [] getRawFrameData() {
        return null;
    }

    @Override
    public @Nullable Long getTimestampOverride() {
        return null;
    }

    @Override
    public byte @NonNull [] serializeRecord(@NonNull BarmanTypeAndVersion typeAndVersion) {
        ByteOrder byteOrder = typeAndVersion.isBigEndian() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
        int length = 17;
        ByteBuffer buffer = ByteBuffer.allocate(17).order(byteOrder);
        buffer.putInt(BarmanRecordType.HALT_EVENT.getValue());
        buffer.putInt(this.core);
        buffer.putLong(this.timestamp);
        buffer.put(this.enteredHalt ? (byte)1 : 0);
        return (byte[])NullChecking.neverNull((Object)buffer.array());
    }

    public boolean isEnteredHalt() {
        return this.enteredHalt;
    }
}

