/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.streamline.barman.BarmanDataError;
import com.arm.streamline.barman.BarmanDataInput;
import com.arm.streamline.barman.BarmanSeekableDataInput;
import com.arm.streamline.barman.IBarmanHeader;
import com.arm.streamline.barman.v1.BarmanHeaderV1;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.common.xml.pmus.ProcessorPmu;
import com.arm.utils.datainput.LittleEndianDataInputStream;
import com.arm.utils.datainput.SeekableBigEndianDataInputStream;
import com.arm.utils.datainput.SeekableDataInput;
import com.arm.utils.datainput.SeekableInputStream;
import com.arm.utils.datainput.SeekableLittleEndianDataInputStream;
import com.arm.utils.datainput.StreamUtils;
import com.arm.utils.io.GrowableTargetByteBuffer;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class BarmanTypeAndVersion {
    private static final long BM_PROTOCOL_MAGIC_BYTES_32_BE = 3617320968085717314L;
    private static final long BM_PROTOCOL_MAGIC_BYTES_32_LE = 4774187571751039794L;
    private static final long BM_PROTOCOL_MAGIC_BYTES_64_BE = 3762280581091705154L;
    private static final long BM_PROTOCOL_MAGIC_BYTES_64_LE = 4774187571751040564L;
    private static final int MAGIC_BYTES_AND_VERSION_LENGTH = 12;
    private final boolean bigEndian;
    private final boolean bits64;
    private final int offset;
    private final int versionNo;

    public static @Nullable BarmanTypeAndVersion detectTypeAndVersion(byte @NonNull [] magicBytesAndVersion) {
        return BarmanTypeAndVersion.detectTypeAndVersion(magicBytesAndVersion, 0);
    }

    public static @Nullable BarmanTypeAndVersion detectTypeAndVersion(byte @NonNull [] magicBytesAndVersion, int offset) {
        assert (offset >= 0 && offset < 8);
        if (magicBytesAndVersion.length < 12) {
            return null;
        }
        ByteBuffer bb = ByteBuffer.wrap(magicBytesAndVersion);
        bb.order(ByteOrder.LITTLE_ENDIAN);
        long magicBytes = bb.getLong(0);
        int versionNoLE = bb.getInt(8);
        if (magicBytes == 4774187571751039794L) {
            if (!BarmanTypeAndVersion.isValidVersionNo(versionNoLE)) {
                return null;
            }
            return new BarmanTypeAndVersion(false, false, versionNoLE, offset);
        }
        if (magicBytes == 4774187571751040564L) {
            if (!BarmanTypeAndVersion.isValidVersionNo(versionNoLE)) {
                return null;
            }
            return new BarmanTypeAndVersion(false, true, versionNoLE, offset);
        }
        bb.order(ByteOrder.BIG_ENDIAN);
        int versionNoBE = bb.getInt(8);
        if (magicBytes == 3617320968085717314L) {
            if (!BarmanTypeAndVersion.isValidVersionNo(versionNoBE)) {
                return null;
            }
            return new BarmanTypeAndVersion(true, false, versionNoBE, offset);
        }
        if (magicBytes == 3762280581091705154L) {
            if (!BarmanTypeAndVersion.isValidVersionNo(versionNoBE)) {
                return null;
            }
            return new BarmanTypeAndVersion(true, true, versionNoBE, offset);
        }
        return null;
    }

    public static @Nullable BarmanTypeAndVersion detectTypeAndVersion(@NonNull InputStream inputStream) throws IOException {
        byte[] header = new byte[12];
        StreamUtils.readFully((InputStream)inputStream, (byte[])header);
        int i = 0;
        while (i < 8) {
            BarmanTypeAndVersion typeAndVersion = BarmanTypeAndVersion.detectTypeAndVersion(header, i);
            if (typeAndVersion != null) {
                return typeAndVersion;
            }
            System.arraycopy(header, 1, header, 0, 11);
            int nextByte = inputStream.read();
            if (nextByte == -1) {
                return null;
            }
            header[11] = (byte)nextByte;
            ++i;
        }
        return null;
    }

    private static boolean isValidVersionNo(int versionNo) {
        return versionNo >= 1 && versionNo <= 3;
    }

    public BarmanTypeAndVersion(boolean bigEndian, boolean bits64, int versionNo, int offset) {
        this.bigEndian = bigEndian;
        this.bits64 = bits64;
        this.versionNo = versionNo;
        this.offset = offset;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BarmanTypeAndVersion other = (BarmanTypeAndVersion)obj;
        return this.bigEndian == other.bigEndian && this.bits64 == other.bits64 && this.versionNo == other.versionNo && this.offset == other.offset;
    }

    public @NonNull ByteOrder getByteOrder() {
        return this.bigEndian ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    public int getDataOffset() {
        return this.offset + 12;
    }

    public @NonNull IBarmanHeader getHeader(@NonNull Map<@NonNull Integer, @NonNull ProcessorPmu> pmus, @NonNull Events events, @NonNull InputStream inputStream) throws IOException, BarmanDataError {
        switch (this.versionNo) {
            case 1: 
            case 2: 
            case 3: {
                return new BarmanHeaderV1(pmus, events, this, this.wrapStream(inputStream));
            }
        }
        throw new AssertionError();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public int hashCode() {
        return Objects.hash(this.bigEndian, this.bits64, this.offset, this.versionNo);
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    public boolean isBits64() {
        return this.bits64;
    }

    public GrowableTargetByteBuffer toTargetByteBuffer() {
        GrowableTargetByteBuffer buffer = new GrowableTargetByteBuffer(this.bigEndian, this.bits64);
        buffer.put64(this.bits64 ? 4774187571751040564L : 4774187571751039794L);
        buffer.put32(this.versionNo);
        return buffer;
    }

    public @NonNull BarmanSeekableDataInput wrapStream(@NonNull FileInputStream inputStream) throws IOException {
        return this.wrapStream(new SeekableInputStream(inputStream));
    }

    public @NonNull BarmanDataInput<?> wrapStream(@NonNull InputStream inputStream) throws IOException {
        if (inputStream instanceof FileInputStream) {
            return this.wrapStream((FileInputStream)inputStream);
        }
        if (inputStream instanceof SeekableInputStream) {
            return this.wrapStream((SeekableInputStream)inputStream);
        }
        if (this.bigEndian) {
            return new BarmanDataInput<DataInputStream>(new DataInputStream(inputStream), ByteOrder.BIG_ENDIAN, this.bits64, 12L);
        }
        return new BarmanDataInput<LittleEndianDataInputStream>(new LittleEndianDataInputStream(inputStream), ByteOrder.LITTLE_ENDIAN, this.bits64, 12L);
    }

    public @NonNull BarmanSeekableDataInput wrapStream(@NonNull SeekableInputStream inputStream) throws IOException {
        if (this.bigEndian) {
            return new BarmanSeekableDataInput(this, (SeekableDataInput)new SeekableBigEndianDataInputStream(inputStream), 12L);
        }
        return new BarmanSeekableDataInput(this, (SeekableDataInput)new SeekableLittleEndianDataInputStream(inputStream), 12L);
    }
}

