/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.barman;

import com.arm.utils.datainput.ICloseableDataInput;
import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.NonNull;

public class BarmanDataInput<T extends Closeable & DataInput>
implements ICloseableDataInput {
    protected final boolean bits64;
    protected final @NonNull ByteOrder byteOrder;
    protected final @NonNull T dataInput;
    protected long offset;

    public BarmanDataInput(@NonNull T dataInput, @NonNull ByteOrder byteOrder, boolean bits64, long offset) {
        this.dataInput = dataInput;
        this.byteOrder = byteOrder;
        this.bits64 = bits64;
        this.offset = offset;
    }

    public int alignTo(int alignment) throws IOException {
        if (alignment < 1) {
            throw new IllegalArgumentException("invalid alignment");
        }
        int n = (int)(this.getOffset() % (long)alignment);
        if (n > 0) {
            int skip = alignment - n;
            if (this.skipBytes(skip) != skip) {
                throw new IOException("failed to align");
            }
            return skip;
        }
        if (n < 0) {
            throw new AssertionError(n);
        }
        return 0;
    }

    public void close() throws IOException {
        this.dataInput.close();
    }

    public int getMachineWordLength() {
        return this.bits64 ? 8 : 4;
    }

    public long getOffset() throws IOException {
        return this.offset;
    }

    public boolean readBoolean() throws IOException {
        try {
            boolean bl = ((DataInput)this.dataInput).readBoolean();
            return bl;
        }
        finally {
            ++this.offset;
        }
    }

    public byte readByte() throws IOException {
        try {
            byte by = ((DataInput)this.dataInput).readByte();
            return by;
        }
        finally {
            ++this.offset;
        }
    }

    public char readChar() throws IOException {
        try {
            char c = ((DataInput)this.dataInput).readChar();
            return c;
        }
        finally {
            this.offset += 2L;
        }
    }

    public double readDouble() throws IOException {
        try {
            double d = ((DataInput)this.dataInput).readDouble();
            return d;
        }
        finally {
            this.offset += 8L;
        }
    }

    public float readFloat() throws IOException {
        try {
            float f = ((DataInput)this.dataInput).readFloat();
            return f;
        }
        finally {
            this.offset += 4L;
        }
    }

    public void readFully(byte[] b) throws IOException {
        try {
            ((DataInput)this.dataInput).readFully(b);
        }
        finally {
            this.offset += (long)b.length;
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            ((DataInput)this.dataInput).readFully(b, off, len);
        }
        finally {
            this.offset += (long)len;
        }
    }

    public int readInt() throws IOException {
        try {
            int n = ((DataInput)this.dataInput).readInt();
            return n;
        }
        finally {
            this.offset += 4L;
        }
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public long readLong() throws IOException {
        try {
            long l = ((DataInput)this.dataInput).readLong();
            return l;
        }
        finally {
            this.offset += 8L;
        }
    }

    public long readMachineWord() throws IOException {
        return this.bits64 ? this.readLong() : (long)this.readInt() & 0xFFFFFFFFL;
    }

    public short readShort() throws IOException {
        try {
            short s = ((DataInput)this.dataInput).readShort();
            return s;
        }
        finally {
            this.offset += 2L;
        }
    }

    public int readUnsignedByte() throws IOException {
        try {
            int n = ((DataInput)this.dataInput).readUnsignedByte();
            return n;
        }
        finally {
            ++this.offset;
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            int n = ((DataInput)this.dataInput).readUnsignedShort();
            return n;
        }
        finally {
            this.offset += 2L;
        }
    }

    public String readUTF() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int skipBytes(int n) throws IOException {
        int r = ((DataInput)this.dataInput).skipBytes(n);
        this.offset += (long)r;
        return r;
    }

    public @NonNull ByteBuffer readBytes(int length) throws IOException {
        byte[] bytes = new byte[length];
        this.readFully(bytes);
        ByteBuffer result = ByteBuffer.wrap(bytes);
        result.order(this.byteOrder);
        return result;
    }
}

