/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.authentication;

import com.arm.streamline.authentication.AuthenticationMessages;
import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class TargetAuthenticationConfig {
    private String mDialogTitle;
    private String mDialogMessage;
    private String mDialogOKButtonTitle;
    private String mDialogHelpId;
    private @Nullable File mPathToAdb;
    private boolean mShowRootPasswordField;
    private boolean mShowTargetSetupPath;

    public static final @NonNull TargetAuthenticationConfig createForImageExtraction(@Nullable File pathToAdb) {
        TargetAuthenticationConfig state = new TargetAuthenticationConfig();
        state.setDialogTitle(AuthenticationMessages.IMAGE_EXTRACTION_TITLE);
        state.setDialogMessage(AuthenticationMessages.IMAGE_EXTRACTION_MESSAGE);
        state.setDialogOKButtonTitle(AuthenticationMessages.IMAGE_EXTRACTION_OK);
        state.setDialogHelpId("com.arm.streamline.image_extraction_dialog");
        state.setPathToAdb(pathToAdb);
        state.setShowRootPasswordField(false);
        state.setShowTargetSetupPath(false);
        return state;
    }

    public static final @NonNull TargetAuthenticationConfig createForTargetSetup(@Nullable File pathToAdb) {
        TargetAuthenticationConfig state = new TargetAuthenticationConfig();
        state.setDialogTitle(AuthenticationMessages.TARGET_INSTALL_TITLE);
        state.setDialogMessage(AuthenticationMessages.TARGET_INSTALL_MESSAGE);
        state.setDialogOKButtonTitle(AuthenticationMessages.TARGET_INSTALL_OK);
        state.setDialogHelpId("com.arm.streamline.target_install_dialog");
        state.setPathToAdb(pathToAdb);
        state.setShowRootPasswordField(true);
        state.setShowTargetSetupPath(true);
        return state;
    }

    public final String getDialogHelpId() {
        return this.mDialogHelpId;
    }

    public final String getDialogMessage() {
        return this.mDialogMessage;
    }

    public final String getDialogOKButtonTitle() {
        return this.mDialogOKButtonTitle;
    }

    public final String getDialogTitle() {
        return this.mDialogTitle;
    }

    public final @Nullable File getPathToAdb() {
        return this.mPathToAdb;
    }

    public final void setDialogHelpId(String helpId) {
        this.mDialogHelpId = helpId;
    }

    public final void setDialogMessage(String message) {
        this.mDialogMessage = message;
    }

    public final void setDialogOKButtonTitle(String title) {
        this.mDialogOKButtonTitle = title;
    }

    public final void setDialogTitle(String title) {
        this.mDialogTitle = title;
    }

    public final void setPathToAdb(@Nullable File pathToAdb) {
        this.mPathToAdb = pathToAdb;
    }

    public final void setShowRootPasswordField(boolean show) {
        this.mShowRootPasswordField = show;
    }

    public final void setShowTargetSetupPath(boolean show) {
        this.mShowTargetSetupPath = show;
    }

    public final boolean showRootPasswordField() {
        return this.mShowRootPasswordField;
    }

    public final boolean showTargetSetupPath() {
        return this.mShowTargetSetupPath;
    }
}

