/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.authentication;

import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.authentication.TargetAuthenticationConfig;
import com.arm.streamline.authentication.TargetAuthenticationDialog;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.databrowser.TargetAddressString;
import com.arm.streamline.deviceconn.ssh.OpenSSHConfigParser;
import com.arm.streamline.ui.part.lpv.SshTargetLauncher;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

@SuppressFBWarnings(value={"HARD_CODE_KEY"})
public final class TargetAuthentication
implements Cloneable {
    private static final String ATTR_ADDRESS = "address";
    private static final String ATTR_PASSWORD = "pass";
    private static final String ATTR_ROOT_PASSWORD = "root";
    private static final String ATTR_SSH_ADDRESS = "address";
    private static final String ATTR_SSH_GATOR_PATH = "gator_path";
    private static final String ATTR_SSH_GATOR_PORT = "gator_port";
    private static final String ATTR_SSH_PASS_KEY = "key_file";
    private static final String ATTR_SSH_PASSWORD = "pass";
    private static final String ATTR_SSH_PORT = "port";
    private static final String ATTR_SSH_SESSION_NAME = "session_name";
    private static final String ATTR_SSH_USERNAME = "user";
    private static final String ATTR_USERNAME = "user";
    private static final @NonNull Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> CACHE = new HashMap<CredentialsAddress, TargetAuthentication>();
    private static final byte[] KEY = new byte[]{34, 115, 1, 52, 85, 8, 119, 35};
    private static final @NonNull Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> SSH_CACHE = new HashMap<CredentialsAddress, TargetAuthentication>();
    private static final String TAG_AUTHENTICATION = "authentication";
    private static final String TAG_AUTHENTICATIONS = "authentications";
    private static final String TAG_CREDENTRIALS = "credentials";
    private static final String TAG_SSH_AUTHENTICATION = "ssh_authentication";
    private static final String TAG_SSH_AUTHENTICATIONS = "ssh_authentications";
    private final @Nullable TargetAddressString address;
    private final boolean fromDefaults;
    private final @Nullable String gatorPath;
    private final @Nullable List<@NonNull File> keyFiles;
    private final @Nullable String password;
    private final @Nullable String rootPassword;
    private final @Nullable Integer sshPort;
    private final // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable OpenSSHConfigParser.SSHTargetConfig sshTargetConfig;
    private final @Nullable String username;

    public static void cache(@Nullable TargetAuthentication cache) {
        if (cache == null) {
            return;
        }
        CredentialsAddress ca = cache.getCredentialsAddress();
        if (ca == null) {
            return;
        }
        if (cache.sshTargetConfig != null) {
            SSH_CACHE.put(ca, cache);
        } else {
            CACHE.put(ca, cache);
        }
    }

    public static @NonNull TargetAuthentication fromAndroidSerialNo(@NonNull String serialNo) {
        return new TargetAuthentication(null, new TargetAddressString(String.format("adb:%s", serialNo)), null, null, null, null, null, null, false);
    }

    public static @NonNull TargetAuthentication fromSSHTargetConfig(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull OpenSSHConfigParser.SSHTargetConfig targetConfig) {
        return new TargetAuthentication(targetConfig, new TargetAddressString(String.format("tcp:%s", targetConfig.hostname())), null, null, null, targetConfig.port(), null, null, false);
    }

    public static @NonNull TargetAuthentication fromSSHTargetLauncher(@NonNull ISshTargetLauncher ssh) {
        OpenSSHConfigParser.SSHTargetConfig targetConfig = ssh.getSSHTargetConfig();
        return new TargetAuthentication(targetConfig, new TargetAddressString(String.format("tcp:%s:%d", targetConfig.hostname(), ssh.getGatorPortNumeric())), null, null, null, targetConfig.port(), null, ssh.getGatorPath(), ssh.isFromDefaults());
    }

    public static @NonNull SshTargetLauncher @NonNull [] getCachedTargets() {
        return (SshTargetLauncher[])SSH_CACHE.values().stream().map(targetAuth -> {
            OpenSSHConfigParser.SSHTargetConfig tc = targetAuth.sshTargetConfig;
            if (tc == null) {
                return null;
            }
            return new SshTargetLauncher(tc, "", "", "", targetAuth.getGatorPort(), targetAuth.getGatorPath(), false, targetAuth.fromDefaults);
        }).collect(Collectors.toList()).toArray(SshTargetLauncher[]::new);
    }

    public static @Nullable TargetAuthentication getFromCache(@NonNull CredentialsAddress address) {
        return CACHE.get(address);
    }

    public static @Nullable TargetAuthentication getFromCacheOrCreate(@NonNull CredentialsAddress address, TargetAuthenticationConfig config, boolean allowTargetChange) {
        TargetAuthentication result = CACHE.get(address);
        return result == null ? TargetAuthentication.prompt(address, config, allowTargetChange) : result;
    }

    public static @Nullable TargetAuthentication getFromSSHCache(@NonNull CredentialsAddress address) {
        return SSH_CACHE.get(address);
    }

    public static boolean isCached(@NonNull CredentialsAddress address) {
        return CACHE.containsKey(address);
    }

    public static boolean isSSHCached(@NonNull CredentialsAddress address) {
        return SSH_CACHE.containsKey(address);
    }

    public static void loadCache() {
        OpenSSHConfigParser.OpenSSHConfig items = OpenSSHConfigParser.parseUserConfig();
        String cache = StreamlinePreferences.getAuthCache();
        if (!cache.isEmpty()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (XMLParser xml = new XMLParser((InputStream)new ByteArrayInputStream(cache.getBytes(StandardCharsets.UTF_8)));){
                    String tag;
                    String marker = xml.getMarker();
                    while ((tag = xml.nextTag(marker)) != null) {
                        if (tag.equals(TAG_CREDENTRIALS)) {
                            tag = xml.nextTag(marker);
                            if (TAG_AUTHENTICATIONS.equals(tag)) {
                                TargetAuthentication.loadCachePerStorage(xml, CACHE, TAG_AUTHENTICATION, null);
                            }
                            if (TAG_SSH_AUTHENTICATIONS.equals(tag = xml.nextTag(marker))) {
                                TargetAuthentication.loadCachePerStorage(xml, SSH_CACHE, TAG_SSH_AUTHENTICATION, items);
                            }
                        }
                        xml.skip();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException exception) {
                CommonPlugin.error((Throwable)exception);
            }
        }
        Map predefinedHosts = items.enumerateHosts();
        for (Map.Entry entry : predefinedHosts.entrySet()) {
            OpenSSHConfigParser.HostDefaults defaults;
            String hostname = (String)entry.getKey();
            TargetAuthentication targetAuth = TargetAuthentication.createFromSSHConfig(items.createTargetConfig(hostname, defaults = (OpenSSHConfigParser.HostDefaults)entry.getValue()));
            CredentialsAddress address = targetAuth.getCredentialsAddress();
            if (address == null || SSH_CACHE.containsKey(address)) continue;
            SSH_CACHE.put(address, targetAuth);
        }
    }

    public static @Nullable TargetAuthentication prompt(@NonNull CredentialsAddress address, TargetAuthenticationConfig config, boolean allowTargetChange) {
        TargetAuthentication authentication = new TargetAuthentication(null, address.asTargetAddressString(), null, null, null, null, null, null, false);
        return TargetAuthentication.prompt(authentication, config, allowTargetChange);
    }

    public static @Nullable TargetAuthentication prompt(TargetAuthentication authentication, TargetAuthenticationConfig config, boolean allowTargetChange) {
        UIHelper helper = new UIHelper(authentication, config, allowTargetChange);
        Task.blockingCallOnUIThread((Runnable)helper);
        return helper.getAuthentication();
    }

    public static void removeFromSSHCache(String address) {
        SSH_CACHE.remove(new CredentialsAddress(new TargetAddressString(address)));
    }

    public static void saveCache() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (XMLGenerator xml = new XMLGenerator((OutputStream)baos);){
                xml.startDocument();
                xml.startTag(TAG_CREDENTRIALS);
                TargetAuthentication.saveCache(TAG_AUTHENTICATIONS, xml);
                TargetAuthentication.saveSSHCache(TAG_SSH_AUTHENTICATIONS, xml);
                xml.endTag();
                xml.endDocument();
                StreamlinePreferences.setAuthCache(baos.toString(StandardCharsets.UTF_8.name()));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exception) {
            CommonPlugin.error((Throwable)exception);
        }
    }

    private static @NonNull TargetAuthentication createFromSSHConfig(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull OpenSSHConfigParser.SSHTargetConfig targetConfig) {
        return new TargetAuthentication(targetConfig, new TargetAddressString(String.format("tcp:%s", targetConfig.hostname())), null, null, null, null, null, null, true);
    }

    private static String decrypt(String str) {
        str = (String)NullChecking.neverNullOr((Object)str, (Object)"");
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] buffer = new byte[bytes.length / 2];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = (byte)((TargetAuthentication.getHexDigit(bytes[i * 2]) << 4) + TargetAuthentication.getHexDigit(bytes[i * 2 + 1]) & 0xFF);
            ++i;
        }
        byte[] result = new byte[buffer.length];
        int i2 = 0;
        while (i2 < buffer.length) {
            result[result.length - (i2 + 1)] = (byte)((buffer[i2] ^ KEY[(buffer.length - (i2 + 1)) % KEY.length]) & 0xFF);
            ++i2;
        }
        return new String(result, StandardCharsets.UTF_8);
    }

    private static String encrypt(String str) {
        str = (String)NullChecking.neverNullOr((Object)str, (Object)"");
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[result.length - (i + 1)] = (byte)((bytes[i] ^ KEY[i % KEY.length]) & 0xFF);
            ++i;
        }
        StringBuilder buffer = new StringBuilder(result.length * 2);
        byte[] byArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            Object hex = Integer.toHexString(b & 0xFF);
            if (((String)hex).length() < 2) {
                hex = "0" + (String)hex;
            }
            buffer.append((String)hex);
            ++n2;
        }
        return buffer.toString();
    }

    private static final @Nullable String filterToNull(String in, boolean trim) {
        if (in == null) {
            return null;
        }
        if (trim) {
            in = in.trim();
        }
        return in.isEmpty() ? null : in;
    }

    private static int getHexDigit(byte b) {
        return b <= 57 ? b - 48 : 10 + b - 97;
    }

    private static @Nullable TargetAuthentication load(@NonNull XMLParser xml) {
        String addressAttr = TargetAuthentication.filterToNull(xml.getAttribute("address"), true);
        TargetAddressString address = new TargetAddressString(addressAttr);
        String userName = TargetAuthentication.filterToNull(xml.getAttribute("user"), true);
        String password = TargetAuthentication.filterToNull(TargetAuthentication.decrypt(xml.getAttribute("pass", "")), false);
        String rootPassword = TargetAuthentication.filterToNull(TargetAuthentication.decrypt(xml.getAttribute(ATTR_ROOT_PASSWORD, "")), false);
        if (!address.isValid()) {
            return null;
        }
        return new TargetAuthentication(null, address, userName, null, password, null, rootPassword, null, false);
    }

    private static @Nullable TargetAuthentication load(@NonNull XMLParser xml, // Could not load outer class - annotation placement on inner may be incorrect
    @NonNull OpenSSHConfigParser.OpenSSHConfig hostDefaults) {
        String keyPathsAttr = TargetAuthentication.filterToNull(xml.getAttribute(ATTR_SSH_PASS_KEY, ""), true);
        List<File> keyPaths = keyPathsAttr != null ? Arrays.stream(keyPathsAttr.split(File.pathSeparator)).map(File::new).toList() : Collections.emptyList();
        String id = TargetAuthentication.filterToNull(xml.getAttribute(ATTR_SSH_SESSION_NAME), true);
        String addressAttr = TargetAuthentication.filterToNull(xml.getAttribute("address"), true);
        String portAttr = TargetAuthentication.filterToNull(xml.getAttribute(ATTR_SSH_GATOR_PORT), true);
        Integer gatorPort = (Integer)NullChecking.neverNullOr(portAttr != null && !portAttr.isBlank() ? Integer.valueOf(portAttr) : null, (Object)SshTargetLauncher.getDefaultGatorPort());
        TargetAddressString address = new TargetAddressString(String.format("tcp:%s:%d", addressAttr, gatorPort));
        assert (address.isTcp());
        assert (NullChecking.equalsNeverNull((Object)address.getHostname(), (Object)addressAttr));
        assert (NullChecking.equalsNeverNull((Object)address.getPortOrDefault(0), (Object)gatorPort)) : String.valueOf(address) + ":  " + String.valueOf(gatorPort);
        if (!address.isTcp()) {
            return null;
        }
        String userName = TargetAuthentication.filterToNull(xml.getAttribute("user"), true);
        String password = TargetAuthentication.filterToNull(TargetAuthentication.decrypt(xml.getAttribute("pass", "")), false);
        String sshPort = TargetAuthentication.filterToNull(xml.getAttribute(ATTR_SSH_PORT), true);
        String gatorPath = TargetAuthentication.filterToNull(xml.getAttribute(ATTR_SSH_GATOR_PATH, ""), true);
        Integer sshPortVal = sshPort != null ? Integer.decode(sshPort) : null;
        OpenSSHConfigParser.SSHTargetConfig sshTargetDefaults = hostDefaults.createTargetConfig(id != null && !id.isBlank() ? id : address.getHostname(), address.getHostname(), userName, password, keyPaths, sshPortVal);
        return new TargetAuthentication(sshTargetDefaults, address, userName, keyPaths, password, sshPortVal, null, gatorPath, false);
    }

    private static void loadCachePerStorage(@NonNull XMLParser xml, @NonNull Map<@NonNull CredentialsAddress, @NonNull TargetAuthentication> cache, @NonNull String tagToMatch, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable OpenSSHConfigParser.OpenSSHConfig sshConfig) throws IOException {
        String tag;
        cache.clear();
        String marker = xml.getMarker();
        while ((tag = xml.nextTag(marker)) != null) {
            if (tagToMatch.equals(tag)) {
                CredentialsAddress ca;
                TargetAuthentication authentication = null;
                authentication = sshConfig != null ? TargetAuthentication.load(xml, sshConfig) : TargetAuthentication.load(xml);
                if (authentication == null || (ca = authentication.getCredentialsAddress()) == null) continue;
                cache.put(ca, authentication);
                continue;
            }
            xml.skip();
        }
    }

    private static void saveCache(String tag, XMLGenerator xml) throws IOException {
        ArrayList<@NonNull CredentialsAddress> keys = new ArrayList<CredentialsAddress>(CACHE.keySet());
        Collections.sort(keys);
        xml.startTag(tag);
        for (CredentialsAddress key : keys) {
            ((TargetAuthentication)NullChecking.neverNull((Object)CACHE.get(key))).save(TAG_AUTHENTICATION, xml);
        }
        xml.endTag();
    }

    private static void saveSSHCache(String tag, XMLGenerator xml) throws IOException {
        xml.startTag(tag);
        for (TargetAuthentication entry : SSH_CACHE.values()) {
            if (entry.fromDefaults) continue;
            entry.saveSSH(TAG_SSH_AUTHENTICATION, xml);
        }
        xml.endTag();
    }

    public TargetAuthentication() {
        this(null, null, null, Collections.emptyList(), null, null, null, null, false);
    }

    public TargetAuthentication(@NonNull CredentialsAddress address, @Nullable String username, @Nullable String password, @NonNull List<@NonNull File> keyFiles, int sshPort) {
        this(null, address.asTargetAddressString(), username, keyFiles, password, sshPort, null, null, false);
    }

    private static <T> @Nullable T getSshDefault(@Nullable T val, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable OpenSSHConfigParser.SSHTargetConfig sshTargetConfig, @NonNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull OpenSSHConfigParser.SSHTargetConfig, @Nullable T> fieldGetter, @NonNull Function<// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull OpenSSHConfigParser.HostDefaults, @Nullable T> defaultsGetter) {
        T dVal;
        T tVal;
        if (val != null) {
            return val;
        }
        if (sshTargetConfig != null && !NullChecking.equalsNullable(tVal = fieldGetter.apply(sshTargetConfig), dVal = defaultsGetter.apply(sshTargetConfig.unmodifiedHostDefaults()))) {
            return tVal;
        }
        return null;
    }

    private TargetAuthentication(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable OpenSSHConfigParser.SSHTargetConfig sshTargetConfig, @Nullable TargetAddressString address, @Nullable String username, @Nullable List<@NonNull File> keyFiles, @Nullable String password, @Nullable Integer sshPort, @Nullable String rootPassword, @Nullable String gatorPath, boolean fromDefaults) {
        this.sshTargetConfig = sshTargetConfig;
        this.address = address;
        this.username = TargetAuthentication.getSshDefault(username, sshTargetConfig, OpenSSHConfigParser.SSHTargetConfig::username, OpenSSHConfigParser.HostDefaults::username);
        this.password = TargetAuthentication.getSshDefault(password, sshTargetConfig, OpenSSHConfigParser.SSHTargetConfig::password, d -> null);
        this.keyFiles = TargetAuthentication.getSshDefault(keyFiles, sshTargetConfig, OpenSSHConfigParser.SSHTargetConfig::keyFiles, OpenSSHConfigParser.HostDefaults::computeIdentityFilePaths);
        this.sshPort = TargetAuthentication.getSshDefault(sshPort, sshTargetConfig, OpenSSHConfigParser.SSHTargetConfig::port, d -> 22);
        this.rootPassword = rootPassword;
        this.gatorPath = gatorPath;
        this.fromDefaults = fromDefaults;
    }

    public final TargetAuthentication clone() {
        try {
            return (TargetAuthentication)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public @Nullable CredentialsAddress getCredentialsAddress() {
        TargetAddressString ta = this.getTargetAddressString();
        if (ta != null && ta.isValid()) {
            return new CredentialsAddress(ta);
        }
        return null;
    }

    public @NonNull String getGatorPath() {
        String gp = this.gatorPath;
        if (gp != null && !gp.isBlank()) {
            return gp;
        }
        return SshTargetLauncher.getDefaultGatorPath();
    }

    public int getGatorPort() {
        TargetAddressString ta = this.address;
        if (ta != null) {
            return ta.getPortOrDefault(SshTargetLauncher.getDefaultGatorPort());
        }
        return SshTargetLauncher.getDefaultGatorPort();
    }

    public @NonNull List<@NonNull File> getKeyFiles() {
        List<File> k = this.keyFiles;
        if (k != null && !k.isEmpty()) {
            return k;
        }
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        if (stc != null) {
            return stc.keyFiles();
        }
        return Collections.emptyList();
    }

    public @Nullable String getPassword() {
        String p = this.password;
        if (p != null && !p.isBlank()) {
            return p;
        }
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        if (stc != null) {
            return stc.password();
        }
        return null;
    }

    public @Nullable String getRootPassword() {
        return this.rootPassword;
    }

    public int getSSHPort() {
        Integer k = this.sshPort;
        if (k != null && k >= 0 && k < 65536) {
            return k;
        }
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        if (stc != null) {
            return stc.port();
        }
        return 22;
    }

    public @Nullable TargetAddressString getTargetAddressString() {
        TargetAddressString ta = this.address;
        if (ta != null) {
            return ta;
        }
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        if (stc != null) {
            return new TargetAddressString(String.format("tcp:%s:%d", stc.hostname(), this.getGatorPort()));
        }
        return null;
    }

    public @Nullable String getUsername() {
        String u = this.username;
        if (u != null && !u.isBlank()) {
            return u;
        }
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        if (stc != null) {
            return stc.username();
        }
        return null;
    }

    public boolean isAndroid() {
        TargetAddressString ta = this.getTargetAddressString();
        if (ta != null) {
            return ta.isAndroid();
        }
        return false;
    }

    public boolean isTcp() {
        TargetAddressString ta = this.getTargetAddressString();
        if (ta != null) {
            return ta.isTcp();
        }
        return false;
    }

    private final void save(@NonNull String tag, XMLGenerator xml) throws IOException {
        TargetAddressString a = this.address;
        xml.startEmptyTag(tag);
        xml.addAttributeNotEmpty("address", a != null ? a.toString() : null);
        xml.addAttributeNotEmpty("user", this.username);
        xml.addAttributeNotEmpty("pass", TargetAuthentication.encrypt(this.password));
        xml.addAttributeNotEmpty(ATTR_ROOT_PASSWORD, TargetAuthentication.encrypt(this.rootPassword));
    }

    private final void saveSSH(String tag, XMLGenerator xml) throws IOException {
        TargetAddressString address = this.address;
        List<File> keyFiles = this.keyFiles;
        Address a = address != null ? address.getTcpAddressOrDefault("", SshTargetLauncher.getDefaultGatorPort()) : null;
        Integer p = this.sshPort;
        OpenSSHConfigParser.SSHTargetConfig stc = this.sshTargetConfig;
        xml.startEmptyTag(tag);
        xml.addAttributeNotEmpty("address", a != null ? a.hostname() : "");
        xml.addAttributeNotEmpty("user", this.username);
        xml.addAttributeNotEmpty("pass", TargetAuthentication.encrypt(this.password));
        xml.addAttributeNotEmpty(ATTR_SSH_PASS_KEY, keyFiles != null ? keyFiles.stream().map(FileUtils::canonicalisePath).collect(Collectors.joining(File.pathSeparator)) : null);
        xml.addAttributeNotEmpty(ATTR_SSH_SESSION_NAME, stc != null ? stc.id() : null);
        xml.addAttributeNotEmpty(ATTR_SSH_PORT, p != null ? p.toString() : null);
        xml.addAttributeNotEmpty(ATTR_SSH_GATOR_PATH, this.gatorPath);
        xml.addAttributeNotEmpty(ATTR_SSH_GATOR_PORT, a != null ? Integer.toString(a.port()) : null);
    }

    public String toString() {
        return "TargetAuthentication [address=" + String.valueOf(this.address) + ", fromDefaults=" + this.fromDefaults + ", gatorPath=" + this.gatorPath + ", keyFiles=" + String.valueOf(this.keyFiles) + ", password=" + this.password + ", rootPassword=" + this.rootPassword + ", sshPort=" + String.valueOf(this.sshPort) + ", sshTargetConfig=" + String.valueOf(this.sshTargetConfig) + ", username=" + this.username + "]";
    }

    public record Address(@NonNull String hostname, int port) {
    }

    private static class UIHelper
    implements Runnable {
        private boolean mAllowTargetChange;
        private TargetAuthentication mAuthentication;
        private TargetAuthenticationConfig mConfig;

        UIHelper(TargetAuthentication authentication, TargetAuthenticationConfig config, boolean allowTargetChange) {
            this.mAuthentication = authentication;
            this.mConfig = config;
            this.mAllowTargetChange = allowTargetChange;
        }

        public @Nullable TargetAuthentication getAuthentication() {
            return this.mAuthentication;
        }

        @Override
        public void run() {
            TargetAuthenticationDialog dialog = new TargetAuthenticationDialog(this.mAuthentication, this.mConfig, this.mAllowTargetChange);
            this.mAuthentication = dialog.open() == 0 ? dialog.getResult() : null;
        }
    }
}

