/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences.editors;

import com.arm.utils.NullChecking;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public abstract class TableEditor<T>
extends FieldEditor {
    private @Nullable Button btnAdd;
    private @Nullable Button btnDown;
    private @Nullable Button btnRemove;
    private @Nullable Button btnUp;
    private @Nullable Composite cmpButtons;
    private final @NonNull ITableEditorColumn<T> @NonNull [] columns;
    private final boolean enableMoveOps;
    private final @NonNull SelectionListener selectionListener;
    private @Nullable Table table;

    protected TableEditor(@NonNull String name, @NonNull String labelText, @NonNull Composite parent, boolean enableMoveOps, @NonNull ITableEditorColumn<T> @NonNull [] columns) {
        if (columns.length == 0) {
            throw new IllegalArgumentException("Missing columns list");
        }
        this.columns = columns;
        this.enableMoveOps = enableMoveOps;
        this.selectionListener = SelectionListener.widgetSelectedAdapter(event -> {
            Widget widget = event.widget;
            if (widget == null) {
                return;
            }
            if (widget == this.btnAdd) {
                this.onBtnAddPressed();
            } else if (widget == this.btnRemove) {
                this.onBtnRemovePressed();
            } else if (widget == this.btnUp) {
                this.onBtnUpPressed();
            } else if (widget == this.btnDown) {
                this.onBtnDownPressed();
            } else if (widget == this.table) {
                this.onSelectionChanged();
            }
        });
        this.init(name, labelText);
        this.createControl(parent);
    }

    public int getNumberOfControls() {
        return 2;
    }

    public void setEnabled(boolean enabled, Composite parent) {
        Button btnDown;
        Button btnUp;
        Button btnAdd;
        super.setEnabled(enabled, parent);
        Table table = this.table;
        if (table != null) {
            table.setEnabled(enabled);
        }
        if ((btnAdd = this.btnAdd) != null) {
            btnAdd.setEnabled(enabled);
        }
        int index = table != null ? table.getSelectionIndex() : -1;
        int size = table != null ? table.getItemCount() : 0;
        Button btnRemove = this.btnRemove;
        if (btnRemove != null) {
            btnRemove.setEnabled(enabled && index >= 0);
        }
        if ((btnUp = this.btnUp) != null) {
            btnUp.setEnabled(enabled && size > 1 && index > 0);
        }
        if ((btnDown = this.btnDown) != null) {
            btnDown.setEnabled(enabled && size > 1 && index >= 0 && index < size - 1);
        }
    }

    public void setFocus() {
        Table table = this.table;
        if (table == null) {
            return;
        }
        table.setFocus();
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        Table table = this.table;
        if (control != null) {
            ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        }
        if (table != null) {
            ((GridData)table.getLayoutData()).horizontalSpan = numColumns - 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Composite cmpButtons;
        Table table;
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        this.table = table = new Table(parent, 2820);
        table.setFont(parent.getFont());
        table.addSelectionListener(this.selectionListener);
        table.addDisposeListener(event -> {
            Table table = this.table = null;
        });
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        ITableEditorColumn<T>[] iTableEditorColumnArray = this.columns;
        int n = this.columns.length;
        int n2 = 0;
        while (n2 < n) {
            ITableEditorColumn<T> column = iTableEditorColumnArray[n2];
            TableColumn tc = new TableColumn(table, column.getSwtColumnStyle());
            tc.setText(column.getColumnLabel());
            ++n2;
        }
        GridData gd2 = new GridData(768);
        gd2.verticalAlignment = 4;
        gd2.horizontalSpan = numColumns - 1;
        gd2.grabExcessHorizontalSpace = true;
        gd2.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gd2);
        this.cmpButtons = cmpButtons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        cmpButtons.setLayout((Layout)layout);
        this.btnAdd = this.createButton(cmpButtons, "Add");
        this.btnRemove = this.createButton(cmpButtons, "Remove");
        if (this.enableMoveOps) {
            this.btnUp = this.createButton(cmpButtons, "Up");
            this.btnDown = this.createButton(cmpButtons, "Down");
        }
        cmpButtons.addDisposeListener(event -> {
            this.btnAdd = null;
            this.btnRemove = null;
            this.btnUp = null;
            this.btnDown = null;
            this.cmpButtons = null;
        });
        GridData gd3 = new GridData();
        gd3.verticalAlignment = 1;
        cmpButtons.setLayoutData((Object)gd3);
    }

    protected void doLoad() {
        String prefValue = this.getPreferenceStore().getString(this.getPreferenceName());
        this.doLoadCommon((String)NullChecking.neverNullOr((Object)prefValue, (Object)""));
    }

    protected void doLoadDefault() {
        String prefValue = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
        this.doLoadCommon((String)NullChecking.neverNullOr((Object)prefValue, (Object)""));
    }

    protected void doStore() {
        Table table = this.table;
        if (table == null) {
            return;
        }
        TableItem[] items = table.getItems();
        T[] values = this.newValuesArray(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            Object value = NullChecking.neverNull((Object)item.getData());
            values[i] = value;
            ++i;
        }
        String prefValue = this.valuesToString(values);
        this.getPreferenceStore().setValue(this.getPreferenceName(), prefValue);
    }

    protected final @Nullable Composite getButtonBox() {
        return this.cmpButtons;
    }

    protected abstract @Nullable T getNewRowValue();

    protected final @Nullable Shell getShell() {
        Composite cmpButtons = this.cmpButtons;
        if (cmpButtons == null) {
            return null;
        }
        return cmpButtons.getShell();
    }

    protected final @Nullable Table getTable() {
        return this.table;
    }

    protected abstract @NonNull T @NonNull [] newValuesArray(int var1);

    protected void onSelectionChanged() {
        Button btnDown;
        Button btnUp;
        Table table = this.table;
        if (table == null) {
            return;
        }
        int index = table.getSelectionIndex();
        int size = table.getItemCount();
        Button btnRemove = this.btnRemove;
        if (btnRemove != null) {
            btnRemove.setEnabled(index >= 0);
        }
        if ((btnUp = this.btnUp) != null) {
            btnUp.setEnabled(size > 1 && index > 0);
        }
        if ((btnDown = this.btnDown) != null) {
            btnDown.setEnabled(size > 1 && index >= 0 && index < size - 1);
        }
    }

    protected void populateItemFromValue(@NonNull TableItem item, @NonNull T value) {
        item.setData(value);
        int c = 0;
        while (c < this.columns.length) {
            item.setImage(c, this.columns[c].getItemImage(value));
            item.setText(c, this.columns[c].getItemLabel(value));
            ++c;
        }
    }

    protected abstract @NonNull T @NonNull [] valuesFromString(@NonNull String var1);

    protected abstract @NonNull String valuesToString(@NonNull T @NonNull [] var1);

    private @NonNull Button createButton(@NonNull Composite parent, @NonNull String label) {
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.selectionListener);
        return button;
    }

    private void doLoadCommon(@NonNull String prefValue) {
        Table table = this.table;
        if (table == null) {
            return;
        }
        T[] values = this.valuesFromString(prefValue);
        table.removeAll();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T value = objectArray[n2];
            TableItem item = new TableItem(table, 0);
            this.populateItemFromValue(item, value);
            ++n2;
        }
        objectArray = table.getColumns();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            T column = objectArray[n2];
            column.pack();
            ++n2;
        }
        this.onSelectionChanged();
    }

    private void onBtnAddPressed() {
        Table table = this.table;
        if (table == null) {
            return;
        }
        T value = this.getNewRowValue();
        if (value != null) {
            this.setPresentsDefaultValue(false);
            int index = table.getSelectionIndex();
            TableItem item = index >= 0 ? new TableItem(table, 0, index + 1) : new TableItem(table, 0);
            this.populateItemFromValue(item, value);
            this.onSelectionChanged();
        }
    }

    private void onBtnDownPressed() {
        this.swap(false);
    }

    private void onBtnRemovePressed() {
        Table table = this.table;
        if (table == null) {
            return;
        }
        this.setPresentsDefaultValue(false);
        int index = table.getSelectionIndex();
        if (index >= 0) {
            table.remove(index);
            table.select(index >= table.getItemCount() ? index - 1 : index);
            this.onSelectionChanged();
        }
    }

    private void onBtnUpPressed() {
        this.swap(true);
    }

    private void swap(boolean up) {
        int indexTo;
        Table table = this.table;
        if (table == null) {
            return;
        }
        this.setPresentsDefaultValue(false);
        int indexFrom = table.getSelectionIndex();
        int n = indexTo = up ? indexFrom - 1 : indexFrom + 1;
        if (indexFrom >= 0 && indexTo >= 0) {
            TableItem itemFrom = table.getItem(indexFrom);
            TableItem itemTo = table.getItem(indexTo);
            Object valFrom = NullChecking.neverNull((Object)itemFrom.getData());
            Object valTo = NullChecking.neverNull((Object)itemTo.getData());
            this.populateItemFromValue(itemFrom, valTo);
            this.populateItemFromValue(itemTo, valFrom);
            table.setSelection(indexTo);
            table.requestLayout();
        }
        this.onSelectionChanged();
    }

    public static interface ITableEditorColumn<T> {
        public @NonNull String getColumnLabel();

        public @Nullable Image getItemImage(@NonNull T var1);

        public @NonNull String getItemLabel(@NonNull T var1);

        default public int getSwtColumnStyle() {
            return 16384;
        }
    }
}

