/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.application.preferences.editors;

import com.arm.streamline.application.preferences.PreferencesMessages;
import com.arm.streamline.application.preferences.editors.EditablePathEditor;
import com.arm.streamline.common.utility.Task;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.ui.PlatformUI;

public class EditablePathEditorWithSearch
extends EditablePathEditor {
    protected final @NonNull AtomicBoolean cancelled = new AtomicBoolean(false);
    private @Nullable Button cancelButton;
    private final @NonNull ISearchPredicate predicate;
    private @Nullable ProgressBar progressBar;
    private @Nullable Composite progressParent;
    private @Nullable Label progressText;
    private final @NonNull AtomicReference<@Nullable ProgressValue> progressToShow = new AtomicReference();
    private @Nullable Button searchButton;

    private static void searchDirectories(@NonNull IProgressMonitor monitor, @NonNull File directory, @NonNull Set<@NonNull File> resultSet, @NonNull Set<@NonNull File> searchedSet, @NonNull ISearchPredicate predicate) {
        assert (directory.isDirectory());
        directory = FileUtils.canonicalise((File)directory);
        monitor.setCurrentPath(directory);
        if (searchedSet.add(directory)) {
            @NonNull ISearchPredicate.Result result = predicate.test(directory);
            switch (result) {
                case ADD_NO_SCAN: 
                case ADD_SCAN: {
                    resultSet.add(directory);
                    break;
                }
                case NO_ADD_NO_SCAN: 
                case NO_ADD_SCAN: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)result);
                }
            }
            @NonNull File @Nullable [] children = directory.listFiles();
            if (children != null) {
                switch (result) {
                    case ADD_SCAN: 
                    case NO_ADD_SCAN: {
                        monitor.incNumChildren(children.length);
                        File[] fileArray = children;
                        int n = children.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File child = fileArray[n2];
                            if (monitor.isCanceled()) {
                                return;
                            }
                            if (child.isDirectory()) {
                                EditablePathEditorWithSearch.searchDirectories(monitor, child, resultSet, searchedSet, predicate);
                            }
                            monitor.completeChild();
                            ++n2;
                        }
                        break;
                    }
                    case ADD_NO_SCAN: 
                    case NO_ADD_NO_SCAN: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)result);
                    }
                }
            }
        }
    }

    public EditablePathEditorWithSearch(String name, String labelText, String dirChooserLabelText, Composite parent, @NonNull ISearchPredicate predicate) {
        super(name, labelText, dirChooserLabelText, parent);
        this.predicate = predicate;
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        Composite buttonBox = this.getButtonBoxControl(parent);
        Button searchButton = new Button(buttonBox, 8);
        searchButton.setText(PreferencesMessages.DATA_LOCATIONS_SEARCH_DIR_LABEL);
        searchButton.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)searchButton, 61);
        data.widthHint = Math.max(widthHint, searchButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        searchButton.setLayoutData((Object)data);
        this.searchButton = searchButton;
        Control[] bbChildren = buttonBox.getChildren();
        assert (bbChildren.length > 1);
        assert (bbChildren[1] instanceof Button);
        searchButton.moveBelow(bbChildren[1]);
        buttonBox.addDisposeListener(e -> {
            Button button = this.searchButton = null;
        });
        searchButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditablePathEditorWithSearch.this.searchAction();
            }
        });
        Composite progressParent = new Composite(parent, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)progressParent);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(progressParent);
        ProgressBar progressBar = new ProgressBar(progressParent, 256);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)progressBar);
        Button cancelButton = new Button(progressParent, 0);
        cancelButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_STOP"));
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)cancelButton);
        Label progressText = new Label(progressParent, 0);
        GridDataFactory.fillDefaults().align(4, 0x1000000).span(2, 1).applyTo((Control)progressText);
        this.progressParent = progressParent;
        this.progressBar = progressBar;
        this.cancelButton = cancelButton;
        this.progressText = progressText;
        cancelButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                EditablePathEditorWithSearch.this.cancelled.set(true);
            }
        });
        progressParent.addDisposeListener(e -> {
            this.cancelled.set(true);
            this.progressParent = null;
            this.progressBar = null;
            this.cancelButton = null;
            this.progressText = null;
        });
        this.clearSearch();
    }

    protected void searchAction() {
        String newPath;
        final Display display = this.getShell().getDisplay();
        @Nullable Button searchButton = this.searchButton;
        if (searchButton != null && (newPath = this.getNewInputObject()) != null) {
            this.startSearch();
            Task.executeAsynchronously(() -> {
                @NonNull File directory = new File(newPath);
                final @NonNull TreeSet<@NonNull File> container = new TreeSet<File>((a, b) -> a.getAbsolutePath().compareToIgnoreCase(b.getAbsolutePath()));
                @NonNull IProgressMonitor monitor = new IProgressMonitor(directory){
                    private @NonNull File lastPath;
                    private int totalComplete;
                    private int totalNumChildren;
                    {
                        this.lastPath = file;
                        this.totalComplete = 0;
                        this.totalNumChildren = 0;
                    }

                    @Override
                    public void completeChild() {
                        ++this.totalComplete;
                        this.update();
                    }

                    @Override
                    public void incNumChildren(int n) {
                        this.totalNumChildren += n;
                        this.update();
                    }

                    @Override
                    public boolean isCanceled() {
                        return EditablePathEditorWithSearch.this.cancelled.get();
                    }

                    @Override
                    public void setCurrentPath(@NonNull File path) {
                        this.lastPath = path;
                        this.update();
                    }

                    private void update() {
                        EditablePathEditorWithSearch.this.updateSearchProgress(display, container.size(), this.lastPath, this.totalComplete, this.totalNumChildren);
                    }
                };
                EditablePathEditorWithSearch.searchDirectories(monitor, directory, container, new HashSet<File>(), this.predicate);
                display.asyncExec(() -> {
                    List list = this.getList();
                    if (list != null) {
                        @NonNull Set<@NonNull T> alreadyInList = Arrays.asList(list.getItems()).stream().map(s -> FileUtils.canonicalise((File)new File((String)s))).collect(Collectors.toSet());
                        container.removeAll(alreadyInList);
                        for (File path : container) {
                            list.add(path.getAbsolutePath());
                        }
                        this.clearSearch();
                    }
                });
            });
        }
    }

    protected void updateSearchProgress(Display display, int numFound, @NonNull File path, int totalComplete, int totalNumChildren) {
        @Nullable ProgressValue previousValue = this.progressToShow.getAndSet(new ProgressValue(String.format(PreferencesMessages.DATA_LOCATIONS_SEARCH_PROGRESS_MESSAGE, numFound, totalComplete, totalNumChildren, path.getAbsolutePath()), totalComplete, totalNumChildren));
        if (previousValue == null) {
            display.asyncExec(() -> {
                @Nullable ProgressValue progressValue = this.progressToShow.getAndSet(null);
                @Nullable ProgressBar progressBar = this.progressBar;
                if (progressBar != null && progressValue != null) {
                    progressBar.setMaximum(progressValue.total);
                    progressBar.setSelection(progressValue.count);
                    ((Label)NullChecking.neverNull((Object)this.progressText)).setText(progressValue.message);
                }
            });
        }
    }

    private void clearSearch() {
        ((Button)NullChecking.neverNull((Object)this.searchButton)).setEnabled(true);
        ((Button)NullChecking.neverNull((Object)this.cancelButton)).setEnabled(false);
        ((Composite)NullChecking.neverNull((Object)this.progressParent)).setVisible(false);
    }

    private void startSearch() {
        @NonNull ProgressBar progressBar = (ProgressBar)NullChecking.neverNull((Object)this.progressBar);
        ((Button)NullChecking.neverNull((Object)this.searchButton)).setEnabled(false);
        ((Composite)NullChecking.neverNull((Object)this.progressParent)).setVisible(true);
        progressBar.setMaximum(0);
        progressBar.setSelection(0);
        ((Button)NullChecking.neverNull((Object)this.cancelButton)).setEnabled(true);
        ((Label)NullChecking.neverNull((Object)this.progressText)).setText("");
        this.cancelled.set(false);
        this.progressToShow.set(null);
    }

    private static interface IProgressMonitor {
        public void completeChild();

        public void incNumChildren(int var1);

        public boolean isCanceled();

        public void setCurrentPath(@NonNull File var1);
    }

    @FunctionalInterface
    public static interface ISearchPredicate {
        public @NonNull Result test(@NonNull File var1);

        public static enum Result {
            ADD_NO_SCAN,
            ADD_SCAN,
            NO_ADD_NO_SCAN,
            NO_ADD_SCAN;

        }
    }

    private static class ProgressValue {
        public final int count;
        public final @NonNull String message;
        public final int total;

        public ProgressValue(@NonNull String message, int count, int total) {
            this.message = message;
            this.count = count;
            this.total = total;
        }
    }
}

