/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analytics;

import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.preferences.CommonPreferences;
import com.arm.streamline.jni.analytics.AnalyticsLogger;
import com.arm.streamline.jni.analytics.BooleanKey;
import com.arm.streamline.jni.analytics.DoubleKey;
import com.arm.streamline.jni.analytics.StringKey;
import com.arm.streamline.jni.analytics.ToolKey;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.EnumSet;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LogAnalytics {
    public static final @NonNull LogAnalytics instance = new LogAnalytics();
    private static @NonNull Supplier<@Nullable AnalyticsLogger> LOGGER_FACTORY = LogAnalytics::makeDefaultLogger;
    private static final EnumSet<@NonNull BooleanKey> PRESET_BOOLEAN_KEYS = EnumSet.allOf(BooleanKey.class);
    private static final EnumSet<@NonNull DoubleKey> PRESET_DOUBLE_KEYS = EnumSet.allOf(DoubleKey.class);
    private static final EnumSet<@NonNull StringKey> PRESET_STRING_KEYS = EnumSet.allOf(StringKey.class);
    private static final EnumSet<@NonNull ToolKey> PRESET_TOOL_KEYS = EnumSet.allOf(ToolKey.class);

    private LogAnalytics() {
    }

    private static @NonNull OS detectOS() {
        String os = System.getProperty("os.name", "").toLowerCase(Locale.ROOT);
        if (os.contains("win")) {
            return OS.WINDOWS;
        }
        if (os.contains("mac") || os.contains("darwin")) {
            return OS.MAC;
        }
        return OS.LINUX;
    }

    private static @Nullable String getCoreLibraryPath() {
        OS os = LogAnalytics.detectOS();
        switch (os) {
            case LINUX: {
                return LogAnalytics.getCoreLibraryPath("libAnalyticsCore", "libAnalyticsCore.so", "STREAMLINE_LIBANALYTICS_CORE_LINUX");
            }
            case MAC: {
                return LogAnalytics.getCoreLibraryPath("Streamline.app/Contents/lib", "libAnalyticsCore.dylib", "STREAMLINE_LIBANALYTICS_CORE_MACOS");
            }
            case WINDOWS: {
                return LogAnalytics.getCoreLibraryPath("libAnalyticsCore", "AnalyticsCore.dll", "STREAMLINE_LIBANALYTICS_CORE_WINDOWS");
            }
        }
        throw new AssertionError((Object)os);
    }

    private static @Nullable String getCoreLibraryPath(@NonNull String libPath, @NonNull String libName, @NonNull String envName) {
        TreeSet<File> searchedPaths = new TreeSet<File>();
        File installRoot = CommonPlugin.getInstallDir();
        File libFile = new File(new File(installRoot, libPath), libName);
        searchedPaths.add(libFile);
        if (LogAnalytics.validLibPath(libFile)) {
            if (LogAnalytics.class.desiredAssertionStatus()) {
                CommonPlugin.info((String)String.format("Found analytics library in %s", libFile), null);
            }
            return FileUtils.canonicalisePath((File)libFile);
        }
        String envVal = System.getenv(envName);
        if (envVal != null && !envVal.isBlank()) {
            libFile = new File(envVal, libName);
            searchedPaths.add(libFile);
            if (LogAnalytics.validLibPath(libFile)) {
                if (LogAnalytics.class.desiredAssertionStatus()) {
                    CommonPlugin.info((String)String.format("Found analytics library in %s", libFile), null);
                }
                return FileUtils.canonicalisePath((File)libFile);
            }
        }
        if (LogAnalytics.class.desiredAssertionStatus()) {
            CommonPlugin.info((String)String.format("Failed to find analytics library in %s", searchedPaths), null);
        } else {
            CommonPlugin.info((String)"Product analytics is disabled", null);
        }
        return null;
    }

    private static boolean validLibPath(@NonNull File candidate) {
        return candidate.isFile() && candidate.canRead();
    }

    private static void requireAllowed(@NonNull BooleanKey key) {
        if (!PRESET_BOOLEAN_KEYS.contains(key)) {
            throw new IllegalArgumentException("Unsupported BooleanKey: " + String.valueOf(key));
        }
    }

    private static void requireAllowed(@NonNull DoubleKey key) {
        if (!PRESET_DOUBLE_KEYS.contains(key)) {
            throw new IllegalArgumentException("Unsupported DoubleKey: " + String.valueOf(key));
        }
    }

    private static void requireAllowed(@NonNull StringKey key) {
        if (!PRESET_STRING_KEYS.contains(key)) {
            throw new IllegalArgumentException("Unsupported StringKey: " + String.valueOf(key));
        }
    }

    private static void requireAllowed(@NonNull ToolKey key) {
        if (!PRESET_TOOL_KEYS.contains(key)) {
            throw new IllegalArgumentException("Unsupported ToolKey: " + String.valueOf(key));
        }
    }

    public static void logBoolean(@NonNull BooleanKey key, boolean value) {
        if (CommonPreferences.allowAnalytics()) {
            LogAnalytics.requireAllowed(key);
            LoggerHolder.logBoolean(key, value);
        }
    }

    public static void logDouble(@NonNull DoubleKey key, double value) {
        if (CommonPreferences.allowAnalytics()) {
            LogAnalytics.requireAllowed(key);
            LoggerHolder.logDouble(key, value);
        }
    }

    public static void logString(@NonNull StringKey key, @NonNull String value) {
        if (CommonPreferences.allowAnalytics()) {
            LogAnalytics.requireAllowed(key);
            LoggerHolder.logString(key, value);
        }
    }

    public static void logStreamlineVersion(@NonNull ToolKey key, int major, int minor, int patch) {
        if (CommonPreferences.allowAnalytics()) {
            LogAnalytics.requireAllowed(key);
            LoggerHolder.logToolVersion(key, major, minor, patch);
        }
    }

    public static void closeSession() {
        LoggerHolder.close();
    }

    static void _setLoggerFactoryForTests(@NonNull Supplier<@Nullable AnalyticsLogger> factory) {
        LOGGER_FACTORY = factory;
    }

    static void _resetLoggerFactoryForTests() {
        LOGGER_FACTORY = LogAnalytics::makeDefaultLogger;
    }

    private static @Nullable AnalyticsLogger makeDefaultLogger() {
        String path = LogAnalytics.getCoreLibraryPath();
        if (path == null || path.isBlank()) {
            return null;
        }
        String parentPath = new File(path).getParent();
        if (parentPath == null || parentPath.isBlank()) {
            return null;
        }
        return new AnalyticsLogger(parentPath);
    }

    private static final class LoggerHolder {
        private static final @NonNull AtomicReference<@Nullable AnalyticsLogger> LOGGER = new AtomicReference<AnalyticsLogger>(LOGGER_FACTORY.get());

        private LoggerHolder() {
        }

        static void logBoolean(@NonNull BooleanKey key, boolean value) {
            AnalyticsLogger logger = LOGGER.get();
            if (logger != null) {
                logger.logBoolean(key, value);
            }
        }

        static void logDouble(@NonNull DoubleKey key, double value) {
            AnalyticsLogger logger = LOGGER.get();
            if (logger != null) {
                logger.logDouble(key, value);
            }
        }

        static void logString(@NonNull StringKey key, @NonNull String value) {
            AnalyticsLogger logger = LOGGER.get();
            if (logger != null) {
                logger.logString(key, value);
            }
        }

        static void logToolVersion(@NonNull ToolKey key, int major, int minor, int patch) {
            AnalyticsLogger logger = LOGGER.get();
            if (logger != null) {
                logger.logToolVersion(key, major, minor, patch);
            }
        }

        static void close() {
            AnalyticsLogger logger = LOGGER.getAndSet(null);
            if (logger != null) {
                logger.close();
            }
        }
    }

    static enum OS {
        WINDOWS,
        MAC,
        LINUX;

    }
}

