/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.session;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.elfdwarf.ElfDwarf;
import com.arm.streamline.analysis.gator.GatorCapturedRawXML;
import com.arm.streamline.analysis.gator.GatorCapturedXML;
import com.arm.streamline.analysis.gator.GatorLiveFrameCapturerThread;
import com.arm.streamline.analysis.gator.GatorProtocolVerifier;
import com.arm.streamline.analysis.gator.GatorProtocolVersionConstants;
import com.arm.streamline.analysis.gator.ICaptureDetails;
import com.arm.streamline.analysis.live.LiveGator;
import com.arm.streamline.analysis.live.LiveOnlyFrameProcessorPass;
import com.arm.streamline.analysis.live.LiveProtocolEventStream;
import com.arm.streamline.analysis.session.ImageTransfer;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.capture.apc.APCCapture;
import com.arm.streamline.capture.apc.APCDatabaseGenerator;
import com.arm.streamline.capture.apc.NoDataReceivedException;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.CaptureSubType;
import com.arm.streamline.common.model.ProtocolType;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.ProcessingElementReferenceSet;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.XMLParser;
import com.arm.streamline.common.xml.counters.Events;
import com.arm.streamline.counterconfig.model.CounterConfiguration;
import com.arm.streamline.counterconfig.model.CounterNames;
import com.arm.streamline.databrowser.DocumentScanner;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.databrowser.GatorSendCommandUtility;
import com.arm.streamline.databrowser.ICaptureProxy;
import com.arm.streamline.databrowser.ILiveCapture;
import com.arm.streamline.databrowser.ITarget;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.log.APCGatorLogCapturer;
import com.arm.streamline.log.APCGatorLogWriter;
import com.arm.streamline.log.IAPCGatorLogCapturer;
import com.arm.streamline.log.IAPCGatorLogWriter;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.live.LiveAllBinDataProvider;
import com.arm.streamline.model.live.LiveCaptureDataProvider;
import com.arm.streamline.model.live.LiveProcessDataProvider;
import com.arm.streamline.model.session.BufferMode;
import com.arm.streamline.model.session.SampleRate;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.protocol.capture.apc.io.APCCaptureFrameWriter;
import com.arm.streamline.protocol.capture.apc.io.APCLiveFrameCapturer;
import com.arm.streamline.protocol.capture.apc.io.DiscardingAPCCaptureFrameWriter;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameStream;
import com.arm.streamline.protocol.capture.apc.io.IAPCCaptureFrameWriter;
import com.arm.streamline.protocol.capture.apc.io.IAPCLiveFrameCapturer;
import com.arm.streamline.protocol.capture.apc.io.IAPCLiveFrameSource;
import com.arm.streamline.protocol.capture.apc.live.LiveAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IAPCPassOne;
import com.arm.streamline.protocol.capture.apc.pass_one.IPassOneGlobalStateNotificationCallbacks;
import com.arm.streamline.report.model.VariableReplacer;
import com.arm.streamline.report.model.topology.GatorClusters;
import com.arm.streamline.report.model.topology.IClustersInfo;
import com.arm.streamline.report.model.topology.XmlClustersInfo;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.io.StreamlineFileUtils;
import com.arm.utils.NullChecking;
import com.arm.utils.function.ICloseableThrowingRunnable;
import com.arm.utils.text.SWTLabelFilter;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LiveSessionProcessor
extends SessionProcessor {
    private boolean mDiscardLive = false;
    private LiveFrameProcessorThread frameProcessorThread;
    private GatorLiveFrameCapturerThread mGatorCapture;

    private static @NonNull ICloseableThrowingRunnable<IOException> createLiveFrameProcessorPass(boolean liveActive, boolean discard, boolean needImageDownloadForHeadless, boolean generateSpeSampleLog, @NonNull SessionProcessor sessionProcessor, @NonNull ICaptureDetails captureDetails, @NonNull File apcDirectory, @NonNull IClustersInfo clustersInfo, @NonNull IAPCCaptureFrameStream frameStream, @NonNull LiveProtocolEventStream liveProtocolEventStream, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks) {
        if (discard) {
            return new LiveOnlyFrameProcessorPass(captureDetails, frameStream, clustersInfo, liveProtocolEventStream, callbacks);
        }
        if (liveActive || needImageDownloadForHeadless) {
            return APCDatabaseGenerator.createLiveProcessor(frameStream, (IAPCPassOne)LiveSessionProcessor.createPassOne(captureDetails, clustersInfo, frameStream, liveProtocolEventStream, callbacks));
        }
        return APCDatabaseGenerator.createLiveProcessor(frameStream, null);
    }

    private static @NonNull LiveAPCPassOne createPassOne(@NonNull ICaptureDetails captureDetails, @NonNull IClustersInfo clustersInfo, @NonNull IAPCCaptureFrameStream frameStream, @NonNull LiveProtocolEventStream liveProtocolEventStream, @NonNull IPassOneGlobalStateNotificationCallbacks callbacks) {
        return new LiveOnlyFrameProcessorPass(captureDetails, frameStream, clustersInfo, liveProtocolEventStream, callbacks).createPassOne();
    }

    @Override
    public void cancel() {
        super.cancel();
        if (this.mGatorCapture != null) {
            this.mGatorCapture.interrupt();
        }
        if (this.frameProcessorThread != null) {
            this.frameProcessorThread.interrupt();
        }
    }

    public ILiveCapture collectAPC(@NonNull ICaptureProxy proxy, @NonNull ITarget target, @NonNull String capturePath, @NonNull Session session, @NonNull CounterConfiguration counterConfig, @Nullable ISshTargetLauncher sshTarget) throws Throwable {
        ILiveCapture capturedDocument;
        block84: {
            capturedDocument = null;
            File captureDirectory = null;
            this.mProxy = proxy;
            this.mErrorException = null;
            this.mDiscard = false;
            this.mStopRequested = false;
            boolean headless = WorkspaceUtils.isHeadless();
            VariableReplacer variableReplacer = new VariableReplacer();
            @NonNull IPreferences appSettings = StreamlinePreferences.getApplicationPreferences();
            try {
                LiveCaptureDataProvider liveData = null;
                try {
                    IPassOneGlobalStateNotificationCallbacks.IgnoreAll applicationTracingCallback;
                    GatorCapturedXML capturedXML;
                    Object out;
                    GatorCapturedRawXML capturedRawXML = target.getGatorCapturedRawXML();
                    capturedRawXML.setStreamlineVersion(GatorProtocolVersionConstants.CURRENT_RELEASED_VERSION);
                    byte[] eventsXML = target.getEventsXML();
                    Events events = Events.createWithAllEventsWithoutClusterInfo((InputStream)new ByteArrayInputStream(eventsXML), (boolean)false);
                    captureDirectory = new File(capturePath);
                    try {
                        DocumentScanner.INSTANCE.pause();
                        StreamlineFileUtils.deleteAsynchronously(captureDirectory);
                        if (!captureDirectory.mkdirs()) {
                            throw new Exception(MessageFormat.format(AnalysisMessages.FAILED_TO_CREATE_CAPTURE, capturePath));
                        }
                    }
                    finally {
                        DocumentScanner.INSTANCE.resume();
                    }
                    session.save(new File(capturePath + "/session.xml"));
                    capturedRawXML.save(new File(capturePath, "captured.xml"), false);
                    Throwable throwable = null;
                    Object var17_21 = null;
                    try {
                        out = new FileOutputStream(new File(capturePath, "events.xml"));
                        try {
                            ((FileOutputStream)out).write(eventsXML);
                        }
                        finally {
                            if (out != null) {
                                ((FileOutputStream)out).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    CounterNames counterNames = new CounterNames();
                    byte[] countersXML = target.getCountersXML();
                    out = null;
                    Object var19_25 = null;
                    try (FileOutputStream out2 = new FileOutputStream(new File(capturePath, "counters.xml"));){
                        out2.write(countersXML);
                    }
                    catch (Throwable throwable3) {
                        if (out == null) {
                            out = throwable3;
                        } else if (out != throwable3) {
                            ((Throwable)out).addSuppressed(throwable3);
                        }
                        throw out;
                    }
                    counterNames.load(new ByteArrayInputStream(countersXML));
                    GatorClusters gatorClusters = new GatorClusters(counterNames.getClusterNames(), counterNames.getCpuClusterIds());
                    GatorCapturedXML captured = capturedXML = new GatorCapturedXML(capturePath, CaptureSubType.DEFAULT, GatorProtocolVerifier.LIVE_EXCEPTION_FACTORY, events.getStockCounterMap(), events.getAvailableSpeTargetDescriptions(), counterNames.hasArmNNCounters());
                    GatorCapturedXML agentCapabilities = capturedXML;
                    if (session.isEfficientFtraceEnabled() && !agentCapabilities.supportsEfficientFtrace()) {
                        session.setEfficientFtrace(false);
                        WarningItem warning = new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.MEDIUM, AnalysisMessages.EFFICIENT_FTRACE_NOT_SUPPORTED_TITLE, AnalysisMessages.EFFICIENT_FTRACE_NOT_SUPPORTED);
                        proxy.liveWarning(warning);
                        this.warning(warning);
                    }
                    File sessionPath = new File(capturePath + "/session.xml");
                    session.save(sessionPath);
                    @NonNull List<@NonNull CounterRecord> counterRecordList = captured.getCounterList();
                    @NonNull XmlClustersInfo clustersInfo = new XmlClustersInfo(gatorClusters, (List)counterNames, captured.getNumberOfCores());
                    clustersInfo.updateCounterRecordsWithClusterInformation(counterRecordList);
                    variableReplacer.createClusterVariables((IClustersInfo)clustersInfo);
                    GatorCapturedXML.checkCounterAliasesDuplicates(counterRecordList);
                    if (!session.getCaptureCommand().isEmpty() && !agentCapabilities.supportsCaptureCommand()) {
                        WarningItem warning = new WarningItem(WarningType.GATOR_PROTOCOL, WarningSeverity.MEDIUM, AnalysisMessages.CAPTURE_COMMAND_NOT_SUPPORTED_TITLE, AnalysisMessages.CAPTURE_COMMAND_NOT_SUPPORTED);
                        proxy.liveWarning(warning);
                        this.warning(warning);
                    }
                    boolean liveError = false;
                    if (!agentCapabilities.supportsLive()) {
                        if (session.getBufferMode() != BufferMode.STREAMING) {
                            proxy.liveError(AnalysisMessages.LIVE_NON_STREAMING_ERROR);
                        } else if (session.getSampleRate() == SampleRate.NONE) {
                            proxy.liveError(AnalysisMessages.LIVE_NO_SAMPLE_RATE_ERROR);
                        } else {
                            proxy.liveError(AnalysisMessages.LIVE_UNSUPPORTED);
                        }
                        liveError = true;
                    }
                    boolean liveActive = !liveError && !headless;
                    this.mMainThread = Thread.currentThread();
                    try {
                        Thread.currentThread().setName("Main thread for " + FilePath.getLeafName((String)capturePath));
                    }
                    catch (Exception exception) {
                        this.error(exception);
                    }
                    this.checkError();
                    this.mDiscard = session.isDiscardEnabled();
                    if (liveError && this.mDiscard) {
                        this.error(new Exception(SWTLabelFilter.filterForMenuOrLabel((String)AnalysisMessages.NO_LIVE_AND_DISCARD)));
                    }
                    @NonNull ProcessingElementReferenceSet processingElements = new ProcessingElementReferenceSet(0L, captured.getNumberOfCores());
                    @NonNull IntSupplier dynamicKeySupplier = LiveSessionProcessor.getDynamicKeySupplier();
                    if (liveActive) {
                        LiveCaptureDataProvider localLiveData;
                        TIntHashSet warnedMissingchartKeys = new TIntHashSet(10, 0.5f, -1);
                        @NonNull LiveProcessDataProvider liveModelProc = new LiveProcessDataProvider();
                        @NonNull LiveAllBinDataProvider allBinDataProvider = new LiveAllBinDataProvider(dynamicKeySupplier, captured.getNumberOfCores(), session.getDurationLimitInSecs(), session.isDiscardEnabled(), variableReplacer, liveModelProc, processingElements, (TIntSet)warnedMissingchartKeys);
                        this.mLive = new LiveGator(allBinDataProvider, liveModelProc, counterRecordList, captured, session, agentCapabilities, (IClustersInfo)clustersInfo, (TIntSet)warnedMissingchartKeys);
                        liveData = localLiveData = new LiveCaptureDataProvider(session, allBinDataProvider, liveModelProc, captured, agentCapabilities, variableReplacer, (IClustersInfo)clustersInfo, counterConfig, processingElements);
                        applicationTracingCallback = new IPassOneGlobalStateNotificationCallbacks.IgnoreAll(){

                            public void notifyApplicationTracingMode(long vmUID, boolean applicationTracingMode) throws IOException {
                                localLiveData.notifyApplicationTracingMode(vmUID, applicationTracingMode);
                            }
                        };
                        this.checkError();
                    } else {
                        applicationTracingCallback = new IPassOneGlobalStateNotificationCallbacks.IgnoreAll();
                    }
                    this.mCaptureInProgress = new CountDownLatch(1);
                    ProtocolType type = captured.getProtocolInfo().getType();
                    switch (type) {
                        case PERF: {
                            break;
                        }
                        default: {
                            throw new IOException("Unsupported protocol type: " + String.valueOf(type));
                        }
                    }
                    if (session.isCaptureLogFileEnabled()) {
                        APCGatorLogWriter gatorWriter = new APCGatorLogWriter(new File(capturePath));
                        APCGatorLogCapturer gatorLogCapturer = new APCGatorLogCapturer((IAPCGatorLogWriter)gatorWriter, new BooleanSupplier(){

                            @Override
                            public boolean getAsBoolean() {
                                return LiveSessionProcessor.this.isDiscard();
                            }
                        });
                        target.addLogDataCapturer((IAPCGatorLogCapturer)gatorLogCapturer);
                    }
                    @NonNull DiscardingAPCCaptureFrameWriter frameWriter = this.mDiscard ? new DiscardingAPCCaptureFrameWriter() : new APCCaptureFrameWriter(captureDirectory);
                    APCLiveFrameCapturer liveCapturer = new APCLiveFrameCapturer((IAPCLiveFrameSource)target, (IAPCCaptureFrameWriter)frameWriter, (byte[][])new byte[0][]);
                    this.mGatorCapture = new GatorLiveFrameCapturerThread(this, target, (IAPCLiveFrameCapturer)liveCapturer);
                    this.mGatorCapture.start();
                    this.checkError();
                    this.mElfDwarf = new ElfDwarf(new File(capturePath), Set.of(), session.isParseDebugInfoEnabled(), (IAnalysisHandler)this, true);
                    this.checkError();
                    LiveProtocolEventStream liveProtocolEventStream = new LiveProtocolEventStream(captured.getCounterList(), dynamicKeySupplier, (ICaptureProxy)NullChecking.neverNull((Object)this.mProxy), this.mLive);
                    IPassOneGlobalStateNotificationCallbacks callbacks = IPassOneGlobalStateNotificationCallbacks.allOf((IPassOneGlobalStateNotificationCallbacks[])new IPassOneGlobalStateNotificationCallbacks[]{applicationTracingCallback});
                    boolean canDownloadImage = !this.mDiscard && agentCapabilities.supportsRetrieveImage(session.getTargetAddress());
                    this.frameProcessorThread = new LiveFrameProcessorThread(this, LiveSessionProcessor.createLiveFrameProcessorPass(liveActive, this.mDiscard, headless && canDownloadImage && session.getRetrieveImageRegex() != null, session.isGenerateSpeSampleLogEnabled(), this, captured, captureDirectory, (IClustersInfo)clustersInfo, (IAPCCaptureFrameStream)liveCapturer, liveProtocolEventStream, callbacks), this::discard);
                    this.checkError();
                    capturedDocument = new APCCapture(new File(capturePath));
                    capturedDocument.setStopHandler(this, DocumentScanner.INSTANCE);
                    capturedDocument.setAsPlaceholder();
                    this.checkError();
                    proxy.captureStarted(capturedDocument, liveData, appSettings, this.mDiscard);
                    this.checkError();
                    if (canDownloadImage) {
                        @NonNull Set<ElfImage> defaultImages = StreamlinePreferences.getDefaultImages();
                        this.mImageTransfer = new ImageTransfer(this, liveProtocolEventStream, (ILiveProcessDataProvider)NullChecking.applyIfNonNull((Object)liveData, LiveCaptureDataProvider::getProcessDataProvider), session, new File(capturePath), sessionPath, headless, appSettings, defaultImages, sshTarget);
                    }
                    this.join();
                    if (this.mDiscard) {
                        throw new InterruptedException();
                    }
                }
                catch (InterruptedException capturedRawXML) {
                    this.cancel();
                    Thread.interrupted();
                    this.join();
                    if (liveData != null) {
                        liveData.dispose();
                    }
                    if (capturePath != null && this.mErrorException != null && !this.mDiscard) {
                        try {
                            File file = new File(capturePath, "captured.xml");
                            GatorCapturedRawXML capturedXML = GatorCapturedRawXML.read(XMLParser.create((File)file));
                            String message = this.mErrorException.getMessage();
                            if (message == null || message.length() == 0) {
                                message = this.mErrorException.toString();
                            }
                            capturedXML.setError(message);
                            capturedXML.save(file, false);
                        }
                        catch (Exception file) {
                            // empty catch block
                        }
                    }
                    if (capturedDocument != null) {
                        capturedDocument.convertPlaceholderToFinal();
                        capturedDocument.setStopHandler(null, DocumentScanner.INSTANCE);
                    }
                    if (this.mErrorException == null && !this.mDiscard) {
                        this.writeAPCWarningsXMLFile(capturePath);
                    }
                    if (capturedDocument != null) {
                        proxy.captureStopped(capturedDocument, this.mDiscard);
                    }
                    this.mDone = true;
                    if (this.mErrorException != null) {
                        throw this.mErrorException;
                    }
                    break block84;
                }
                catch (Throwable e) {
                    try {
                        this.error(e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        this.cancel();
                        Thread.interrupted();
                        this.join();
                        if (liveData != null) {
                            liveData.dispose();
                        }
                        if (capturePath != null && this.mErrorException != null && !this.mDiscard) {
                            try {
                                File file = new File(capturePath, "captured.xml");
                                GatorCapturedRawXML capturedXML = GatorCapturedRawXML.read(XMLParser.create((File)file));
                                String message = this.mErrorException.getMessage();
                                if (message == null || message.length() == 0) {
                                    message = this.mErrorException.toString();
                                }
                                capturedXML.setError(message);
                                capturedXML.save(file, false);
                            }
                            catch (Exception file) {}
                        }
                        if (capturedDocument != null) {
                            capturedDocument.convertPlaceholderToFinal();
                            capturedDocument.setStopHandler(null, DocumentScanner.INSTANCE);
                        }
                        if (this.mErrorException == null && !this.mDiscard) {
                            this.writeAPCWarningsXMLFile(capturePath);
                        }
                        if (capturedDocument != null) {
                            proxy.captureStopped(capturedDocument, this.mDiscard);
                        }
                        this.mDone = true;
                        if (this.mErrorException != null) {
                            throw this.mErrorException;
                        }
                        break block84;
                    }
                }
                this.cancel();
                Thread.interrupted();
                this.join();
                if (liveData != null) {
                    liveData.dispose();
                }
                if (capturePath != null && this.mErrorException != null && !this.mDiscard) {
                    try {
                        File file = new File(capturePath, "captured.xml");
                        GatorCapturedRawXML capturedXML = GatorCapturedRawXML.read(XMLParser.create((File)file));
                        String message = this.mErrorException.getMessage();
                        if (message == null || message.length() == 0) {
                            message = this.mErrorException.toString();
                        }
                        capturedXML.setError(message);
                        capturedXML.save(file, false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (capturedDocument != null) {
                    capturedDocument.convertPlaceholderToFinal();
                    capturedDocument.setStopHandler(null, DocumentScanner.INSTANCE);
                }
                if (this.mErrorException == null && !this.mDiscard) {
                    this.writeAPCWarningsXMLFile(capturePath);
                }
                if (capturedDocument != null) {
                    proxy.captureStopped(capturedDocument, this.mDiscard);
                }
                this.mDone = true;
                if (this.mErrorException != null) {
                    throw this.mErrorException;
                }
            }
            finally {
                if (this.mDiscardLive || session.isDiscardEnabled()) {
                    StreamlineFileUtils.deleteAsynchronously(new File(capturePath));
                }
                if (this.mCaptureInProgress != null) {
                    this.mCaptureInProgress.countDown();
                    this.mCaptureInProgress = null;
                }
            }
        }
        return this.mDiscard ? null : capturedDocument;
    }

    public static @NonNull IntSupplier getDynamicKeySupplier() {
        return new IntSupplier(){
            private final @NonNull AtomicInteger keySupplier = new AtomicInteger(0x40000000);

            @Override
            public int getAsInt() {
                return this.keySupplier.getAndIncrement();
            }
        };
    }

    @Override
    public void discard() {
        this.mDiscard = true;
        this.mDiscardLive = true;
        if (this.requestStop()) {
            this.waitLive();
        }
        this.cancel();
    }

    @Override
    public void stop() {
        if (this.mProxy != null) {
            this.mProxy.stopLiveRequestSend();
        }
        if (!this.requestStop()) {
            super.discard();
        }
    }

    @Override
    protected void close() throws IOException {
        if (this.mGatorCapture != null) {
            this.mGatorCapture.close();
            this.mGatorCapture = null;
        }
        if (this.frameProcessorThread != null) {
            this.frameProcessorThread.close();
            this.frameProcessorThread = null;
        }
        super.close();
    }

    @Override
    protected synchronized void join() {
        if (this.mGatorCapture != null) {
            this.mGatorCapture.join();
        }
        if (this.frameProcessorThread != null) {
            this.frameProcessorThread.join();
        }
        super.join();
    }

    @Override
    protected void waitLive() {
        if (this.mGatorCapture != null) {
            this.mGatorCapture.join();
        }
    }

    @Override
    public void error(Throwable ex) {
        if (this.mProxy != null && ex instanceof GatorSendCommandUtility.GatorStartingActivityManagerException) {
            this.mProxy.stopLiveRequestSend();
        }
        super.error(ex);
    }

    private boolean requestStop() {
        if (this.mGatorCapture != null && !this.mStopRequested) {
            this.mGatorCapture.stop();
            this.mStopRequested = true;
            return true;
        }
        return false;
    }

    private final class LiveFrameProcessorThread
    extends AnalysisBase {
        private final @NonNull ICloseableThrowingRunnable<IOException> runnable;
        private final @NonNull Runnable discardCallback;

        public LiveFrameProcessorThread(@NonNull IAnalysisHandler ah, @NonNull ICloseableThrowingRunnable<IOException> runnable, Runnable discardCallback) {
            super(ah);
            this.runnable = runnable;
            this.discardCallback = discardCallback;
            this.setName("Live Frame Processor", "");
            this.setPriorityLower();
            this.start();
        }

        @Override
        protected void process() {
            try {
                try {
                    this.runnable.run();
                }
                catch (NoDataReceivedException e) {
                    this.discardCallback.run();
                    try {
                        this.runnable.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    LiveSessionProcessor.this.captureStopped();
                }
                catch (Exception e) {
                    this.error(e);
                    try {
                        this.runnable.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    LiveSessionProcessor.this.captureStopped();
                }
            }
            finally {
                try {
                    this.runnable.close();
                }
                catch (IOException iOException) {}
                LiveSessionProcessor.this.captureStopped();
            }
        }
    }
}

