/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.session;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.elfdwarf.ElfDwarf;
import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.analysis.session.IImageTransferCaptureDataSource;
import com.arm.streamline.analysis.session.ImageSelectionDialog;
import com.arm.streamline.analysis.session.SessionMessages;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.application.preferences.IPreferences;
import com.arm.streamline.application.preferences.StreamlinePreferences;
import com.arm.streamline.authentication.TargetAuthentication;
import com.arm.streamline.authentication.TargetAuthenticationConfig;
import com.arm.streamline.common.CommonPlugin;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.databrowser.ElfImage;
import com.arm.streamline.jni.common.CodecException;
import com.arm.streamline.jni.common.NativeException;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.jni.elfdwarf.ElfDwarfParser;
import com.arm.streamline.jni.elfdwarf.SeparateDwarfInfo;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.session.Session;
import com.arm.streamline.model.session.SessionImage;
import com.arm.streamline.ui.vm.ISshTargetLauncher;
import com.arm.streamline.utility.target.CredentialsAddress;
import com.arm.streamline.utility.target.ICredentials;
import com.arm.streamline.utility.target.IRemoteTransfer;
import com.arm.streamline.utility.target.SimpleCredentials;
import com.arm.streamline.utility.target.TargetCredentials;
import com.arm.streamline.utility.text.TextFilter;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import com.arm.utils.text.BasicTextFilter;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ImageTransfer
extends AnalysisBase {
    public static final String HELP_ID = "com.arm.streamline.fetch_images_dialog";
    private @NonNull Set<ElfImage> defaultImages;
    private final @NonNull File capturePath;
    private boolean mHeadless;
    private final @NonNull Set<@NonNull String> preLoadedImages = new HashSet<String>();
    private final @NonNull Session session;
    private final @NonNull File sessionPath;
    private final @NonNull SessionProcessor sessionProcessor;
    private final @Nullable ILiveProcessDataProvider liveProcessDataProvider;
    private final @NonNull IPreferences appSettings;
    private final @NonNull IImageTransferCaptureDataSource captureDataSource;
    private final @Nullable ISshTargetLauncher sshTarget;

    private static String getName(String fullPath) {
        if (fullPath == null) {
            return null;
        }
        int slashPos = fullPath.lastIndexOf(47);
        if (slashPos == -1) {
            return null;
        }
        return fullPath.substring(slashPos + 1);
    }

    public ImageTransfer(@NonNull SessionProcessor handler, @NonNull IImageTransferCaptureDataSource captureDataSource, @Nullable ILiveProcessDataProvider liveProcessDataProvider, @NonNull Session session, @NonNull File capturePath, @NonNull File sessionPath, boolean headless, @NonNull IPreferences appSettings, @NonNull Set<ElfImage> defaultImages, @Nullable ISshTargetLauncher sshTarget) {
        super(handler);
        this.appSettings = appSettings;
        this.captureDataSource = captureDataSource;
        this.defaultImages = defaultImages;
        this.liveProcessDataProvider = liveProcessDataProvider;
        this.sessionProcessor = handler;
        this.session = session;
        this.capturePath = capturePath;
        this.sessionPath = sessionPath;
        this.sshTarget = sshTarget;
        this.mHeadless = headless;
        this.setName("ImageTransfer", capturePath.getAbsolutePath());
        this.setPriorityLower();
        this.start();
    }

    @Override
    protected void process() {
        this.sessionProcessor.waitUntilCaptureStops();
        if (!this.sessionProcessor.hasValidCapture()) {
            return;
        }
        File imagesDir = new File(this.capturePath, "images");
        File debugSymbolsDir = new File(imagesDir, "debug-files");
        try {
            CommonFileUtils.makeDirectory((File)debugSymbolsDir);
        }
        catch (IOException exception1) {
            exception1.printStackTrace();
        }
        @NonNull TreeSet<@NonNull ImageSelectionDialog.ImageToDownload> imagesToDownload = new TreeSet<ImageSelectionDialog.ImageToDownload>();
        @Nullable ILiveProcessDataProvider liveProcessDataProvider = this.liveProcessDataProvider;
        if (!this.mHeadless && liveProcessDataProvider != null && ImageSelectionDialog.hasProcesses(liveProcessDataProvider) && StreamlinePreferences.getRetrieveImages()) {
            Display display = Display.getDefault();
            display.syncExec(() -> {
                Shell shell = display.getActiveShell();
                ImageSelectionDialog dialog = new ImageSelectionDialog(shell, this.captureDataSource, liveProcessDataProvider, imagesToDownload);
                int result = dialog.open();
                if (result != 0) {
                    imagesToDownload.clear();
                }
            });
        }
        ImageTransferJob job = new ImageTransferJob(imagesDir, imagesToDownload, debugSymbolsDir);
        job.setUser(true);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException exception) {
            exception.printStackTrace();
        }
    }

    private boolean addImageFile(@Nullable String fullPath, @NonNull Set<@NonNull ImageSelectionDialog.ImageToDownload> fullPathMatches, @NonNull Set<@NonNull String> imageMatches) {
        if (fullPath == null || BasicTextFilter.isEmpty((String)fullPath) || "//anon".equals(fullPath)) {
            return false;
        }
        String name = ImageTransfer.getName(fullPath);
        if (name == null) {
            return false;
        }
        if (!this.preLoadedImages.contains(name) && !imageMatches.contains(name)) {
            fullPathMatches.add(new ImageSelectionDialog.ImageToDownload(fullPath));
            imageMatches.add(name);
        }
        return true;
    }

    private void findImagesForDownloadInHeadless(boolean fetchLibs, @NonNull Set<@NonNull ImageSelectionDialog.ImageToDownload> fullPathMatches, @NonNull Pattern pattern) {
        Map<IUniqueThread, IExecutablePath> processExecutablePaths = this.captureDataSource.getAllProcessExecutables();
        Map<IUniqueThread, Set<IExecutablePath>> processLibraryPaths = this.captureDataSource.getAllProcessImages();
        HashSet<String> imageMatches = new HashSet<String>();
        ArrayList<String> failedCookies = new ArrayList<String>();
        for (Map.Entry<IUniqueThread, IExecutablePath> entry : processExecutablePaths.entrySet()) {
            String imagePath;
            IUniqueThread process = entry.getKey();
            IExecutablePath executablePath = entry.getValue();
            if (executablePath.getType() != IExecutablePath.Type.FILE_OR_ZIP || BasicTextFilter.isEmpty((String)(imagePath = entry.getValue().getFullPath())) || !pattern.matcher(imagePath).find()) continue;
            Set<IExecutablePath> processLibraries = processLibraryPaths.get(process);
            boolean addedImage = executablePath.isAbstractPath() ? this.addApkName(process.getName(), imagePath, processLibraries, fullPathMatches, imageMatches) : this.addImageFile(imagePath, fullPathMatches, imageMatches);
            if (addedImage) {
                if (!fetchLibs || processLibraries == null) continue;
                for (IExecutablePath path : processLibraries) {
                    String libPath;
                    if (path.isAbstractPath() || this.addImageFile(libPath = path.getFullPath(), fullPathMatches, imageMatches)) continue;
                    failedCookies.add(libPath);
                }
                continue;
            }
            failedCookies.add(imagePath);
        }
        if (!failedCookies.isEmpty()) {
            WarningItem item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.RETRIEVE_IMAGE_ERROR, MessageFormat.format(AnalysisMessages.NO_IMAGES_FOR, failedCookies));
            this.warning(item);
        }
    }

    private boolean addApkName(@Nullable String processName, @NonNull String imagePath, @Nullable Set<@NonNull IExecutablePath> processLibraries, @NonNull Set<@NonNull ImageSelectionDialog.ImageToDownload> fullPathMatches, @NonNull Set<@NonNull String> imageMatches) {
        if (processName == null || processLibraries == null) {
            return false;
        }
        boolean result = false;
        for (IExecutablePath library : processLibraries) {
            String pkg;
            if (library.isAbstractPath() || ((pkg = library.extractAndroidPackageName()) == null || !pkg.contentEquals(processName) && !pkg.contentEquals(imagePath)) && !processName.contentEquals(library.getBaseName()) && !imagePath.contentEquals(library.getBaseName()) && !library.getBaseName().endsWith(".apk")) continue;
            result |= this.addImageFile(library.getFullPath(), fullPathMatches, imageMatches);
        }
        return result;
    }

    class ImageTransferJob
    extends Job {
        final @NonNull File debugSymbolsDir;
        final @NonNull File imagesDir;
        final @NonNull Set<@NonNull ImageSelectionDialog.ImageToDownload> imagesToDownload;

        public ImageTransferJob(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull @NonNull File imagesDir, @NonNull Set<ImageSelectionDialog.ImageToDownload> imagesToDownload, File debugSymbolsDir) {
            super(SessionMessages.DIALOG_TITLE);
            this.imagesDir = imagesDir;
            this.imagesToDownload = imagesToDownload;
            this.debugSymbolsDir = debugSymbolsDir;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set<ImageSelectionDialog.ImageToDownload> fullPathMatches;
            block38: {
                block33: {
                    Pattern pattern;
                    boolean fetchLibs;
                    String regex;
                    block34: {
                        int numImagesToCopy = ImageTransfer.this.defaultImages.size() + this.imagesToDownload.size();
                        monitor.beginTask(SessionMessages.TASK_COPYING_DEFAULT_IMAGES, numImagesToCopy);
                        Iterator<ElfImage> iterator = ImageTransfer.this.defaultImages.iterator();
                        do {
                            WarningItem item;
                            if (!iterator.hasNext()) {
                                if (!ImageTransfer.this.mHeadless) break block33;
                                fullPathMatches = new HashSet<ImageSelectionDialog.ImageToDownload>();
                                regex = ImageTransfer.this.session.getRetrieveImageRegex();
                                fetchLibs = ImageTransfer.this.session.isRetrieveLibraries();
                                if (regex == null) return Status.OK_STATUS;
                                if (regex.isEmpty()) {
                                    return Status.OK_STATUS;
                                }
                                break block34;
                            }
                            ElfImage image = iterator.next();
                            try {
                                monitor.subTask(image.getName());
                                CommonFileUtils.copyFile((File)image.getFile(), (File)new File(this.imagesDir, image.getName()));
                                ImageTransfer.this.preLoadedImages.add(image.getFile().getName());
                                image.processFile();
                                if (image.getSeparateDebugFile() != null) {
                                    CommonFileUtils.copyFile((File)image.getSeparateDebugFile(), (File)new File(this.debugSymbolsDir, image.getName()));
                                }
                            }
                            catch (CodecException | NativeException exception) {
                                item = new WarningItem(WarningType.ELF_DWARF, WarningSeverity.HIGH, AnalysisMessages.ELF_DWARF_WARNING, image.getName());
                                ImageTransfer.this.warning(item);
                            }
                            catch (IOException | InterruptedException exception) {
                                item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.COPY_IMAGE_ERROR, image.getName());
                                ImageTransfer.this.warning(item);
                            }
                            monitor.worked(1);
                        } while (!monitor.isCanceled());
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        pattern = Pattern.compile(TextFilter.enableCaseInsensitivityIfNoDirectivesPresent(regex));
                        ImageTransfer.this.captureDataSource.waitUntilAllDataIsProcessed();
                    }
                    catch (InterruptedException | PatternSyntaxException exception) {
                        return Status.CANCEL_STATUS;
                    }
                    ImageTransfer.this.findImagesForDownloadInHeadless(fetchLibs, fullPathMatches, pattern);
                    break block38;
                }
                fullPathMatches = this.imagesToDownload;
            }
            monitor.setTaskName(SessionMessages.TASK_DOWNLOADING_FROM_TARGET);
            if (fullPathMatches.size() > 0) {
                try {
                    int n;
                    int n2;
                    ElfDwarf[] elfDwarfArray;
                    block35: {
                        ICredentials credentials;
                        TargetAuthentication authentication = null;
                        if (ImageTransfer.this.mHeadless) {
                            credentials = ImageTransfer.this.session.getCommandlineCredentials();
                        } else if (ImageTransfer.this.session.getTargetAddress().isAndroid()) {
                            credentials = new SimpleCredentials(new CredentialsAddress(ImageTransfer.this.session.getTargetAddress()), null, null, null, null, 0);
                        } else {
                            ISshTargetLauncher ssh = ImageTransfer.this.sshTarget;
                            TargetAuthenticationConfig authenticationConfig = TargetAuthenticationConfig.createForImageExtraction(ImageTransfer.this.appSettings.getAdbPathOrDefault());
                            if (ssh == null) {
                                authentication = TargetAuthentication.getFromCacheOrCreate(new CredentialsAddress(ImageTransfer.this.session.getTargetAddress()), authenticationConfig, true);
                                if (authentication == null) {
                                    return Status.CANCEL_STATUS;
                                }
                            } else {
                                authentication = TargetAuthentication.fromSSHTargetLauncher(ssh);
                            }
                            credentials = new TargetCredentials(authentication, authenticationConfig, true);
                        }
                        CommonFileUtils.makeDirectory((File)this.imagesDir);
                        int index = 0;
                        ElfDwarf[] threads = new ElfDwarf[fullPathMatches.size()];
                        HashSet<@NonNull File> imagesForAnalysis = new HashSet<File>();
                        Throwable throwable = null;
                        Object var10_20 = null;
                        try {
                            IRemoteTransfer remoteTransfer = IRemoteTransfer.construct(credentials, ImageTransfer.this.appSettings.getAdbPathOrDefault(), monitor);
                            try {
                                for (ImageSelectionDialog.ImageToDownload imageToDownload : fullPathMatches) {
                                    monitor.subTask(imageToDownload.path);
                                    boolean needsApkChange = false;
                                    if (imageToDownload.path.contains("base.apk")) {
                                        needsApkChange = true;
                                    }
                                    index = this.transferOneImage(remoteTransfer, imagesForAnalysis, threads, index, imageToDownload.path, needsApkChange);
                                    monitor.worked(1);
                                    if (!monitor.isCanceled()) continue;
                                }
                                if (remoteTransfer == null) break block35;
                            }
                            catch (Throwable throwable2) {
                                if (remoteTransfer == null) throw throwable2;
                                remoteTransfer.close();
                                throw throwable2;
                            }
                            remoteTransfer.close();
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                                throw throwable;
                            }
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                            throw throwable;
                        }
                        finally {
                            elfDwarfArray = threads;
                            n2 = threads.length;
                            n = 0;
                            break;
                        }
                    }
                    while (true) {
                        if (n >= n2) {
                            ImageTransfer.this.session.save(ImageTransfer.this.sessionPath);
                            break;
                        }
                        ElfDwarf thread = elfDwarfArray[n];
                        if (thread != null) {
                            thread.join();
                        }
                        ++n;
                    }
                }
                catch (EOFException | InterruptedIOException authentication) {
                }
                catch (Exception e) {
                    WarningItem item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.RETRIEVE_IMAGE_ERROR, (String)NullChecking.neverNullOr((Object)e.getMessage(), (Object)""));
                    ImageTransfer.this.warning(item);
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        private int transferOneImage(@NonNull IRemoteTransfer remoteTransfer, @NonNull Set<@NonNull File> imagesForAnalysis, ElfDwarf @NonNull [] threads, int index, @NonNull String path, boolean needsApkChange) {
            block20: {
                try {
                    @Nullable File copiedImageFile = remoteTransfer.copy(path, this.imagesDir);
                    if (copiedImageFile == null || !copiedImageFile.isFile() || copiedImageFile.length() == 0L) {
                        WarningItem item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.RETRIEVE_IMAGE_ERROR, path);
                        ImageTransfer.this.warning(item);
                        return index;
                    }
                    if (needsApkChange) {
                        String baseName = "base.apk";
                        File parent = new File(path).getParentFile();
                        if (parent != null) {
                            String parentPath = parent.getName();
                            String[] pathSplit = parentPath.split("-");
                            String trueApkName = pathSplit[0] + ".apk";
                            if (pathSplit.length == 1) {
                                String message = "True apk name could not be parsed from the parent directory of image, apk will be saved as: " + trueApkName;
                                CommonPlugin.warning((String)message);
                            }
                            Path imageFilePath = Paths.get(this.imagesDir.toString(), baseName);
                            Files.move(imageFilePath, imageFilePath.resolveSibling(trueApkName), new CopyOption[0]);
                            copiedImageFile = new File(imageFilePath.resolveSibling(trueApkName).toString());
                        } else {
                            String message = "Couldn't find a parent directory for image to establish correct apk name, image will be saved as base.apk";
                            CommonPlugin.warning((String)message);
                        }
                    }
                    @NonNull File fullPathFile = new File(path);
                    @NonNull String srcImageName = (String)NullChecking.neverNull((Object)copiedImageFile.getName());
                    if (!copiedImageFile.isFile() || copiedImageFile.length() == 0L) {
                        throw new Exception(AnalysisMessages.RETRIEVE_IMAGE_CHECK_CREDENTIALS);
                    }
                    imagesForAnalysis.add(copiedImageFile);
                    if (FileUtils.isElfFile((File)copiedImageFile)) {
                        @NonNull SeparateDwarfInfo separateDwarfInfo = ElfDwarfParser.getSeparatedDwarfInfo((File)copiedImageFile);
                        if (separateDwarfInfo.getGnuDebugLinkInfo() != null) {
                            @NonNull File srcImageDir = (File)NullChecking.neverNull((Object)fullPathFile.getParentFile());
                            @NonNull String debugFileName = (String)NullChecking.neverNull((Object)separateDwarfInfo.getGnuDebugLinkInfo());
                            @NonNull File destination = new File(this.debugSymbolsDir, debugFileName);
                            if (!destination.exists()) {
                                @NonNull String @NonNull [] potentialLocations = ElfDwarfParser.getPossibleDebugDataLocations((File)srcImageDir, (String)srcImageName, (SeparateDwarfInfo)separateDwarfInfo);
                                boolean copied = true;
                                String[] stringArray = potentialLocations;
                                int n = potentialLocations.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String location = stringArray[n2];
                                    try {
                                        if (remoteTransfer.copy(location, destination) == null) {
                                            copied = false;
                                            break;
                                        }
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                    ++n2;
                                }
                                if (!copied) {
                                    WarningItem item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.RETRIEVE_IMAGE_ERROR, MessageFormat.format(AnalysisMessages.NO_SPLIT_DEBUG_FOR, debugFileName, path));
                                    ImageTransfer.this.warning(item);
                                }
                            }
                        }
                        threads[index++] = new ElfDwarf(ImageTransfer.this.capturePath, Set.of(copiedImageFile.getName()), ImageTransfer.this.session.isParseDebugInfoEnabled(), (IAnalysisHandler)ImageTransfer.this.sessionProcessor, true);
                        ImageTransfer.this.session.getImages().add(new SessionImage(srcImageName, true));
                        break block20;
                    }
                    if (FileUtils.isZipFile((File)copiedImageFile)) {
                        threads[index++] = new ElfDwarf(ImageTransfer.this.capturePath, Set.of(copiedImageFile.getName()), ImageTransfer.this.session.isParseDebugInfoEnabled(), (IAnalysisHandler)ImageTransfer.this.sessionProcessor, true);
                        ImageTransfer.this.session.getImages().add(new SessionImage(srcImageName, true));
                    }
                }
                catch (Exception e) {
                    Object message = e.getMessage();
                    if (message == null) {
                        message = path;
                    } else if (!((String)message).contains(path)) {
                        message = path + " : " + (String)message;
                    }
                    WarningItem item = new WarningItem(WarningType.RETRIEVE_IMAGE, WarningSeverity.HIGH, AnalysisMessages.RETRIEVE_IMAGE_ERROR, (String)message);
                    ImageTransfer.this.warning(item);
                }
            }
            return index;
        }
    }
}

