/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.session;

import com.arm.streamline.analysis.model.threads.IExecutablePath;
import com.arm.streamline.analysis.model.threads.IUniqueThread;
import com.arm.streamline.analysis.session.IImageTransferCaptureDataSource;
import com.arm.streamline.analysis.session.SessionMessages;
import com.arm.streamline.application.StreamlinePlugin;
import com.arm.streamline.databrowser.DocumentsMessages;
import com.arm.streamline.editortabs.timeline.common.process.ProcessMessages;
import com.arm.streamline.model.capture.IProcessDataProvider;
import com.arm.streamline.model.live.ILiveProcessDataProvider;
import com.arm.streamline.model.timeline.ProcessData;
import com.arm.streamline.utility.io.Images;
import com.arm.utils.NullChecking;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class ImageSelectionDialog
extends TitleAreaDialog {
    private static final int DUPLICATE_COLUMN_WIDTH = 25;
    private final @NonNull Image addProcessAndDepsImage;
    private final @NonNull Image addProcessImage;
    private final @NonNull Set<@NonNull ImageToDownload> imagesToDownload;
    private Text mFilterText;
    private @Nullable Button okButton;
    private final @NonNull ProcessComparator processComparator;
    private final @NonNull Image removeImageImage;
    private TableColumn tableColumnProcessId;
    private TableColumn tableColumnProcessName;
    private TableColumn tableColumnDuplicates;
    private Table tableImages;
    private Table tableProcesses;
    private TableViewer tableViewerImages;
    private TableViewer tableViewerProcesses;
    final @NonNull ILiveProcessDataProvider processDataProvider;
    final @NonNull Image processImage;
    private final @NonNull IImageTransferCaptureDataSource captureDataSource;
    private ToolItem buttonRemoveAllDuplicates;
    private @NonNull IObservableValue<@NonNull Boolean> isImageDownloadValid;
    private final @NonNull DataBindingContext bindingContext;

    private static void addMenuItem(Menu contextMenu, Image image, String text, final @NonNull MenuItemAction action, boolean isEnabled) {
        MenuItem menuItem = new MenuItem(contextMenu, 0);
        menuItem.setText(text);
        menuItem.setImage(image);
        menuItem.setEnabled(isEnabled);
        menuItem.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                action.onTriggered();
            }
        });
    }

    private static boolean isImageNameValid(String libraryName) {
        return libraryName != null && !libraryName.isEmpty() && !libraryName.startsWith("[");
    }

    public static boolean hasProcesses(@NonNull ILiveProcessDataProvider processDataProvider) {
        return processDataProvider.getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY).stream().mapToInt(ProcessData::getProcessID).anyMatch(id -> id != -1);
    }

    public ImageSelectionDialog(Shell parentShell, @NonNull IImageTransferCaptureDataSource captureDataSource, @NonNull ILiveProcessDataProvider processDataProvider, @NonNull Set<@NonNull ImageToDownload> imagesToDownload) {
        super(parentShell);
        this.setShellStyle(67696);
        assert (ImageSelectionDialog.hasProcesses(processDataProvider));
        this.captureDataSource = captureDataSource;
        this.processDataProvider = processDataProvider;
        this.imagesToDownload = imagesToDownload;
        this.processImage = (Image)NullChecking.neverNull((Object)StreamlinePlugin.getImage("ProgramFile.png"));
        this.addProcessImage = (Image)NullChecking.neverNull((Object)StreamlinePlugin.getImage("Download.png"));
        this.addProcessAndDepsImage = (Image)NullChecking.neverNull((Object)StreamlinePlugin.getImage("DownloadWithDeps.png"));
        ImageDescriptor desc = Images.getEclipseSharedImageDescriptor("IMG_TOOL_DELETE");
        this.removeImageImage = (Image)NullChecking.neverNull((Object)desc.createImage());
        this.processComparator = new ProcessComparator();
        this.isImageDownloadValid = new WritableValue((Object)Boolean.FALSE, Boolean.TYPE);
        this.bindingContext = new DataBindingContext();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.okButton = this.createButton(parent, 0, SessionMessages.START_DOWNLOAD_BUTTON, false);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)NullChecking.neverNull((Object)this.okButton)), this.isImageDownloadValid);
        this.refreshImagesTable();
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage(SessionMessages.DIALOG_MESSAGE);
        this.setTitle(SessionMessages.DIALOG_TITLE);
        this.getShell().setText(SessionMessages.DIALOG_TITLE);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        GridLayout gl_container = new GridLayout(1, false);
        gl_container.marginWidth = 12;
        gl_container.marginHeight = 6;
        container.setLayout((Layout)gl_container);
        container.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(container, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        sashForm.setSashWidth(8);
        Group groupProcesses = new Group((Composite)sashForm, 0);
        groupProcesses.setText(SessionMessages.GROUP_PROCESSES);
        groupProcesses.setLayout((Layout)new GridLayout(2, false));
        ToolBar toolBarProcesses = new ToolBar((Composite)groupProcesses, 0x820000);
        ToolItem buttonAddImageOnly = new ToolItem(toolBarProcesses, 0);
        buttonAddImageOnly.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.addSelectedPaths(false);
            }
        });
        buttonAddImageOnly.setText(SessionMessages.BUTTON_ADD_PROCESS);
        buttonAddImageOnly.setImage(this.addProcessImage);
        buttonAddImageOnly.setEnabled(false);
        ToolItem buttonAddImagesAndLibs = new ToolItem(toolBarProcesses, 0);
        buttonAddImagesAndLibs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.addSelectedPaths(true);
            }
        });
        buttonAddImagesAndLibs.setText(SessionMessages.BUTTON_ADD_ALL_IMAGES);
        buttonAddImagesAndLibs.setImage(this.addProcessAndDepsImage);
        buttonAddImagesAndLibs.setEnabled(false);
        this.mFilterText = new Text((Composite)groupProcesses, 2048);
        this.mFilterText.setMessage(SessionMessages.FILTER_HINT);
        this.mFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.tableViewerProcesses = new TableViewer((Composite)groupProcesses, 67587);
        this.tableProcesses = this.tableViewerProcesses.getTable();
        this.tableProcesses.setLinesVisible(true);
        this.tableProcesses.setHeaderVisible(true);
        this.tableProcesses.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.tableViewerProcesses.addSelectionChangedListener(event -> {
            @NonNull List<@NonNull String> imagesPath = this.findImagesForSelected(this.tableViewerProcesses.getStructuredSelection());
            @NonNull List<@NonNull String> libsPath = this.findLibsForSelected(this.tableViewerProcesses.getStructuredSelection());
            buttonAddImageOnly.setEnabled(imagesPath.size() > 0);
            buttonAddImagesAndLibs.setEnabled(imagesPath.size() > 0 || libsPath.size() > 0);
        });
        TableViewerColumn tableViewerColumnProcessId = new TableViewerColumn(this.tableViewerProcesses, 0);
        tableViewerColumnProcessId.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element != null && element instanceof ProcessData) {
                    ProcessData pd = (ProcessData)element;
                    return String.valueOf(pd.getProcessID());
                }
                return "";
            }
        });
        this.tableColumnProcessId = tableViewerColumnProcessId.getColumn();
        this.tableColumnProcessId.setWidth(120);
        this.tableColumnProcessId.setText(ProcessMessages.ID_TITLE);
        this.tableColumnProcessId.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.sortByProcessId();
            }
        });
        TableViewerColumn tableViewerColumnProcessName = new TableViewerColumn(this.tableViewerProcesses, 0);
        tableViewerColumnProcessName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                if (element instanceof ProcessData) {
                    ProcessData pd = (ProcessData)element;
                    return String.valueOf(pd.getProcessName());
                }
                return "";
            }
        });
        this.tableColumnProcessName = tableViewerColumnProcessName.getColumn();
        this.tableColumnProcessName.setWidth(200);
        this.tableColumnProcessName.setText(ProcessMessages.NAME_TITLE);
        this.tableColumnProcessName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.sortByProcessName();
            }
        });
        this.tableViewerProcesses.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerProcesses.setInput(this.processDataProvider.getProcessData(IProcessDataProvider.ThreadMode.PROCESS_ONLY));
        Group groupImagesToDownload = new Group((Composite)sashForm, 0);
        groupImagesToDownload.setText(SessionMessages.GROUP_IMAGES);
        groupImagesToDownload.setLayout((Layout)new GridLayout(1, false));
        ToolBar toolBarImages = new ToolBar((Composite)groupImagesToDownload, 0x820000);
        ToolItem buttonRemoveImages = new ToolItem(toolBarImages, 0);
        buttonRemoveImages.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.doRemoveSelectedImages();
            }
        });
        buttonRemoveImages.setToolTipText(SessionMessages.BUTTON_REMOVE_TOOLTIP);
        buttonRemoveImages.setText(DocumentsMessages.IMAGE_REMOVE);
        buttonRemoveImages.setImage(this.removeImageImage);
        this.buttonRemoveAllDuplicates = new ToolItem(toolBarImages, 0);
        this.buttonRemoveAllDuplicates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImageSelectionDialog.this.validateSelectedImagesAndSetError();
                ImageSelectionDialog.this.doRemoveSelectedImages();
            }
        });
        this.buttonRemoveAllDuplicates.setText(SessionMessages.BUTTON_REMOVE_DUPLICATES);
        this.buttonRemoveAllDuplicates.setToolTipText(SessionMessages.BUTTON_REMOVE_DUPLICATES_TOOLTIP);
        this.buttonRemoveAllDuplicates.setImage(this.removeImageImage);
        this.tableViewerImages = new TableViewer((Composite)groupImagesToDownload, 67586);
        this.tableImages = this.tableViewerImages.getTable();
        this.tableImages.setLinesVisible(true);
        this.tableImages.setHeaderVisible(true);
        this.tableImages.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableImages.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    ImageSelectionDialog.this.doRemoveSelectedImages();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tableViewerImages.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewerImages.setInput(this.imagesToDownload);
        TableViewerColumn tableViewerColumnDuplicate = new TableViewerColumn(this.tableViewerImages, 0x1000000);
        tableViewerColumnDuplicate.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ImageToDownload image;
                List<ImageToDownload> duplicateImageList = ImageSelectionDialog.this.getDuplicatesList();
                if (duplicateImageList.contains(image = (ImageToDownload)element)) {
                    return JFaceResources.getImage((String)"dialog_message_error_image");
                }
                return null;
            }

            public String getText(Object element) {
                return null;
            }

            public String getToolTipText(Object element) {
                ImageToDownload image;
                List<ImageToDownload> duplicateImageList = ImageSelectionDialog.this.getDuplicatesList();
                if (duplicateImageList.contains(image = (ImageToDownload)element)) {
                    return SessionMessages.DUPLICATE_WARNING_TOOLTIP;
                }
                return null;
            }
        });
        this.tableColumnDuplicates = tableViewerColumnDuplicate.getColumn();
        this.tableColumnDuplicates.setWidth(25);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.tableViewerImages);
        TableViewerColumn tableViewerColumnImageName = new TableViewerColumn(this.tableViewerImages, 0);
        tableViewerColumnImageName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                ImageToDownload imageToDownload = (ImageToDownload)element;
                return imageToDownload == null ? null : ImageSelectionDialog.this.processImage;
            }

            public String getText(Object element) {
                ImageToDownload imageToDownload = (ImageToDownload)element;
                return imageToDownload == null ? "" : new File(imageToDownload.path).getName();
            }
        });
        TableColumn tableColumnImageName = tableViewerColumnImageName.getColumn();
        tableColumnImageName.setWidth(200);
        tableColumnImageName.setText(DocumentsMessages.IMAGE_COLUMN_NAME);
        TableViewerColumn tableViewerColumnImagePath = new TableViewerColumn(this.tableViewerImages, 0);
        tableViewerColumnImagePath.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return null;
            }

            public String getText(Object element) {
                ImageToDownload imageToDownload = (ImageToDownload)element;
                return imageToDownload == null ? "" : imageToDownload.path;
            }
        });
        TableColumn tableColumnImagePath = tableViewerColumnImagePath.getColumn();
        tableColumnImagePath.setWidth(100);
        tableColumnImagePath.setText(SessionMessages.IMAGE_PATH_COLUMN);
        sashForm.setWeights(new int[]{3, 2});
        this.tableProcesses.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
                ImageSelectionDialog.this.addSelectedPaths(false);
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseUp(MouseEvent e) {
            }
        });
        this.tableProcesses.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000050 || e.character == '\r') {
                    if ((e.stateMask & 0x40000) != 0) {
                        ImageSelectionDialog.this.addSelectedPaths(true);
                    } else {
                        ImageSelectionDialog.this.addSelectedPaths(false);
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.tableViewerProcesses.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ProcessData) {
                    ProcessData pd = (ProcessData)element;
                    if (pd.getUID() == 0 || pd.getUID() == 1) {
                        return false;
                    }
                    @NonNull String processName = pd.getProcessName();
                    @NonNull String processId = (String)NullChecking.neverNull((Object)String.valueOf(pd.getProcessID()));
                    if (!ImageSelectionDialog.this.mFilterText.getText().isEmpty()) {
                        return ImageSelectionDialog.this.matchesFilter(processName, processId);
                    }
                }
                return true;
            }
        }});
        this.tableViewerProcesses.setComparator((ViewerComparator)this.processComparator);
        this.mFilterText.addModifyListener(e -> this.refreshProcessesTable());
        this.mFilterText.setFocus();
        this.tableProcesses.addListener(35, event -> {
            if (this.tableProcesses.getSelectionCount() > 0) {
                Menu contextMenu = new Menu((Control)this.tableProcesses);
                @NonNull List<@NonNull String> imagesPath = this.findImagesForSelected(this.tableViewerProcesses.getStructuredSelection());
                @NonNull List<@NonNull String> libsPath = this.findLibsForSelected(this.tableViewerProcesses.getStructuredSelection());
                ImageSelectionDialog.addMenuItem(contextMenu, this.addProcessImage, SessionMessages.BUTTON_ADD_PROCESS, () -> this.addSelectedPaths(false), imagesPath.size() > 0);
                ImageSelectionDialog.addMenuItem(contextMenu, this.addProcessAndDepsImage, SessionMessages.BUTTON_ADD_ALL_IMAGES, () -> this.addSelectedPaths(true), imagesPath.size() > 0 || libsPath.size() > 0);
                contextMenu.setLocation(event.x, event.y);
                contextMenu.setVisible(true);
            }
        });
        this.tableImages.addListener(35, event -> {
            if (this.tableImages.getSelectionCount() > 0) {
                Menu contextMenu = new Menu((Control)this.tableImages);
                ImageSelectionDialog.addMenuItem(contextMenu, this.removeImageImage, DocumentsMessages.IMAGE_REMOVE, () -> this.doRemoveSelectedImages(), true);
                contextMenu.setLocation(event.x, event.y);
                contextMenu.setVisible(true);
            }
        });
        this.setHelpAvailable(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)area, "com.arm.streamline.images_download");
        return area;
    }

    protected @NonNull List<@NonNull String> findImagesForSelected(IStructuredSelection structuredSelection) {
        Map<IUniqueThread, IExecutablePath> processExecutablePaths = this.captureDataSource.getAllProcessExecutables();
        Map<IUniqueThread, Set<IExecutablePath>> processLibraryPaths = this.captureDataSource.getAllProcessImages();
        @NonNull TreeSet<@NonNull String> imagePaths = new TreeSet<String>();
        for (ProcessData processData : structuredSelection) {
            String processName;
            IUniqueThread uniqueThread = processData.getProcess();
            if (uniqueThread == null) continue;
            IExecutablePath executablePath = processExecutablePaths.get(uniqueThread);
            if (executablePath != null && !executablePath.isAbstractPath()) {
                imagePaths.add(executablePath.getFullPath());
                continue;
            }
            Set<IExecutablePath> libraries = processLibraryPaths.get(uniqueThread);
            if (libraries == null || (processName = uniqueThread.getName()) == null) continue;
            for (IExecutablePath library : libraries) {
                String pkg = library.extractAndroidPackageName();
                if (pkg == null && (library.isAbstractPath() || !processName.contentEquals(library.getBaseName()) && !library.getBaseName().endsWith(".apk"))) continue;
                imagePaths.add(library.getFullPath());
            }
        }
        return new ArrayList<String>(imagePaths);
    }

    protected @NonNull List<@NonNull String> findLibsForSelected(IStructuredSelection structuredSelection) {
        Map<IUniqueThread, Set<IExecutablePath>> processLibraryPaths = this.captureDataSource.getAllProcessImages();
        @NonNull TreeSet<@NonNull String> libsPaths = new TreeSet<String>();
        for (ProcessData processData : structuredSelection) {
            IUniqueThread uniqueThread = processData.getProcess();
            Set<IExecutablePath> libraries = processLibraryPaths.get(uniqueThread);
            if (libraries == null) continue;
            for (IExecutablePath library : libraries) {
                if (library.isAbstractPath()) continue;
                libsPaths.add(library.getFullPath());
            }
        }
        return new ArrayList<String>(libsPaths);
    }

    void addSelectedPaths(boolean includeLibs) {
        IStructuredSelection structuredSelection = this.tableViewerProcesses.getStructuredSelection();
        @NonNull List<@NonNull String> imagesPath = this.findImagesForSelected(structuredSelection);
        @NonNull List<@NonNull String> libsPath = this.findLibsForSelected(structuredSelection);
        imagesPath.forEach(this::appendPath);
        if (includeLibs) {
            libsPath.forEach(this::appendPath);
        }
        this.refreshImagesTable();
    }

    protected void doRemoveSelectedImages() {
        IStructuredSelection structuredSelection = this.tableViewerImages.getStructuredSelection();
        if (!structuredSelection.isEmpty()) {
            for (ImageToDownload entry : structuredSelection) {
                this.imagesToDownload.remove(entry);
            }
            this.refreshImagesTable();
        }
    }

    protected Point getInitialSize() {
        return new Point(640, 700);
    }

    protected boolean matchesFilter(@NonNull String processName, @NonNull String processId) {
        String filterPhrase = this.mFilterText.getText().toLowerCase();
        return processName.toLowerCase().contains(filterPhrase) || processId.toLowerCase().contains(filterPhrase);
    }

    protected void refreshProcessesTable() {
        this.tableViewerProcesses.refresh();
    }

    protected void sortByProcessId() {
        this.setSortOrder(ProcessComparator.ColumIndex.COLUMN_PROCESS_ID, this.tableColumnProcessId);
    }

    protected void sortByProcessName() {
        this.setSortOrder(ProcessComparator.ColumIndex.COLUMN_PROCESS_NAME, this.tableColumnProcessName);
    }

    private void appendPath(@NonNull String imagePath) {
        if (ImageSelectionDialog.isImageNameValid(imagePath)) {
            this.imagesToDownload.add(new ImageToDownload(imagePath));
        }
    }

    private void refreshImagesTable() {
        this.tableViewerImages.refresh();
        if (this.okButton != null) {
            this.isImageDownloadValid.setValue((Object)this.validateSelectedImagesAndSetError());
        }
    }

    private void setSortOrder(ProcessComparator.ColumIndex columnIndex, TableColumn column) {
        if (this.processComparator.getColumnIndex() == columnIndex) {
            this.processComparator.toggleOrder();
        } else {
            this.processComparator.setColumnIndex(columnIndex);
            this.tableProcesses.setSortColumn(column);
        }
        this.tableProcesses.setSortDirection(this.processComparator.getSwtSortingDirection());
        this.tableViewerProcesses.refresh();
    }

    private @NonNull Boolean validateSelectedImagesAndSetError() {
        if (this.imagesToDownload.size() > 0) {
            List<ImageToDownload> duplicateImages = this.getDuplicatesList();
            if (duplicateImages.size() > 0) {
                Collections.sort(duplicateImages);
                StructuredSelection duplicateImagesToBeSelected = new StructuredSelection(duplicateImages);
                this.tableViewerImages.setSelection((ISelection)duplicateImagesToBeSelected);
                this.setErrorMessage(SessionMessages.ERROR_DUPLICATES);
                this.buttonRemoveAllDuplicates.setEnabled(true);
                return Boolean.FALSE;
            }
            this.tableViewerImages.setSelection(null);
            this.buttonRemoveAllDuplicates.setEnabled(false);
            String errorMessage = this.getErrorMessage();
            if (errorMessage != null && errorMessage.contains(SessionMessages.ERROR_DUPLICATES)) {
                this.setMessage(SessionMessages.WARNING_SELECTING_ONE_DUPLICATE, 2);
            } else {
                this.setMessage(SessionMessages.DIALOG_MESSAGE);
            }
            this.setErrorMessage(null);
            return Boolean.TRUE;
        }
        this.setErrorMessage(null);
        return Boolean.FALSE;
    }

    private List<@NonNull ImageToDownload> getDuplicatesList() {
        HashSet<@NonNull String> tempSet = new HashSet<String>();
        ArrayList<@NonNull ImageToDownload> duplicateImages = new ArrayList<ImageToDownload>();
        for (ImageToDownload image : this.imagesToDownload) {
            @NonNull String name = new File(image.path).getName();
            if (tempSet.add(name)) continue;
            duplicateImages.add(image);
        }
        return duplicateImages;
    }

    public static final class ImageToDownload
    implements Comparable<ImageToDownload> {
        public final @NonNull String path;

        public ImageToDownload(@NonNull String path) {
            this.path = path;
        }

        @Override
        public int compareTo(ImageToDownload o) {
            String oName;
            String name = new File(this.path).getName();
            int nameResult = name.compareTo(oName = new File(o.path).getName());
            if (nameResult != 0) {
                return nameResult;
            }
            return this.path.compareTo(o.path);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ImageToDownload) {
                ImageToDownload that = (ImageToDownload)obj;
                return this.path.equals(that.path);
            }
            return false;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return String.format("ImageToDownload{\"%s\"}", this.path);
        }
    }

    @FunctionalInterface
    static interface MenuItemAction {
        public void onTriggered();
    }

    static class ProcessComparator
    extends ViewerComparator {
        private int direction = 1;
        private ColumIndex index = ColumIndex.NO_SORTING;

        ProcessComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ProcessData processData1 = (ProcessData)e1;
            ProcessData processData2 = (ProcessData)e2;
            switch (this.index) {
                case COLUMN_PROCESS_ID: {
                    return this.direction * Integer.compare(processData1.getProcessID(), processData2.getProcessID());
                }
                case COLUMN_PROCESS_NAME: {
                    return this.direction * processData1.getProcessName().compareTo(processData2.getProcessName());
                }
            }
            return super.compare(viewer, e1, e2);
        }

        ColumIndex getColumnIndex() {
            return this.index;
        }

        int getSwtSortingDirection() {
            return this.direction == -1 ? 1024 : 128;
        }

        void setColumnIndex(ColumIndex index) {
            this.index = index;
        }

        void toggleOrder() {
            this.direction *= -1;
        }

        public static enum ColumIndex {
            COLUMN_PROCESS_ID,
            COLUMN_PROCESS_NAME,
            NO_SORTING;

        }
    }
}

