/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.counters.IAnalysisSpeMultiCounterReader;
import com.arm.streamline.analysis.processing.CachingStreamReaderAdapter;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processor.timeline.Counters;
import com.arm.streamline.analysis.processor.timeline.LegacyBaseZoomLevelGeneratorFactory;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.LongUnaryOperator;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class SpeCounterBaseZoomLevelGenerator
extends AnalysisBase {
    private final @NonNull IAnalysisSpeMultiCounterReader counterReader;
    private final @NonNull Counters counters;
    private final long duration;
    private final @Nullable LegacyBaseZoomLevelGeneratorFactory @NonNull [] factories;
    private final int id;
    private int progress = -1;
    private final long timebase;

    public SpeCounterBaseZoomLevelGenerator(@NonNull SessionSettings settings, @NonNull Counters counters, int id, @NonNull IUniqueIds threads, @NonNull LongUnaryOperator vmExitTimeSupplier, @NonNull IAnalysisHandler handler, @NonNull IAnalysisSpeMultiCounterReader counterReader, @NonNull IReportWriterFactory reportWriterFactory) throws IOException, XMLStreamException {
        super(handler);
        this.counters = counters;
        this.id = id;
        this.counterReader = counterReader;
        this.timebase = settings.getNanosecondsPerDensestBin();
        this.duration = settings.getDurationInNanosecs();
        CounterRecord[] counterRecords = counterReader.getCounters();
        this.factories = new LegacyBaseZoomLevelGeneratorFactory[counterRecords.length];
        int ndx = 0;
        while (ndx < counterRecords.length) {
            CounterRecord counterRecord = counterRecords[ndx];
            this.factories[ndx] = new LegacyBaseZoomLevelGeneratorFactory(settings, threads, vmExitTimeSupplier, counterRecord, counterRecord.getAlias(), reportWriterFactory);
            ++ndx;
        }
        this.setName("SpeCounters", settings.getInputPath(), settings.getOutputPath());
        this.setPriorityHighest();
    }

    @Override
    protected void process() {
        try {
            LegacyBaseZoomLevelGeneratorFactory.Generator[] generators = new LegacyBaseZoomLevelGeneratorFactory.Generator[this.factories.length];
            IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor[] processors = new IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor[this.factories.length];
            Throwing.closeAlways(tracker -> {
                if (!this.initGeneratorsAndProcessors((Throwing.ICloseableTracker)tracker, generators, processors)) {
                    return null;
                }
                this.progress(0);
                this.processingLoop(generators, processors);
                return null;
            });
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    protected void progress(int progress) {
        if (progress > this.progress) {
            this.progress = progress;
            this.counters.progress(this.id, progress);
        }
    }

    private boolean initGeneratorsAndProcessors(// Could not load outer class - annotation placement on inner may be incorrect
    @NonNull Throwing.ICloseableTracker tracker, @Nullable LegacyBaseZoomLevelGeneratorFactory.Generator @NonNull [] generators, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor @NonNull [] processors) throws IOException {
        boolean hasAtLeastOneGenerator = false;
        int ndx = 0;
        while (ndx < this.factories.length) {
            LegacyBaseZoomLevelGeneratorFactory factory = this.factories[ndx];
            if (factory != null) {
                LegacyBaseZoomLevelGeneratorFactory.Generator generator = (LegacyBaseZoomLevelGeneratorFactory.Generator)tracker.trackIfNotNull((Closeable)factory.create());
                if (generator != null) {
                    hasAtLeastOneGenerator = true;
                    generators[ndx] = generator;
                    processors[ndx] = LegacyBaseZoomLevelGeneratorFactory.mapProcessor(factory.getCounterRecord(), factory.getChannelCount());
                }
                this.factories[ndx] = null;
            }
            ++ndx;
        }
        return hasAtLeastOneGenerator;
    }

    private void processingLoop(@Nullable LegacyBaseZoomLevelGeneratorFactory.Generator @NonNull [] generators, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor @NonNull [] processors) throws IOException {
        CachingStreamReaderAdapter cachedReader = new CachingStreamReaderAdapter(() -> (IAnalysisSpeMultiCounterReader.IValue)this.counterReader.read());
        long lastTimestamp = -this.timebase;
        while (lastTimestamp < this.duration && !this.isInterrupted()) {
            lastTimestamp += this.timebase;
            IAnalysisSpeMultiCounterReader.IValue next = (IAnalysisSpeMultiCounterReader.IValue)cachedReader.head();
            while (next != null && next.getTimestamp() < lastTimestamp) {
                long timestamp = next.getTimestamp();
                Integer utid = next.getUtid();
                int numValues = next.getNumEntries();
                int ndx = 0;
                while (ndx < numValues) {
                    int counterIndex = next.getCounterRecordIndex(ndx);
                    LegacyBaseZoomLevelGeneratorFactory.Generator generator = generators[counterIndex];
                    IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor processor = processors[counterIndex];
                    if (generator != null && processor != null) {
                        int channelNumber = next.getChannelNumber(ndx);
                        long duration = next.getDuration(ndx);
                        long value = next.getValue(ndx);
                        processor.insert(generator.consumer, lastTimestamp, timestamp, channelNumber, utid, duration, value);
                    }
                    ++ndx;
                }
                next = (IAnalysisSpeMultiCounterReader.IValue)cachedReader.next();
            }
            int ndx = 0;
            while (ndx < generators.length) {
                LegacyBaseZoomLevelGeneratorFactory.Generator generator = generators[ndx];
                IAnalysisBinningThreadCounterReader.IAnalysisBinningThreadCounterReaderProcessor processor = processors[ndx];
                if (generator != null && processor != null) {
                    processor.commit(generator.consumer, lastTimestamp);
                    generator.consumer.commit(lastTimestamp);
                }
                ++ndx;
            }
        }
    }
}

