/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.counters.IAnalysisHardwareCounterReader;
import com.arm.streamline.analysis.processing.binning.IAnalysisBinningThreadCounterReader;
import com.arm.streamline.analysis.processing.zoomlevelgeneration.BaseZoomLevelGenerator;
import com.arm.streamline.analysis.processor.timeline.Counters;
import com.arm.streamline.analysis.processor.timeline.LegacyBaseZoomLevelGeneratorFactory;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterClass;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.utils.function.IThrowingSupplier;
import com.arm.utils.function.Throwing;
import java.io.Closeable;
import java.io.IOException;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class LegacyBaseZoomLevelGenerator
extends AnalysisBase {
    private final @NonNull IThrowingSupplier<@NonNull IAnalysisBinningThreadCounterReader, IOException> counterStream;
    private final @NonNull Counters counters;
    private @Nullable LegacyBaseZoomLevelGeneratorFactory factory;
    private final int id;
    private int progress = -1;

    public LegacyBaseZoomLevelGenerator(@NonNull SessionSettings settings, @NonNull Counters counters, int id, @NonNull IUniqueIds threads, @NonNull Function<@NonNull CounterRecord, @NonNull DeviceType> counterDeviceType, @NonNull LongUnaryOperator vmExitTimeSupplier, @NonNull IAnalysisHandler handler, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream counterStream, @NonNull IReportWriterFactory reportWriterFactory) throws IOException, XMLStreamException {
        this(settings, counters, id, threads, counterDeviceType, vmExitTimeSupplier, handler, (IThrowingSupplier<IAnalysisBinningThreadCounterReader, IOException>)((IThrowingSupplier)() -> (IAnalysisBinningThreadCounterReader)Throwing.closeIfThrows(t -> {
            IAnalysisHardwareCounterReader reader = (IAnalysisHardwareCounterReader)t.track((Closeable)counterStream.createReader());
            return LegacyBaseZoomLevelGeneratorFactory.mapReader(counterStream.getCounterRecord(), reader);
        })), counterStream.getCounterRecord(), counterStream.getStreamName(), reportWriterFactory);
    }

    private LegacyBaseZoomLevelGenerator(@NonNull SessionSettings settings, @NonNull Counters counters, int id, @NonNull IUniqueIds threads, @NonNull Function<@NonNull CounterRecord, @NonNull DeviceType> counterDeviceType, @NonNull LongUnaryOperator vmExitTimeSupplier, @NonNull IAnalysisHandler handler, @NonNull IThrowingSupplier<@NonNull IAnalysisBinningThreadCounterReader, IOException> counterStream, @NonNull CounterRecord counterRecord, @NonNull String streamName, @NonNull IReportWriterFactory reportWriterFactory) throws IOException, XMLStreamException {
        super(handler);
        this.counters = counters;
        this.id = id;
        this.counterStream = counterStream;
        if (counterRecord.getDeviceType() == null) {
            counterRecord.setDeviceType(counterDeviceType.apply(counterRecord));
        }
        if (counterRecord.getCounterClass() == CounterClass.CONSTANT) {
            counterRecord.setHideByDefault(true);
        }
        this.factory = new LegacyBaseZoomLevelGeneratorFactory(settings, threads, vmExitTimeSupplier, counterRecord, streamName, reportWriterFactory);
        this.setName(String.format("Counter[%s]", streamName), settings.getInputPath(), settings.getOutputPath());
        this.setPriorityHighest();
    }

    @Override
    protected void process() {
        LegacyBaseZoomLevelGeneratorFactory factory = this.factory;
        if (factory == null) {
            return;
        }
        try {
            LegacyBaseZoomLevelGeneratorFactory.Generator generator = factory.create();
            if (generator == null) {
                return;
            }
            this.factory = null;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (IAnalysisBinningThreadCounterReader channelsReader = (IAnalysisBinningThreadCounterReader)this.counterStream.get();){
                    this.progress(0);
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (BaseZoomLevelGenerator bzlg = generator.makeBaseZoomLevelGenerator(channelsReader);){
                        while (!this.isInterrupted() && bzlg.next()) {
                            this.progress((int)(100L * bzlg.getLastTimestamp() / generator.duration));
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            finally {
                generator.close();
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    @Override
    protected void progress(int progress) {
        if (progress > this.progress) {
            this.progress = progress;
            this.counters.progress(this.id, progress);
        }
    }
}

