/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.timeline;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.database.api.IAnalysisReaderFactoryV2;
import com.arm.streamline.analysis.database.api.counters.IAnalysisSpeMultiCounterReader;
import com.arm.streamline.analysis.processor.timeline.LegacyBaseZoomLevelGenerator;
import com.arm.streamline.analysis.processor.timeline.SpeCounterBaseZoomLevelGenerator;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.model.counters.CounterRecord;
import com.arm.streamline.common.model.topology.DeviceType;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.report.api.write.IReportWriterFactory;
import com.arm.streamline.report.model.uids.IUniqueIds;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Counters
extends AnalysisBase {
    private final int @NonNull [] mProgressMap;
    private @Nullable ExecutorService mThreadPool;

    public Counters(@NonNull SessionSettings settings, @NonNull Function<@NonNull CounterRecord, @NonNull DeviceType> counterDeviceType, @NonNull LongUnaryOperator vmExitTimeSupplier, @NonNull IAnalysisHandler handler, @NonNull IAnalysisReaderFactoryV2 analysisReaderFactory, @NonNull IUniqueIds threads, @NonNull IReportWriterFactory reportWriterFactory) throws IOException, XMLStreamException {
        super(handler);
        super.progress(0);
        @NonNull List<@NonNull T> counterStreams = analysisReaderFactory.enumerateThreadCounterChannelStreams().collect(Collectors.toList());
        counterStreams.addAll(analysisReaderFactory.enumerateCounterStreams());
        Throwable throwable = null;
        Object var10_11 = null;
        try (IAnalysisSpeMultiCounterReader speCounters = analysisReaderFactory.getSpeCounterReader();){
            ExecutorService threadPool;
            int size = counterStreams.size();
            this.mProgressMap = new int[size + (speCounters != null ? 1 : 0)];
            if (size == 0 && speCounters == null) {
                return;
            }
            CommonFileUtils.makeDirectory((String)settings.getOutputPathCounters());
            int numThreads = Math.min(Runtime.getRuntime().availableProcessors(), 8);
            this.mThreadPool = threadPool = Executors.newFixedThreadPool(numThreads);
            try {
                try {
                    int i = 0;
                    for (IAnalysisReaderFactoryV2.IAnalysisReaderHardwareCounterStream counterStream : counterStreams) {
                        threadPool.submit(new LegacyBaseZoomLevelGenerator(settings, this, i, threads, counterDeviceType, vmExitTimeSupplier, handler, counterStream, reportWriterFactory));
                        ++i;
                    }
                    if (speCounters != null) {
                        threadPool.submit(new SpeCounterBaseZoomLevelGenerator(settings, this, i, threads, vmExitTimeSupplier, handler, speCounters, reportWriterFactory));
                        ++i;
                    }
                }
                catch (IOException | XMLStreamException e) {
                    this.interrupt();
                    throw e;
                }
            }
            finally {
                this.mThreadPool.shutdown();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void interrupt() {
        if (this.mThreadPool != null) {
            this.mThreadPool.shutdownNow();
        }
    }

    @Override
    public void join() {
        try {
            try {
                if (this.mThreadPool != null) {
                    this.mThreadPool.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
                }
            }
            catch (InterruptedException exception) {
                this.interrupt();
                super.progress(100);
            }
        }
        finally {
            super.progress(100);
        }
    }

    public void progress(int id, int progress) {
        this.mProgressMap[id] = progress;
        int theProgress = 0;
        int[] nArray = this.mProgressMap;
        int n = this.mProgressMap.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            theProgress += element;
            ++n2;
        }
        super.progress(theProgress /= this.mProgressMap.length);
    }

    @Override
    protected void process() {
    }
}

