/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.profile;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.common.analysis.IAnalysisHandler;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.jni.apcdbgen.AnalysisOptions;
import com.arm.streamline.jni.apcdbgen.impl.ApcReport;
import com.arm.streamline.jni.apcdbgen.impl.IUniqueIDsHelper;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueProcessID;
import com.arm.streamline.jni.apcdbgen.proto.IUniqueThreadID;
import com.arm.streamline.jni.common.CancellationPredicate;
import com.arm.streamline.jni.common.IProgressMonitorFactory;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.HandlerProgressMonitorFactory;
import com.arm.utils.NullChecking;
import com.arm.utils.io.FileUtils;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ProfileV3
extends AnalysisBase {
    private final @NonNull CancellationPredicate cancellation;
    private final @NonNull File apcCapture;
    private final @NonNull IUniqueIds uniqueIds;
    private final boolean processDebugInfo;
    private final @NonNull File @Nullable [] searchImagePaths;

    public ProfileV3(@NonNull IAnalysisHandler handler, @NonNull File apcCapture, @NonNull IUniqueIds uniqueIds, boolean processDebugInfo, @NonNull File @Nullable [] searchImagePaths) {
        super(handler);
        this.apcCapture = apcCapture;
        this.uniqueIds = uniqueIds;
        this.processDebugInfo = processDebugInfo;
        this.searchImagePaths = searchImagePaths;
        this.cancellation = new CancellationPredicate();
        this.start();
    }

    @Override
    public void cancel() {
        this.cancellation.cancel();
        super.cancel();
    }

    @Override
    public void close() {
        this.cancellation.close();
        super.close();
    }

    @Override
    protected void process() {
        AnalysisOptions analysisOptions = new AnalysisOptions(false, true, true, true, this.processDebugInfo, this.searchImagePaths);
        try {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try {
                    ApcReport report = ApcReport.openReport((ExecutorService)Task.getExecutorService(), (IProgressMonitorFactory)new HandlerProgressMonitorFactory(this.getHandler(), this.apcCapture), (CancellationPredicate)this.cancellation, (AnalysisOptions)analysisOptions, (File)FileUtils.canonicalise((File)this.apcCapture), (IUniqueIDsHelper)new IUniqueIDsHelper(){

                        public @NonNull IUniqueThreadID getThreadByUID(long utid) {
                            UniqueThread result = ProfileV3.this.uniqueIds.findThread(Math.toIntExact(utid)).orElse(null);
                            if (result == null) {
                                throw new IllegalArgumentException("Invalid UTID " + utid);
                            }
                            return result;
                        }

                        public @NonNull IUniqueProcessID getProcessForThreadUID(long utid) {
                            UniqueThread result = ProfileV3.this.uniqueIds.findThread(Math.toIntExact(utid)).orElse(null);
                            if (result == null) {
                                throw new IllegalArgumentException("Invalid UTID " + utid);
                            }
                            return result.getProcess();
                        }

                        public @NonNull IUniqueProcessID getProcessByUID(long upid) {
                            UniqueProcess result = ProfileV3.this.uniqueIds.findProcess(Math.toIntExact(upid)).orElse(null);
                            if (result == null) {
                                throw new IllegalArgumentException("Invalid UPID " + upid);
                            }
                            return result;
                        }

                        public @NonNull Stream<@NonNull IUniqueThreadID> getThreadsByProcessUID(long upid) throws IllegalArgumentException {
                            return ((IntStream)NullChecking.neverNull((Object)ProfileV3.this.uniqueIds.getThreadUidsOf(Math.toIntExact(upid)).orElse(IntStream.empty()))).mapToObj(utid -> {
                                IUniqueThreadID result = ProfileV3.this.uniqueIds.findThread(utid).orElse(null);
                                return result;
                            }).filter(t -> t != null);
                        }
                    });
                    if (report != null) {
                        report.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                this.getHandler().error((Throwable)e);
                this.cancellation.close();
            }
        }
        finally {
            this.cancellation.close();
        }
    }

    static /* synthetic */ IUniqueIds access$0(ProfileV3 profileV3) {
        return profileV3.uniqueIds;
    }
}

