/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.model.values.VisualAnnotationValue;
import com.arm.streamline.analysis.processor.annotate.Annotate;
import com.arm.streamline.analysis.processor.annotate.AnnotateVisualWorker;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.utility.Task;
import com.arm.streamline.common.utility.WorkspaceUtils;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.XMLGenerator;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.UniqueProcess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import org.eclipse.jdt.annotation.NonNull;

public class AnnotateVisual
extends AnalysisBase {
    public static final String XML_FILE = "annotations.xml";
    public static final String TAG_VISUAL_ANNOTATIONS = "visual_annotations";
    public static final String TAG_VISUAL_ANNOTATION = "visual_annotation";
    public static final String ATTR_FILENAME = "filename";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TIME_INDEX = "time_index";
    public static final String ATTR_TITLE = "title";
    public static final String ATTR_PID = "pid";
    public static final String ATTR_VMUID = "vmuid";
    public static final String ATTR_VERSION = "version";
    private @NonNull List<Task> mWorkerThreads = new ArrayList<Task>();
    private final @NonNull Annotate mAnnotate;
    private final long mDuration;
    private final @NonNull BlockingQueue<VisualAnnotationValue> mAnnotationValues;
    private final @NonNull String mImagePath;
    private final @NonNull String mOutputPath;
    private final @NonNull String mTitle;
    private int mCycleColor;
    private final // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull AbstractPerVmId.PerVmNonUniquePid mPid;

    public static int getCyclicColor(int c) {
        return AnnotationColour.DARK_COLOR_PALETTE[c];
    }

    public AnnotateVisual(@NonNull String input, @NonNull String output, @NonNull UniqueProcess upid, @NonNull Annotate annotate, long duration, @NonNull BlockingQueue<VisualAnnotationValue> annotationValues) throws IOException {
        super(annotate.getHandler());
        this.mAnnotate = annotate;
        this.mDuration = duration;
        this.mAnnotationValues = annotationValues;
        this.mTitle = upid.getNonUid().getNameOrUnresolved();
        this.mPid = (AbstractPerVmId.PerVmNonUniquePid)upid.getNonUid().getId();
        this.mImagePath = output + "/annotate";
        this.mOutputPath = String.format("%s/%s/%d-%d", output, "annotate/visual", this.mPid.vmUID, this.mPid.id);
        CommonFileUtils.makeDirectory((String)this.mImagePath);
        CommonFileUtils.makeDirectory((String)this.mOutputPath);
        this.setName("AnnotateVisual", input, this.mOutputPath);
        this.setPriorityLower();
        this.start();
    }

    @Override
    public void interrupt() {
        super.interrupt();
        for (Task task : this.mWorkerThreads) {
            task.cancel();
        }
    }

    @Override
    protected void process() {
        this.mWorkerThreads = new ArrayList<Task>();
        try {
            try {
                Throwable throwable = null;
                Object var2_5 = null;
                try (XMLGenerator xml = XMLGenerator.create((File)new File(this.mOutputPath, XML_FILE));){
                    CommonFileUtils.makeDirectory((String)this.mImagePath, (String)"images");
                    CommonFileUtils.makeDirectory((String)this.mImagePath, (String)"thumbnails");
                    xml.startDocument();
                    xml.startTag(TAG_VISUAL_ANNOTATIONS);
                    xml.addAttribute(ATTR_VERSION, 1);
                    xml.addAttribute(ATTR_TITLE, this.mTitle);
                    xml.addAttribute(ATTR_PID, this.mPid.id);
                    xml.addAttribute(ATTR_VMUID, this.mPid.vmUID);
                    while (!this.isInterrupted()) {
                        VisualAnnotationValue annotationValue = this.mAnnotationValues.take();
                        long time = annotationValue.getTime();
                        if (time < 0L) continue;
                        if (time > this.mDuration) break;
                        String inputImage = annotationValue.getImageName();
                        boolean compressed = false;
                        if (inputImage.endsWith(".gz")) {
                            inputImage = inputImage.substring(0, inputImage.length() - 3);
                            compressed = true;
                        }
                        String outputImage = new File(inputImage).getName();
                        String text = annotationValue.getText();
                        int color = annotationValue.getColor();
                        if (color == 0) {
                            color = AnnotateVisual.getCyclicColor(this.mCycleColor);
                            this.mCycleColor = (this.mCycleColor + 1) % 4;
                        } else if ((color & 0xFFFFFF) == 0 && ((color >> 24) - 1 & 0xFF) < 4) {
                            color = AnnotateVisual.getCyclicColor((color >> 24) - 1 & 0xFF);
                        }
                        xml.startEmptyTag(TAG_VISUAL_ANNOTATION);
                        xml.addAttribute(ATTR_TIME_INDEX, time);
                        xml.addAttribute(ATTR_FILENAME, outputImage);
                        xml.addAttributeNot(ATTR_ID, this.mAnnotate.getMessage(text, color), 0);
                        if (WorkspaceUtils.isHeadless()) {
                            this.mWorkerThreads.add(Task.callOnCurrentThread((Runnable)new AnnotateVisualWorker(this.mImagePath, outputImage, compressed, this.getHandler())));
                            continue;
                        }
                        this.mWorkerThreads.add(Task.scheduleOnUIThread((Runnable)new AnnotateVisualWorker(this.mImagePath, outputImage, compressed, this.getHandler())));
                    }
                    xml.endTag();
                    xml.endDocument();
                    this.joinWorkerThreads();
                    this.mWorkerThreads = new ArrayList<Task>();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (InterruptedException interruptedException) {
                this.joinWorkerThreads();
                this.close();
            }
            catch (Exception e) {
                this.error(e);
                this.joinWorkerThreads();
                this.close();
            }
        }
        finally {
            this.joinWorkerThreads();
            this.close();
        }
    }

    private void joinWorkerThreads() {
        for (Task task : this.mWorkerThreads) {
            task.join();
        }
    }
}

