/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.report.shared.io.IndexDataFile;
import com.arm.utils.collections.LRUCache;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.Nullable;

public class AnnotateCache {
    private IndexDataFile mStrings;
    private LRUCache<String, Integer> mCache;
    private int mPosition;

    private static String getKey(String text, int color) {
        return text + "::" + String.format("%08x", color);
    }

    public AnnotateCache(String path, String name) throws IOException {
        this(path + "/" + name);
    }

    private AnnotateCache(String path) throws IOException {
        this.mStrings = new IndexDataFile(path);
        this.mCache = new LRUCache(100000);
        this.mStrings.writeIndex();
        ++this.mPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LRUCache<String, Integer> lRUCache = this.mCache;
        synchronized (lRUCache) {
            if (this.mStrings != null) {
                this.mStrings.writeIndex();
                this.mStrings.close();
                this.mStrings = null;
            }
        }
    }

    public int getID(String text) throws IOException {
        return this.getID(text, -3092272);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getID(String text, int color) throws IOException {
        if (text == null) {
            text = "";
        }
        if (text.isEmpty() && color == -3092272) {
            return 0;
        }
        String key = AnnotateCache.getKey(text, color);
        byte[] header = new byte[]{27, (byte)(color >> 16 & 0xFF), (byte)(color >> 8 & 0xFF), (byte)(color & 0xFF)};
        LRUCache<String, Integer> lRUCache = this.mCache;
        synchronized (lRUCache) {
            @Nullable Integer id = (Integer)this.mCache.get((Object)key);
            if (id == null) {
                if (this.mStrings != null) {
                    this.mStrings.write(header);
                    this.mStrings.write(text.getBytes(StandardCharsets.UTF_8));
                    this.mStrings.writeIndex();
                }
                int position = this.mPosition++;
                this.mCache.put((Object)key, (Object)position);
                return position;
            }
            return id;
        }
    }
}

