/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.processor.annotate;

import com.arm.streamline.analysis.AnalysisBase;
import com.arm.streamline.analysis.AnalysisMessages;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsPerChannelReader;
import com.arm.streamline.analysis.database.api.annotations.IAnalysisAnnotationsReader;
import com.arm.streamline.analysis.model.AnnotationDataStructure;
import com.arm.streamline.analysis.model.AnnotationType;
import com.arm.streamline.analysis.model.values.VisualAnnotationValue;
import com.arm.streamline.analysis.processor.ExitTime;
import com.arm.streamline.analysis.processor.annotate.AnnotateCache;
import com.arm.streamline.analysis.processor.annotate.AnnotateMarker;
import com.arm.streamline.analysis.processor.annotate.AnnotateString;
import com.arm.streamline.analysis.processor.annotate.AnnotateVisual;
import com.arm.streamline.analysis.session.SessionProcessor;
import com.arm.streamline.analysis.session.SessionSettings;
import com.arm.streamline.common.analysis.model.AnnotationColour;
import com.arm.streamline.common.utility.io.CommonFileUtils;
import com.arm.streamline.common.utility.io.FilePath;
import com.arm.streamline.common.utility.io.LittleEndianDataOutputStream;
import com.arm.streamline.jni.common.WarningItem;
import com.arm.streamline.jni.common.WarningSeverity;
import com.arm.streamline.jni.common.WarningType;
import com.arm.streamline.model.capture.Bookmark;
import com.arm.streamline.report.model.uids.AbstractPerVmId;
import com.arm.streamline.report.model.uids.IUniqueIds;
import com.arm.streamline.report.model.uids.UniqueProcess;
import com.arm.streamline.report.model.uids.UniqueThread;
import com.arm.streamline.utility.RGBUtils;
import com.arm.streamline.utility.io.ImageUtils;
import com.arm.utils.NullChecking;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.TLongIntMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class Annotate
extends AnalysisBase {
    private boolean mAnnotateCreatedPath = false;
    private final AnnotateMarker mAnnotateMarker;
    private final @NonNull IAnalysisAnnotationsReader mAnnotateReader;
    private final @NonNull List<AnnotateVisual> mAnnotateVisuals;
    private int markerColourRotationCounter = 0;
    private final long mDuration;
    private final @NonNull AnnotateCache mImages;
    private final @NonNull String mInputPath;
    private final IUniqueIds mIUniqueIds;
    private final @NonNull AnnotateCache mMessages;
    private final @NonNull String mOutputPath;
    private final @NonNull SessionSettings mSettings;
    private final long mTimebase;
    private final @NonNull TIntObjectMap<TLongIntMap> stringColourRotationCounter = new TIntObjectHashMap(10, 0.5f, 0);
    private int visualColourRotationCounter = 0;

    private static void updateLoggingWithTerminateMarker(LittleEndianDataOutputStream logs, Map<UniqueThread, TIntHashSet> activeChannels, UniqueThread thread, long timestamp) throws IOException {
        TIntHashSet set = activeChannels.get(thread);
        if (set != null) {
            TIntIterator itr = set.iterator();
            while (itr.hasNext()) {
                int channel = itr.next();
                Annotate.write(logs, timestamp, AnnotationType.STRING, thread.uid, 0, channel, -1);
                itr.remove();
            }
        }
    }

    private static void write(LittleEndianDataOutputStream logs, long timestamp, AnnotationType type, int utid, int messageID, int channel, int imageID) throws IOException {
        logs.writeLELong(timestamp);
        logs.writeLEShort(type.getOrdinal());
        logs.writeLEInt(utid);
        logs.writeLEInt(messageID);
        if (type == AnnotationType.STRING) {
            logs.writeLEInt(channel);
        } else if (type == AnnotationType.VISUAL) {
            logs.writeLEInt(imageID);
        }
    }

    public Annotate(SessionSettings settings, @NonNull SessionProcessor sp, @NonNull IAnalysisAnnotationsReader annotateReader, AnnotateMarker annotateMarker, IUniqueIds uniqueID) throws IOException {
        super(sp);
        this.mDuration = settings.getDurationInNanosecs();
        this.mAnnotateReader = annotateReader;
        this.mAnnotateMarker = annotateMarker;
        this.mIUniqueIds = uniqueID;
        this.progress(0);
        this.mSettings = settings;
        this.mInputPath = settings.getInputPath();
        this.mOutputPath = settings.getOutputPath();
        this.mTimebase = settings.getNanosecondsPerDensestBin();
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate");
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate/log");
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate/map");
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate/visual");
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate/images");
        CommonFileUtils.makeDirectory((String)this.mOutputPath, (String)"annotate/thumbnails");
        this.mAnnotateVisuals = new ArrayList<AnnotateVisual>();
        this.mImages = new AnnotateCache(this.mOutputPath, "annotate/map/images.bin");
        this.mMessages = new AnnotateCache(this.mOutputPath, "annotate/map/strings.bin");
        this.setName("Annotate", settings.getInputPath(), settings.getOutputPath());
        this.setPriorityLower();
        this.start();
    }

    @Override
    public void close() {
        super.close();
        for (AnnotateVisual av : this.mAnnotateVisuals) {
            av.join();
        }
        this.mAnnotateVisuals.clear();
    }

    @Override
    public void interrupt() {
        super.interrupt();
        for (AnnotateVisual av : this.mAnnotateVisuals) {
            av.interrupt();
        }
    }

    protected int getMessage(String text, int color) throws IOException {
        return this.mMessages.getID(text, color);
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void process() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private @Nullable UniqueThread findIdleOrKernelThreadFor(long vmUID) {
        UniqueThread idleThread = this.mIUniqueIds.getIdleThreads().filter(t -> t.getVmUID() == vmUID).sorted().findFirst().orElse(null);
        if (idleThread != null) {
            return idleThread;
        }
        UniqueProcess kernelProcess = this.mIUniqueIds.getKernelProcess(vmUID).orElse(null);
        if (kernelProcess == null) {
            return null;
        }
        Stream kernelThreads = this.mIUniqueIds.getThreadsOf(kernelProcess);
        return kernelThreads.sorted().findFirst().orElse(null);
    }

    private void freeProcess(long time, Queue<ExitTime> exitTimes, AnnotateString stringAnnotate, Map<UniqueThread, TIntHashSet> activeChannels, LittleEndianDataOutputStream logs) throws Exception {
        ExitTime element;
        while ((element = exitTimes.peek()) != null && element.mTime < time) {
            ExitTime exitTime = exitTimes.remove();
            long tick = this.getTick(exitTime.mTime);
            stringAnnotate.remove(tick, exitTime.mUtid);
            this.stringColourRotationCounter.remove(exitTime.mUtid.uid);
            Annotate.updateLoggingWithTerminateMarker(logs, activeChannels, exitTime.mUtid, exitTime.mTime);
        }
    }

    private long getTick(long timestamp) {
        return timestamp / this.mSettings.getNanosecondsPerDensestBin();
    }

    private void insertLiveBookmarksIntoTheAnnotateQueue(@NonNull AnnotationDataStructure annotations, @NonNull Queue<ExitTime> exitTimes, @NonNull AnnotateString stringAnnotate, @NonNull Map<UniqueThread, TIntHashSet> activeChannels, @NonNull LittleEndianDataOutputStream logs, @NonNull Map<UniqueProcess, BlockingQueue<VisualAnnotationValue>> visualQueues, @NonNull String capturePath) throws Exception {
        List<Bookmark> list = Bookmark.load(new File(capturePath, "bookmarks.xml"));
        UniqueThread kernelThread = this.mIUniqueIds.getAnyThread();
        if (kernelThread == null) {
            return;
        }
        for (Bookmark bookmark : list) {
            long timestampFromGator = bookmark.getTimestamp();
            IAnalysisAnnotationsPerChannelReader.Value bookmarkValue = new IAnalysisAnnotationsPerChannelReader.Value(kernelThread.getVmUID(), AnnotationType.BOOKMARK, kernelThread.uid, timestampFromGator, 0, null, 0, null, (String)NullChecking.neverNullOr((Object)bookmark.getTitle(), (Object)""), RGBUtils.toInt(bookmark.getRGB()), null);
            this.process(annotations, exitTimes, stringAnnotate, activeChannels, logs, visualQueues, bookmarkValue);
        }
    }

    private int mapColour(@NonNull AnnotationType type, int utid, int mappedGroup, int mappedChannel, int colour) {
        AnnotationColour.AnnotationColourClassification colourClassification = AnnotationColour.classify((int)colour);
        switch (colourClassification) {
            case DEFAULT: 
            case RGB: {
                return colour;
            }
            case ROTATE: {
                switch (type) {
                    case BOOKMARK: {
                        this.markerColourRotationCounter = (this.markerColourRotationCounter + 1) % 4;
                        return AnnotateVisual.getCyclicColor(this.markerColourRotationCounter);
                    }
                    case VISUAL: {
                        this.visualColourRotationCounter = (this.visualColourRotationCounter + 1) % 4;
                        return AnnotateVisual.getCyclicColor(this.visualColourRotationCounter);
                    }
                    case ERROR: 
                    case CHANNEL_NAME: 
                    case GROUP_NAME: 
                    case OPENCL: {
                        return colour;
                    }
                    case STRING: 
                    case STRING_PUSH: 
                    case STRING_POP: 
                    case STRING_ASYNC: {
                        TLongIntMap mapByUtid = (TLongIntMap)this.stringColourRotationCounter.get(utid);
                        if (mapByUtid == null) {
                            mapByUtid = new TLongIntHashMap(10, 0.5f, 0L, 0);
                            this.stringColourRotationCounter.put(utid, (Object)mapByUtid);
                        }
                        long key = ((long)mappedGroup & 0xFFFFFFFFL) << 32 | (long)mappedChannel & 0xFFFFFFFFL;
                        int result = mapByUtid.adjustOrPutValue(key, 1, 0) % 4;
                        mapByUtid.put(key, result);
                        return AnnotateVisual.getCyclicColor(result);
                    }
                }
                throw new AssertionError(type);
            }
            case TEMPLATE_0: {
                return AnnotateVisual.getCyclicColor(0);
            }
            case TEMPLATE_1: {
                return AnnotateVisual.getCyclicColor(1);
            }
            case TEMPLATE_2: {
                return AnnotateVisual.getCyclicColor(2);
            }
            case TEMPLATE_3: {
                return AnnotateVisual.getCyclicColor(3);
            }
        }
        throw new AssertionError(colourClassification);
    }

    private boolean process(@NonNull AnnotationDataStructure annotations, @NonNull Queue<ExitTime> exitTimes, @NonNull AnnotateString stringAnnotate, @NonNull Map<UniqueThread, TIntHashSet> activeChannels, @NonNull LittleEndianDataOutputStream logs, @NonNull Map<UniqueProcess, BlockingQueue<VisualAnnotationValue>> visualQueues, // Could not load outer class - annotation placement on inner may be incorrect
     @NonNull IAnalysisAnnotationsPerChannelReader.Value annotationValue) throws Exception {
        this.freeProcess(annotationValue.timestamp, exitTimes, stringAnnotate, activeChannels, logs);
        long timestampFromGator = annotationValue.timestamp;
        UniqueThread thread = this.mIUniqueIds.findThread(annotationValue.utid).orElse(null);
        if (thread == null && (long)annotationValue.utid == -1L) {
            thread = this.findIdleOrKernelThreadFor(annotationValue.vmUID);
        }
        if (thread == null) {
            assert (false);
            return true;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @NonNull AbstractPerVmId.PerVmNonUniqueTid nntid = (AbstractPerVmId.PerVmNonUniqueTid)thread.nonUid.getId();
        int utid = thread.uid;
        if (annotationValue.type == AnnotationType.STRING || annotationValue.type == AnnotationType.VISUAL || annotationValue.type == AnnotationType.BOOKMARK) {
            String image;
            long time = timestampFromGator;
            if (time < 0L) {
                return true;
            }
            if (time > this.mDuration) {
                return false;
            }
            long tick = this.getTick(timestampFromGator);
            String text = annotationValue.text;
            int mappedChannel = annotationValue.mappedChannel;
            @Nullable Integer originalChannel = annotationValue.originalChannel;
            byte[] visualData = annotationValue.visualData;
            int color = this.mapColour(annotationValue.type, annotationValue.utid, annotationValue.mappedGroup, annotationValue.mappedChannel, annotationValue.colour);
            this.progress((int)(100L * time / this.mDuration));
            String imageName = null;
            if (visualData != null) {
                imageName = String.format("%d_%05d_%08d%s", nntid.vmUID, nntid.id, time, ImageUtils.getImageDataExtension(visualData));
                if (!this.mAnnotateCreatedPath) {
                    new File(this.mOutputPath, "annotate/images").mkdir();
                    this.mAnnotateCreatedPath = true;
                }
                try {
                    Throwable throwable = null;
                    Object var24_25 = null;
                    try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.mOutputPath + "/annotate/images/" + imageName));){
                        ((OutputStream)out).write(visualData);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException exception) {
                    imageName = null;
                }
            }
            if ((image = FilePath.getLeafName(imageName)) != null && image.endsWith(".gz")) {
                image = image.substring(0, image.length() - 3);
            }
            if (annotationValue.type == AnnotationType.VISUAL) {
                UniqueProcess upid = thread.process;
                BlockingQueue<VisualAnnotationValue> annotationValues = visualQueues.get(upid);
                if (annotationValues == null) {
                    annotationValues = new LinkedBlockingQueue<VisualAnnotationValue>();
                    this.mAnnotateVisuals.add(new AnnotateVisual(this.mInputPath, this.mOutputPath, upid, this, this.mDuration, annotationValues));
                    visualQueues.put(upid, annotationValues);
                }
                annotationValues.put(new VisualAnnotationValue(time, color, text, imageName));
            }
            int messageID = this.getMessage(text, color);
            int imageID = this.mImages.getID(image);
            Annotate.write(logs, time, annotationValue.type, utid, messageID, mappedChannel, imageID);
            if (annotationValue.type == AnnotationType.BOOKMARK) {
                this.mAnnotateMarker.write(time, color, text);
            } else if (annotationValue.type == AnnotationType.STRING) {
                annotations.weakLink(utid, mappedChannel, 0, originalChannel);
                stringAnnotate.write(tick, thread, messageID, mappedChannel);
                if (messageID > 0) {
                    activeChannels.computeIfAbsent(thread, t -> {
                        exitTimes.add(new ExitTime(t.getNonUid().getEndTime(), (UniqueThread)t));
                        return new TIntHashSet();
                    }).add(mappedChannel);
                } else {
                    TIntHashSet set = activeChannels.get(thread);
                    if (set != null) {
                        set.remove(mappedChannel);
                    }
                }
            }
            return true;
        }
        if (annotationValue.type == AnnotationType.ERROR) {
            String text = annotationValue.text;
            String errorMessage = String.format("utid=%d @%d: %s", utid, timestampFromGator, text);
            WarningItem item = new WarningItem(WarningType.ANNOTATE, WarningSeverity.MEDIUM, AnalysisMessages.ANNOTATE_ERROR, errorMessage);
            this.warning(item);
            return true;
        }
        if (annotationValue.type == AnnotationType.CHANNEL_NAME) {
            annotations.addChannelName(utid, annotationValue.mappedChannel, annotationValue.mappedGroup, annotationValue.text, annotationValue.originalGroup, annotationValue.originalChannel);
            return true;
        }
        if (annotationValue.type == AnnotationType.GROUP_NAME) {
            annotations.addGroupName(utid, annotationValue.mappedGroup, annotationValue.text, annotationValue.originalGroup);
            return true;
        }
        throw new AssertionError(annotationValue.type);
    }

    private static /* synthetic */ void lambda$0(BlockingQueue x) {
        boolean bl = x.add(new VisualAnnotationValue(Long.MAX_VALUE, -1, null, null));
    }

    private /* synthetic */ void lambda$1(LittleEndianDataOutputStream littleEndianDataOutputStream, Map map, UniqueThread thread) throws IOException {
        long time = thread.getNonUid().getEndTime();
        Annotate.updateLoggingWithTerminateMarker(littleEndianDataOutputStream, map, thread, Math.min(time, this.mDuration));
    }
}

