/*
 * Decompiled with CFR 0.152.
 */
package com.arm.streamline.analysis.model;

import java.io.File;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class ImageRecordName
implements Comparable<ImageRecordName> {
    private final @NonNull String componentName;
    private final @NonNull String dbPath;
    private final @Nullable String entryName;
    private final @NonNull String keyName;

    public static @NonNull ImageRecordName fromAppString(@NonNull String key, @NonNull String application) {
        return new ImageRecordName(application, key, application, null);
    }

    public static @NonNull ImageRecordName fromFile(@NonNull File sourceFile) {
        String filename = sourceFile.getName();
        return new ImageRecordName(filename, filename, filename, null);
    }

    public static @NonNull ImageRecordName fromZipEntry(@NonNull File sourceFile, @NonNull String zipEntryName) {
        int zipLastSlashPos = zipEntryName.lastIndexOf(47);
        String filename = zipEntryName.substring(zipLastSlashPos + 1);
        return new ImageRecordName(String.format("%s/%s", sourceFile.getName(), zipEntryName), String.format("%s:%s", sourceFile.getName(), zipEntryName), filename, zipEntryName);
    }

    private ImageRecordName(@NonNull String dbPath, @NonNull String keyName, @NonNull String componentName, @Nullable String entryName) {
        this.dbPath = dbPath;
        this.keyName = keyName;
        this.componentName = componentName;
        this.entryName = entryName;
    }

    @Override
    public int compareTo(@NonNull ImageRecordName o) {
        return this.keyName.compareTo(o.keyName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImageRecordName) {
            ImageRecordName that = (ImageRecordName)obj;
            return this.keyName.contentEquals(that.keyName);
        }
        return false;
    }

    public @NonNull String getComponentName() {
        return this.componentName;
    }

    public @Nullable String getEntityName() {
        return this.entryName;
    }

    public @NonNull File getImagePath(@NonNull File imagesDirectory) {
        return new File(imagesDirectory, File.separatorChar != '/' ? this.dbPath.replace('/', File.separatorChar) : this.dbPath);
    }

    public @NonNull String getKeyName() {
        return this.keyName;
    }

    public int hashCode() {
        return this.keyName.hashCode();
    }

    public String toString() {
        return this.keyName;
    }
}

